<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Department extends Model
{
    use HasFactory;
    
    protected $fillable = [
        'name',
        'description',
        'code',
        'manager_name',
        'manager_email',
        'is_active'
    ];
    
    protected $casts = [
        'is_active' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];
    
    /**
     * Get users in this department
     */
    public function users()
    {
        return $this->hasMany(User::class, 'department', 'name');
    }
    
    /**
     * Scope for active departments
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }
    
    /**
     * Get user count attribute
     */
    public function getUsersCountAttribute()
    {
        return $this->users()->count();
    }
}