<?php

namespace App\Models\Warehouse;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ItemType extends Model
{
    use HasFactory;

    protected $fillable = [
        'type_name',
        'type_code',
        'description',
        'status',
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    /**
     * Relationship: A type has many items
     */
    public function items()
    {
        return $this->hasMany(Item::class, 'item_type_id');
    }

    /**
     * Scope for searching item types by name or code.
     */
    public function scopeSearch($query, $search)
    {
        if (empty($search)) {
            return $query;
        }

        return $query->where(function ($q) use ($search) {
            $q->where('type_name', 'LIKE', "%{$search}%")
              ->orWhere('type_code', 'LIKE', "%{$search}%")
              ->orWhere('description', 'LIKE', "%{$search}%");
        });
    }

    /**
     * Scope for active item types
     */
    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }
}