<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Add new fields for enhanced user management
            $table->string('first_name')->nullable()->after('name');
            $table->string('last_name')->nullable()->after('first_name');
            $table->string('phone')->nullable()->after('email');
            $table->string('department')->nullable()->after('phone');
            $table->string('employee_id')->unique()->nullable()->after('department');
            $table->string('avatar')->nullable()->after('employee_id');
            $table->foreignId('role_id')->nullable()->constrained()->onDelete('set null')->after('avatar');
            $table->enum('status', ['active', 'inactive', 'suspended'])->default('active')->after('role_id');
            $table->boolean('first_login')->default(true)->after('status');
            $table->foreignId('created_by_admin_id')->nullable()->constrained('users')->onDelete('set null')->after('first_login');
            $table->timestamp('last_login_at')->nullable()->after('created_by_admin_id');
            $table->string('last_login_ip')->nullable()->after('last_login_at');
            
            // Make name nullable since we'll use first_name + last_name
            $table->string('name')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign(['role_id']);
            $table->dropForeign(['created_by_admin_id']);
            $table->dropColumn([
                'first_name',
                'last_name', 
                'phone',
                'department',
                'employee_id',
                'avatar',
                'role_id',
                'status',
                'first_login',
                'created_by_admin_id',
                'last_login_at',
                'last_login_ip'
            ]);
            
            $table->string('name')->nullable(false)->change();
        });
    }
};
