<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('projects', function (Blueprint $table) {
            // Drop foreign key constraint first
            $table->dropForeign(['division_id']);

            // Drop unnecessary columns
            $table->dropColumn([
                'project_number',
                'division_id',
                'location',
                'start_date',
                'end_date',
                'project_manager',
                'status',
                'notes'
            ]);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('projects', function (Blueprint $table) {
            // Re-add the columns if needed to rollback
            $table->string('project_number', 50)->unique();
            $table->foreignId('division_id')->constrained('departments')->onDelete('restrict');
            $table->string('location')->nullable();
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->string('project_manager')->nullable();
            $table->enum('status', ['planning', 'active', 'on_hold', 'completed', 'cancelled'])->default('active');
            $table->text('notes')->nullable();

            $table->index('project_number');
            $table->index('division_id');
            $table->index('status');
        });
    }
};
