<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('incoming_transactions', function (Blueprint $table) {
            $table->id();
            $table->date('transaction_date');
            $table->foreignId('supplier_id')->constrained('suppliers')->onDelete('restrict');
            $table->string('lpo_number', 50)->nullable();
            $table->string('delivery_note_number', 50)->nullable();
            $table->foreignId('division_id')->constrained('departments')->onDelete('restrict');
            $table->decimal('total_amount', 15, 2)->default(0);
            $table->foreignId('received_by')->constrained('users')->onDelete('restrict');
            $table->enum('status', ['pending', 'completed', 'cancelled'])->default('pending');
            $table->text('notes')->nullable();
            $table->timestamps();

            $table->index('transaction_date');
            $table->index('supplier_id');
            $table->index('lpo_number');
            $table->index('delivery_note_number');
            $table->index('division_id');
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('incoming_transactions');
    }
};
