<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('projects', function (Blueprint $table) {
            $table->string('project_number')->unique()->nullable()->after('id');
            $table->unsignedBigInteger('project_division_id')->nullable()->after('project_number');

            $table->foreign('project_division_id')->references('id')->on('project_divisions')->onDelete('set null');
            $table->index(['project_number']);
            $table->index(['project_division_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('projects', function (Blueprint $table) {
            $table->dropForeign(['project_division_id']);
            $table->dropIndex(['project_number']);
            $table->dropIndex(['project_division_id']);
            $table->dropColumn(['project_number', 'project_division_id']);
        });
    }
};
