<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Clean up seed data from items table (delete by item codes)
        DB::table('items')->whereIn('item_code', [
            // Construction Materials
            'CM-001', 'CM-002', 'CM-003',
            // Electrical Equipment
            'EE-001', 'EE-002', 'EE-003',
            // Plumbing Supplies
            'PS-001', 'PS-002', 'PS-003',
            // Safety Equipment
            'SE-001', 'SE-002',
            // Tools & Hardware
            'TH-001', 'TH-002',
            // Fasteners
            'FS-001', 'FS-002',
            // Paints & Coatings
            'PC-001', 'PC-002',
        ])->delete();

        // Clean up seed data from item_categories table (delete by category names)
        DB::table('item_categories')->whereIn('category_name', [
            'Construction Materials',
            'Electrical Equipment',
            'Plumbing Supplies',
            'Safety Equipment',
            'Tools & Hardware',
            'Fasteners',
            'Paints & Coatings',
            'HVAC Equipment',
            'Roofing Materials',
            'Flooring Materials',
        ])->delete();
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Re-seed the data if needed (rollback)
        // You can call the seeders here if you want to restore the data
        // $this->call([
        //     ItemCategorySeeder::class,
        //     ItemSeeder::class,
        // ]);
    }
};