<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('material_transfer_issue_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('transfer_issue_id')->constrained('material_transfer_issues')->onDelete('cascade');
            $table->foreignId('transfer_request_item_id')->constrained('material_transfer_request_items')->onDelete('restrict');
            $table->foreignId('item_id')->constrained('items')->onDelete('restrict');

            // Quantity Tracking
            $table->decimal('quantity_requested', 10, 2);
            $table->decimal('quantity_issued', 10, 2);
            $table->decimal('quantity_received', 10, 2)->default(0);
            $table->decimal('quantity_rejected', 10, 2)->default(0);
            $table->string('unit_of_measure')->nullable();

            // Pricing Information
            $table->decimal('unit_price', 10, 2);
            $table->decimal('total_value', 15, 2);

            // Batch & Serial Information
            $table->string('batch_number')->nullable();
            $table->string('serial_numbers')->nullable(); // JSON array for multiple serials
            $table->date('manufacturing_date')->nullable();
            $table->date('expiry_date')->nullable();

            // Source Location in Transferrer Project
            $table->string('source_location')->nullable();
            $table->text('source_notes')->nullable();

            // Quality Information
            $table->enum('condition', ['new', 'good', 'fair', 'poor'])->default('good');
            $table->text('condition_notes')->nullable();

            // Receipt Status
            $table->enum('receipt_status', ['pending', 'received', 'partial', 'rejected', 'damaged'])->default('pending');
            $table->text('receipt_notes')->nullable();

            $table->timestamps();

            // Indexes
            $table->index(['transfer_issue_id']);
            $table->index(['transfer_request_item_id']);
            $table->index(['item_id']);
            $table->index(['receipt_status']);
            $table->index(['batch_number']);
            $table->index(['expiry_date']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('material_transfer_issue_items');
    }
};