<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('project_inventory', function (Blueprint $table) {
            $table->id();
            $table->foreignId('project_id')->constrained('projects')->onDelete('cascade');
            $table->foreignId('item_id')->constrained('items')->onDelete('cascade');

            // Quantity tracking
            $table->decimal('quantity_available', 10, 2)->default(0);
            $table->decimal('allocated_quantity', 10, 2)->default(0); // Reserved for transfers

            // Pricing
            $table->decimal('unit_price', 10, 2)->nullable();
            $table->decimal('total_value', 15, 2)->default(0);

            $table->timestamps();

            // Indexes
            $table->unique(['project_id', 'item_id']);
            $table->index(['project_id']);
            $table->index(['item_id']);
            $table->index(['quantity_available']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('project_inventory');
    }
};