<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('incoming_operations', function (Blueprint $table) {
            $table->unsignedBigInteger('material_transfer_id')->nullable()->after('direct_delivery_id');
            $table->foreign('material_transfer_id')->references('id')->on('material_transfer_requests')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('incoming_operations', function (Blueprint $table) {
            $table->dropForeign(['material_transfer_id']);
            $table->dropColumn('material_transfer_id');
        });
    }
};