<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('material_transfer_requests', function (Blueprint $table) {
            // Remove delivery type and related fields to simplify material requests
            // Focus on item selection management only
            $table->dropForeign(['direct_delivery_id']);
            $table->dropIndex(['delivery_type']);
            $table->dropIndex(['direct_delivery_id']);
            $table->dropColumn(['delivery_type', 'direct_delivery_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('material_transfer_requests', function (Blueprint $table) {
            // Restore delivery type fields if needed to rollback
            $table->enum('delivery_type', ['inventory_delivery', 'supplier_delivery'])
                ->default('inventory_delivery')
                ->after('transfer_request_number');

            $table->foreignId('direct_delivery_id')
                ->nullable()
                ->after('delivery_type')
                ->constrained('direct_deliveries')
                ->onDelete('set null');

            $table->index(['delivery_type']);
            $table->index(['direct_delivery_id']);
        });
    }
};
