CREATE TABLE IF NOT EXISTS "migrations"(
  "id" integer primary key autoincrement not null,
  "migration" varchar not null,
  "batch" integer not null
);
CREATE TABLE IF NOT EXISTS "password_reset_tokens"(
  "email" varchar not null,
  "token" varchar not null,
  "created_at" datetime,
  primary key("email")
);
CREATE TABLE IF NOT EXISTS "sessions"(
  "id" varchar not null,
  "user_id" integer,
  "ip_address" varchar,
  "user_agent" text,
  "payload" text not null,
  "last_activity" integer not null,
  primary key("id")
);
CREATE INDEX "sessions_user_id_index" on "sessions"("user_id");
CREATE INDEX "sessions_last_activity_index" on "sessions"("last_activity");
CREATE TABLE IF NOT EXISTS "cache"(
  "key" varchar not null,
  "value" text not null,
  "expiration" integer not null,
  primary key("key")
);
CREATE TABLE IF NOT EXISTS "cache_locks"(
  "key" varchar not null,
  "owner" varchar not null,
  "expiration" integer not null,
  primary key("key")
);
CREATE TABLE IF NOT EXISTS "jobs"(
  "id" integer primary key autoincrement not null,
  "queue" varchar not null,
  "payload" text not null,
  "attempts" integer not null,
  "reserved_at" integer,
  "available_at" integer not null,
  "created_at" integer not null
);
CREATE INDEX "jobs_queue_index" on "jobs"("queue");
CREATE TABLE IF NOT EXISTS "job_batches"(
  "id" varchar not null,
  "name" varchar not null,
  "total_jobs" integer not null,
  "pending_jobs" integer not null,
  "failed_jobs" integer not null,
  "failed_job_ids" text not null,
  "options" text,
  "cancelled_at" integer,
  "created_at" integer not null,
  "finished_at" integer,
  primary key("id")
);
CREATE TABLE IF NOT EXISTS "failed_jobs"(
  "id" integer primary key autoincrement not null,
  "uuid" varchar not null,
  "connection" text not null,
  "queue" text not null,
  "payload" text not null,
  "exception" text not null,
  "failed_at" datetime not null default CURRENT_TIMESTAMP
);
CREATE UNIQUE INDEX "failed_jobs_uuid_unique" on "failed_jobs"("uuid");
CREATE TABLE IF NOT EXISTS "products"(
  "id" integer primary key autoincrement not null,
  "name" varchar not null,
  "slug" varchar not null,
  "description" text,
  "features" text,
  "category" varchar not null,
  "image" varchar,
  "gallery" text,
  "is_featured" tinyint(1) not null default '0',
  "is_active" tinyint(1) not null default '1',
  "order" integer not null default '0',
  "created_at" datetime,
  "updated_at" datetime
);
CREATE UNIQUE INDEX "products_slug_unique" on "products"("slug");
CREATE TABLE IF NOT EXISTS "news"(
  "id" integer primary key autoincrement not null,
  "title" varchar not null,
  "slug" varchar not null,
  "content" text not null,
  "excerpt" text,
  "category" varchar,
  "image" varchar,
  "published_at" datetime,
  "is_featured" tinyint(1) not null default '0',
  "is_active" tinyint(1) not null default '1',
  "order" integer not null default '0',
  "created_at" datetime,
  "updated_at" datetime
);
CREATE UNIQUE INDEX "news_slug_unique" on "news"("slug");
CREATE TABLE IF NOT EXISTS "footer_menus"(
  "id" integer primary key autoincrement not null,
  "title" varchar not null,
  "slug" varchar not null,
  "order" integer not null default '0',
  "is_active" tinyint(1) not null default '1',
  "created_at" datetime,
  "updated_at" datetime
);
CREATE UNIQUE INDEX "footer_menus_slug_unique" on "footer_menus"("slug");
CREATE TABLE IF NOT EXISTS "footer_menu_items"(
  "id" integer primary key autoincrement not null,
  "footer_menu_id" integer not null,
  "title" varchar not null,
  "url" varchar not null,
  "order" integer not null default '0',
  "is_active" tinyint(1) not null default '1',
  "created_at" datetime,
  "updated_at" datetime,
  foreign key("footer_menu_id") references "footer_menus"("id") on delete cascade
);
CREATE TABLE IF NOT EXISTS "settings"(
  "id" integer primary key autoincrement not null,
  "key" varchar not null,
  "value" text,
  "type" varchar check("type" in('string', 'text', 'json')) not null default 'string',
  "description" varchar,
  "created_at" datetime,
  "updated_at" datetime
);
CREATE UNIQUE INDEX "settings_key_unique" on "settings"("key");
CREATE TABLE IF NOT EXISTS "job_positions"(
  "id" integer primary key autoincrement not null,
  "title" varchar not null,
  "description" text not null,
  "location" varchar not null,
  "experience" varchar not null,
  "tags" text,
  "type" varchar check("type" in('full-time', 'part-time', 'contract', 'internship')) not null default 'full-time',
  "is_active" tinyint(1) not null default '1',
  "posted_at" datetime,
  "created_at" datetime,
  "updated_at" datetime
);
CREATE TABLE IF NOT EXISTS "job_applications"(
  "id" integer primary key autoincrement not null,
  "job_position_id" integer not null,
  "first_name" varchar not null,
  "last_name" varchar not null,
  "email" varchar not null,
  "phone" varchar not null,
  "cover_letter" text,
  "resume_path" varchar,
  "status" varchar check("status" in('pending', 'reviewed', 'accepted', 'rejected')) not null default 'pending',
  "created_at" datetime,
  "updated_at" datetime,
  foreign key("job_position_id") references "job_positions"("id") on delete cascade
);
CREATE TABLE IF NOT EXISTS "career_enquiries"(
  "id" integer primary key autoincrement not null,
  "first_name" varchar not null,
  "last_name" varchar not null,
  "email" varchar not null,
  "phone" varchar,
  "enquiry_type" varchar check("enquiry_type" in('cv-submission', 'coop-request', 'general-enquiry', 'internship')) not null,
  "message" text not null,
  "cv_path" varchar,
  "status" varchar check("status" in('new', 'reviewed', 'contacted', 'archived')) not null default 'new',
  "created_at" datetime,
  "updated_at" datetime
);
CREATE TABLE IF NOT EXISTS "roles"(
  "id" integer primary key autoincrement not null,
  "name" varchar not null,
  "display_name" varchar not null,
  "description" text,
  "is_active" tinyint(1) not null default '1',
  "created_at" datetime,
  "updated_at" datetime
);
CREATE UNIQUE INDEX "roles_name_unique" on "roles"("name");
CREATE TABLE IF NOT EXISTS "permissions"(
  "id" integer primary key autoincrement not null,
  "name" varchar not null,
  "display_name" varchar not null,
  "description" text,
  "group" varchar,
  "created_at" datetime,
  "updated_at" datetime
);
CREATE UNIQUE INDEX "permissions_name_unique" on "permissions"("name");
CREATE TABLE IF NOT EXISTS "role_permissions"(
  "id" integer primary key autoincrement not null,
  "role_id" integer not null,
  "permission_id" integer not null,
  "created_at" datetime,
  "updated_at" datetime,
  foreign key("role_id") references "roles"("id") on delete cascade,
  foreign key("permission_id") references "permissions"("id") on delete cascade
);
CREATE UNIQUE INDEX "role_permissions_role_id_permission_id_unique" on "role_permissions"(
  "role_id",
  "permission_id"
);
CREATE TABLE IF NOT EXISTS "users"(
  "id" integer primary key autoincrement not null,
  "name" varchar,
  "email" varchar not null,
  "email_verified_at" datetime,
  "password" varchar not null,
  "remember_token" varchar,
  "created_at" datetime,
  "updated_at" datetime,
  "first_name" varchar,
  "last_name" varchar,
  "phone" varchar,
  "department" varchar,
  "employee_id" varchar,
  "avatar" varchar,
  "role_id" integer,
  "status" varchar check("status" in('active', 'inactive', 'suspended')) not null default 'active',
  "first_login" tinyint(1) not null default '1',
  "created_by_admin_id" integer,
  "last_login_at" datetime,
  "last_login_ip" varchar,
  foreign key("role_id") references "roles"("id") on delete set null,
  foreign key("created_by_admin_id") references "users"("id") on delete set null
);
CREATE UNIQUE INDEX "users_email_unique" on "users"("email");
CREATE UNIQUE INDEX "users_employee_id_unique" on "users"("employee_id");
CREATE TABLE IF NOT EXISTS "user_activities"(
  "id" integer primary key autoincrement not null,
  "user_id" integer not null,
  "action" varchar not null,
  "description" text,
  "properties" text,
  "ip_address" varchar,
  "user_agent" text,
  "subject_type" varchar,
  "subject_id" integer,
  "created_at" datetime,
  "updated_at" datetime,
  foreign key("user_id") references "users"("id") on delete cascade
);
CREATE INDEX "user_activities_user_id_created_at_index" on "user_activities"(
  "user_id",
  "created_at"
);
CREATE INDEX "user_activities_action_created_at_index" on "user_activities"(
  "action",
  "created_at"
);
CREATE INDEX "user_activities_subject_type_subject_id_index" on "user_activities"(
  "subject_type",
  "subject_id"
);
CREATE TABLE IF NOT EXISTS "departments"(
  "id" integer primary key autoincrement not null,
  "name" varchar not null,
  "description" varchar,
  "code" varchar,
  "manager_name" varchar,
  "manager_email" varchar,
  "is_active" tinyint(1) not null default '1',
  "created_at" datetime,
  "updated_at" datetime
);
CREATE UNIQUE INDEX "departments_name_unique" on "departments"("name");
CREATE UNIQUE INDEX "departments_code_unique" on "departments"("code");
CREATE INDEX "departments_is_active_index" on "departments"("is_active");

INSERT INTO migrations VALUES(1,'0001_01_01_000000_create_users_table',1);
INSERT INTO migrations VALUES(2,'0001_01_01_000001_create_cache_table',1);
INSERT INTO migrations VALUES(3,'0001_01_01_000002_create_jobs_table',1);
INSERT INTO migrations VALUES(4,'2025_09_26_173417_create_products_table',1);
INSERT INTO migrations VALUES(5,'2025_09_26_173431_create_news_table',1);
INSERT INTO migrations VALUES(6,'2025_09_26_173444_create_footer_menus_table',1);
INSERT INTO migrations VALUES(7,'2025_09_26_173456_create_footer_menu_items_table',1);
INSERT INTO migrations VALUES(8,'2025_09_26_173508_create_settings_table',1);
INSERT INTO migrations VALUES(9,'2025_09_29_091459_create_job_positions_table',2);
INSERT INTO migrations VALUES(10,'2025_09_29_121730_create_job_applications_table',3);
INSERT INTO migrations VALUES(11,'2025_09_29_172218_create_career_enquiries_table',4);
INSERT INTO migrations VALUES(12,'2025_09_30_063355_create_roles_table',5);
INSERT INTO migrations VALUES(13,'2025_09_30_063413_create_permissions_table',5);
INSERT INTO migrations VALUES(14,'2025_09_30_063430_create_role_permissions_table',5);
INSERT INTO migrations VALUES(15,'2025_09_30_063448_enhance_users_table',5);
INSERT INTO migrations VALUES(16,'2025_09_30_063530_create_user_activities_table',5);
INSERT INTO migrations VALUES(17,'2025_09_30_072133_create_departments_table',6);
