<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Role;
use App\Models\Department;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get the warehouse manager role
        $warehouseManagerRole = Role::where('name', 'warehouse_manager')->first();

        // Get or create a department (using existing departments table)
        $department = Department::first();
        if (!$department) {
            $department = Department::create([
                'name' => 'Administration',
                'description' => 'Administrative Department',
                'code' => 'ADM',
                'manager_name' => 'KCG Administrator',
                'manager_email' => 'admin@kcg.com',
                'is_active' => true
            ]);
        }

        // Create KCG admin user with specified credentials
        $adminUser = User::firstOrCreate(
            ['email' => 'admin@kcg.com'],
            [
                'name' => 'KCG Administrator',
                'first_name' => 'KCG',
                'last_name' => 'Administrator',
                'email' => 'admin@kcg.com',
                'password' => Hash::make('Qwerty@123'),
                'phone' => '+971-50-123-4567',
                'department' => $department->name,
                'employee_id' => 'KCG-ADM-001',
                'role_id' => $warehouseManagerRole ? $warehouseManagerRole->id : null,
                'status' => 'active',
                'first_login' => false,
                'email_verified_at' => now(),
            ]
        );

        // Create additional warehouse users for testing
        $this->createWarehouseTestUsers($department);

        $this->command->info('KCG Admin user created successfully!');
        $this->command->info('Email: admin@kcg.com');
        $this->command->info('Password: Qwerty@123');
        $this->command->info('Role: Warehouse Manager (Full Access)');
    }

    /**
     * Create additional warehouse test users
     */
    private function createWarehouseTestUsers($department)
    {
        $roles = [
            'warehouse_supervisor' => [
                'name' => 'Warehouse Supervisor',
                'first_name' => 'Ahmed',
                'last_name' => 'Al-Mansouri',
                'email' => 'supervisor@kcg.com',
                'employee_id' => 'KCG-SUP-001'
            ],
            'warehouse_clerk' => [
                'name' => 'Warehouse Clerk',
                'first_name' => 'Sara',
                'last_name' => 'Mohammed',
                'email' => 'clerk@kcg.com',
                'employee_id' => 'KCG-CLK-001'
            ],
            'project_manager' => [
                'name' => 'Project Manager',
                'first_name' => 'Omar',
                'last_name' => 'Hassan',
                'email' => 'pm@kcg.com',
                'employee_id' => 'KCG-PM-001'
            ],
            'warehouse_viewer' => [
                'name' => 'Warehouse Auditor',
                'first_name' => 'Fatima',
                'last_name' => 'Al-Zahra',
                'email' => 'auditor@kcg.com',
                'employee_id' => 'KCG-AUD-001'
            ]
        ];

        foreach ($roles as $roleName => $userData) {
            $role = Role::where('name', $roleName)->first();

            if ($role) {
                User::firstOrCreate(
                    ['email' => $userData['email']],
                    [
                        'name' => $userData['name'],
                        'first_name' => $userData['first_name'],
                        'last_name' => $userData['last_name'],
                        'email' => $userData['email'],
                        'password' => Hash::make('password123'),
                        'phone' => '+971-50-' . rand(100, 999) . '-' . rand(1000, 9999),
                        'department' => $department->name,
                        'employee_id' => $userData['employee_id'],
                        'role_id' => $role->id,
                        'status' => 'active',
                        'first_login' => false,
                        'email_verified_at' => now(),
                    ]
                );
            }
        }
    }
}
