<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Role;
use Illuminate\Support\Facades\Hash;

class DemoUserSeeder extends Seeder
{
    public function run(): void
    {
        $roles = Role::all()->keyBy('name');
        
        // Super Admin User
        User::firstOrCreate(
            ['email' => 'super@admin.com'],
            [
                'first_name' => 'Super',
                'last_name' => 'Admin',
                'password' => Hash::make('password'),
                'role_id' => $roles['super_admin']->id,
                'status' => 'active',
                'employee_id' => 'EMP001',
                'department' => 'IT Administration',
                'phone' => '+1-555-0001',
                'first_login' => false,
                'last_login_at' => now(),
                'email_verified_at' => now(),
            ]
        );

        // Admin User
        User::firstOrCreate(
            ['email' => 'admin@aufg.com'],
            [
                'first_name' => 'John',
                'last_name' => 'Admin',
                'password' => Hash::make('password'),
                'role_id' => $roles['admin']->id,
                'status' => 'active',
                'employee_id' => 'EMP002',
                'department' => 'Administration',
                'phone' => '+1-555-0002',
                'first_login' => false,
                'last_login_at' => now()->subDays(2),
                'email_verified_at' => now(),
            ]
        );

        // HR Manager
        User::firstOrCreate(
            ['email' => 'hr@aufg.com'],
            [
                'first_name' => 'Sarah',
                'last_name' => 'Johnson',
                'password' => Hash::make('password'),
                'role_id' => $roles['hr_manager']->id,
                'status' => 'active',
                'employee_id' => 'EMP003',
                'department' => 'Human Resources',
                'phone' => '+1-555-0003',
                'first_login' => false,
                'last_login_at' => now()->subHours(6),
                'email_verified_at' => now(),
            ]
        );

        // Viewer User
        User::firstOrCreate(
            ['email' => 'viewer@aufg.com'],
            [
                'first_name' => 'Mike',
                'last_name' => 'Viewer',
                'password' => Hash::make('password'),
                'role_id' => $roles['viewer']->id,
                'status' => 'active',
                'employee_id' => 'EMP004',
                'department' => 'General',
                'phone' => '+1-555-0004',
                'first_login' => true, // This user hasn't logged in yet
                'email_verified_at' => now(),
            ]
        );

        // Inactive User
        User::firstOrCreate(
            ['email' => 'inactive@aufg.com'],
            [
                'first_name' => 'Jane',
                'last_name' => 'Inactive',
                'password' => Hash::make('password'),
                'role_id' => $roles['viewer']->id,
                'status' => 'inactive',
                'employee_id' => 'EMP005',
                'department' => 'Marketing',
                'phone' => '+1-555-0005',
                'first_login' => false,
                'last_login_at' => now()->subMonths(2),
                'email_verified_at' => now(),
            ]
        );

        $this->command->info('Demo users created successfully!');
        $this->command->info('Login credentials:');
        $this->command->info('Super Admin: super@admin.com / password');
        $this->command->info('Admin: admin@aufg.com / password');
        $this->command->info('HR Manager: hr@aufg.com / password');
        $this->command->info('Viewer: viewer@aufg.com / password');
    }
}