<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\JobPosition;
use Carbon\Carbon;

class JobSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $jobs = [
            [
                'title' => 'Production Engineer',
                'description' => 'Lead production optimization initiatives and ensure quality standards in our glass manufacturing operations. Work with cutting-edge technology to improve efficiency and implement process improvements.',
                'location' => 'Yanbu, Saudi Arabia',
                'experience' => '3-5 years experience',
                'tags' => ['Engineering', 'Manufacturing', 'Full-time'],
                'type' => 'full-time',
                'is_active' => true,
                'posted_at' => Carbon::now()->subDays(2),
            ],
            [
                'title' => 'Sales Manager',
                'description' => 'Drive sales growth and build strong relationships with key clients in the glass industry. Develop strategic partnerships and expand market presence across Saudi Arabia and the region.',
                'location' => 'Riyadh, Saudi Arabia', 
                'experience' => '5+ years experience',
                'tags' => ['Sales', 'Management', 'Full-time'],
                'type' => 'full-time',
                'is_active' => true,
                'posted_at' => Carbon::now()->subDays(5),
            ],
            [
                'title' => 'Quality Control Specialist',
                'description' => 'Ensure product quality meets international standards through comprehensive testing and inspection processes. Implement quality assurance procedures and continuous improvement initiatives.',
                'location' => 'Yanbu, Saudi Arabia',
                'experience' => '2-4 years experience', 
                'tags' => ['Quality', 'Testing', 'Full-time'],
                'type' => 'full-time',
                'is_active' => true,
                'posted_at' => Carbon::now()->subDays(1),
            ],
            [
                'title' => 'Maintenance Technician',
                'description' => 'Perform preventive and corrective maintenance on glass manufacturing equipment. Ensure optimal machine performance and minimize downtime through proactive maintenance strategies.',
                'location' => 'Yanbu, Saudi Arabia',
                'experience' => '2-3 years experience',
                'tags' => ['Maintenance', 'Technical', 'Full-time'],
                'type' => 'full-time',
                'is_active' => true,
                'posted_at' => Carbon::now()->subDays(3),
            ],
            [
                'title' => 'Marketing Coordinator',
                'description' => 'Support marketing initiatives and brand development activities. Coordinate with internal teams and external agencies to execute marketing campaigns and promotional activities.',
                'location' => 'Riyadh, Saudi Arabia',
                'experience' => '1-3 years experience',
                'tags' => ['Marketing', 'Coordination', 'Full-time'],
                'type' => 'full-time',
                'is_active' => true,
                'posted_at' => Carbon::now()->subDays(4),
            ]
        ];

        foreach ($jobs as $job) {
            JobPosition::create($job);
        }
    }
}
