<?php

namespace Database\Seeders;

use App\Models\News;
use Illuminate\Database\Seeder;

class NewsSeeder extends Seeder
{
    public function run(): void
    {
        $newsArticles = [
            [
                'title' => 'UFG Announces Strategic Expansion Plans for 2025',
                'slug' => 'ufg-announces-strategic-expansion-plans-for-2025',
                'excerpt' => 'We are excited to share our ambitious growth strategy that includes new product lines, expanded market presence, and enhanced operational capabilities.',
                'content' => '<p>United Float Glass (UFG) is pleased to announce its comprehensive strategic expansion plans for 2025, marking a significant milestone in the company\'s growth trajectory.</p>',
                'category' => 'company',
                'image' => 'images/news/expansion-2025.jpg',
                'is_featured' => true,
                'is_active' => true,
                'published_at' => now()->subDays(5),
                'order' => 1,
            ],
            [
                'title' => 'Q4 2024 Financial Results Show Strong Performance',
                'slug' => 'q4-2024-financial-results-show-strong-performance',
                'excerpt' => 'UFG reports strong Q4 2024 financial results with 18% revenue growth and improved profitability across all business segments.',
                'content' => '<p>UFG is pleased to announce strong financial performance for Q4 2024, demonstrating the company\'s resilience and strategic execution.</p>',
                'category' => 'company',
                'image' => 'images/news/financial-results-q4.jpg',
                'is_featured' => false,
                'is_active' => true,
                'published_at' => now()->subDays(12),
                'order' => 2,
            ],
            [
                'title' => 'New Sustainability Initiative: Path to Carbon Neutrality by 2030',
                'slug' => 'new-sustainability-initiative-path-to-carbon-neutrality-by-2030',
                'excerpt' => 'UFG launches comprehensive sustainability program to achieve carbon neutrality by 2030 through renewable energy initiatives.',
                'content' => '<p>UFG is proud to announce our comprehensive sustainability initiative aimed at achieving carbon neutrality by 2030.</p>',
                'category' => 'sustainability',
                'image' => 'images/news/sustainability-initiative.jpg',
                'is_featured' => true,
                'is_active' => true,
                'published_at' => now()->subDays(18),
                'order' => 3,
            ],
            [
                'title' => 'Award-Winning Product Innovation Recognized by Industry',
                'slug' => 'award-winning-product-innovation-recognized-by-industry',
                'excerpt' => 'UFG receives prestigious Glass Innovation Award 2024 for groundbreaking Crystal Fusion decorative glass series.',
                'content' => '<p>We are honored to receive the prestigious Glass Innovation Award 2024 for our Crystal Fusion decorative glass series.</p>',
                'category' => 'innovation',
                'image' => 'images/news/innovation-award.jpg',
                'is_featured' => false,
                'is_active' => true,
                'published_at' => now()->subDays(25),
                'order' => 4,
            ],
            [
                'title' => 'UFG Participates in International Glass Technology Conference',
                'slug' => 'ufg-participates-in-international-glass-technology-conference',
                'excerpt' => 'UFG showcases innovations at the International Glass Technology Conference 2024 in Dubai.',
                'content' => '<p>UFG was proud to participate in the International Glass Technology Conference 2024 held in Dubai.</p>',
                'category' => 'events',
                'image' => 'images/news/conference-dubai.jpg',
                'is_featured' => false,
                'is_active' => true,
                'published_at' => now()->subDays(35),
                'order' => 5,
            ],
            [
                'title' => 'New Quality Certifications Strengthen Global Standards',
                'slug' => 'new-quality-certifications-strengthen-global-standards',
                'excerpt' => 'UFG achieves ISO 14001, ISO 45001, and ASTM certifications, reinforcing our commitment to quality and safety.',
                'content' => '<p>UFG has successfully obtained several important international quality certifications.</p>',
                'category' => 'quality',
                'image' => 'images/news/quality-certifications.jpg',
                'is_featured' => true,
                'is_active' => true,
                'published_at' => now()->subDays(42),
                'order' => 6,
            ],
            [
                'title' => 'Strategic Partnerships with Leading Architectural Firms',
                'slug' => 'strategic-partnerships-with-leading-architectural-firms',
                'excerpt' => 'UFG announces partnerships with renowned architectural firms for innovative glass solutions.',
                'content' => '<p>UFG is excited to announce strategic partnerships with several leading architectural firms worldwide.</p>',
                'category' => 'partnerships',
                'image' => 'images/news/architectural-partnerships.jpg',
                'is_featured' => false,
                'is_active' => true,
                'published_at' => now()->subDays(50),
                'order' => 7,
            ],
            [
                'title' => 'Employee Excellence Program Launches Workforce Development',
                'slug' => 'employee-excellence-program-launches-workforce-development',
                'excerpt' => 'UFG introduces comprehensive Employee Excellence Program focusing on skills development and career advancement.',
                'content' => '<p>UFG is committed to the professional development of our employees through the new Employee Excellence Program.</p>',
                'category' => 'company',
                'image' => 'images/news/employee-excellence.jpg',
                'is_featured' => false,
                'is_active' => true,
                'published_at' => now()->subDays(60),
                'order' => 8,
            ],
        ];

        foreach ($newsArticles as $articleData) {
            News::create($articleData);
        }
    }
}