<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Page;

class PageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $pages = [
            [
                'title' => 'Home',
                'slug' => 'home',
                'route_name' => 'home',
                'meta_description' => 'Arabian United Float Glass Company (UFG) - Leading Arab manufacturer of high-quality ARALUX® glass products. Discover our comprehensive range of float glass, mirrors, and specialty glass solutions.',
                'meta_keywords' => 'UFG, Arabian United Float Glass Company, ARALUX glass, float glass, mirror glass, glass manufacturer, Saudi Arabia',
                'is_enabled' => true,
                'show_in_nav' => false, // Home usually not shown in nav as it\'s the logo link
                'sort_order' => 0,
                'template' => 'home',
                'content_sections' => [
                    'hero_section' => [
                        'title' => 'Welcome to UFG',
                        'content' => 'Arabian United Float Glass Company - Leading Arab manufacturer of high-quality glass products.',
                        'type' => 'hero',
                        'order' => 1,
                        'is_enabled' => true,
                        'settings' => [
                            'background_image' => '',
                            'video_enabled' => true,
                            'video_key' => 'hero_video'
                        ]
                    ],
                    'company_intro' => [
                        'title' => 'About UFG',
                        'content' => 'Established in 2006, UFG operates a modern manufacturing plant covering 350,000 square meters with production capacity of up to 700 tons per day.',
                        'type' => 'text_with_image',
                        'order' => 2,
                        'is_enabled' => true,
                        'settings' => [
                            'image_position' => 'right',
                            'background_color' => 'light'
                        ]
                    ],
                    'products_showcase' => [
                        'title' => 'Our Products',
                        'content' => 'Discover our comprehensive range of ARALUX® glass products including float glass, mirrors, and specialty glass solutions.',
                        'type' => 'products_carousel',
                        'order' => 3,
                        'is_enabled' => true,
                        'settings' => [
                            'show_featured_only' => true,
                            'items_per_slide' => 4
                        ]
                    ],
                    'who_we_are_video' => [
                        'title' => 'Who We Are',
                        'content' => 'Learn more about our company, values, and commitment to quality manufacturing.',
                        'type' => 'video_section',
                        'order' => 4,
                        'is_enabled' => true,
                        'settings' => [
                            'video_key' => 'who_we_are_video',
                            'layout' => 'centered'
                        ]
                    ],
                    'latest_news' => [
                        'title' => 'Latest News',
                        'content' => 'Stay updated with the latest developments and announcements from UFG.',
                        'type' => 'news_grid',
                        'order' => 5,
                        'is_enabled' => true,
                        'settings' => [
                            'items_count' => 3,
                            'show_excerpt' => true
                        ]
                    ],
                    'ufg_in_numbers' => [
                        'title' => 'UFG in Numbers',
                        'content' => 'Our achievements and milestones in numbers showcase our growth and success in the glass manufacturing industry.',
                        'type' => 'statistics_counter',
                        'order' => 6,
                        'is_enabled' => true,
                        'settings' => [
                            'background_image' => 'assets/2025/08/2d798430fc0e6ab7087749eab6eaa37312a3da9e-scaled.png',
                            'background_fixed' => true,
                            'counters' => [
                                [
                                    'title' => 'Years of experience',
                                    'number' => 19,
                                    'suffix' => '+',
                                    'icon' => 'assets/2025/08/bff9b080454c9118e8d0dbc2c1724937.png',
                                    'duration' => 2000
                                ],
                                [
                                    'title' => 'Tons/Years',
                                    'number' => 250000,
                                    'suffix' => '',
                                    'icon' => 'assets/2025/08/c93c91a50a25d4d0b6ea4930271037ed.png',
                                    'duration' => 2000
                                ],
                                [
                                    'title' => 'Market',
                                    'number' => 30,
                                    'suffix' => '+',
                                    'icon' => 'assets/2025/08/81724b2f21c4b49c246720f67b2283c1.svg',
                                    'duration' => 2000
                                ],
                                [
                                    'title' => 'Employees',
                                    'number' => 30,
                                    'suffix' => '+',
                                    'icon' => 'assets/2025/08/8394273d9fc34a498707fa6fe82c9d7a.png',
                                    'duration' => 2000
                                ]
                            ]
                        ]
                    ],
                    'contact_cta' => [
                        'title' => 'Get in Touch',
                        'content' => 'Ready to work with us? Contact our team for inquiries about our products and services.',
                        'type' => 'call_to_action',
                        'order' => 7,
                        'is_enabled' => true,
                        'settings' => [
                            'button_text' => 'Contact Us',
                            'button_link' => '/contact',
                            'background_style' => 'gradient'
                        ]
                    ]
                ]
            ],
            [
                'title' => 'About Us',
                'slug' => 'about',
                'route_name' => 'about',
                'meta_description' => 'Learn about Arabian United Float Glass Company (UFG), a leading Arab manufacturer of glass established in 2006, offering high-quality ARALUX® glass products.',
                'meta_keywords' => 'UFG, Arabian United Float Glass Company, glass manufacturer, ARALUX glass, about us, company history',
                'is_enabled' => true,
                'show_in_nav' => true,
                'sort_order' => 1,
                'template' => 'about',
                'content_sections' => [
                    'hero' => [
                        'title' => 'About UFG',
                        'content' => 'Arabian United Float Glass Company is a leading Arab manufacturer of glass, established in 2006 in the Kingdom of Saudi Arabia.',
                        'type' => 'hero',
                        'order' => 1,
                        'is_enabled' => true
                    ],
                    'company_overview' => [
                        'title' => 'Company Overview',
                        'content' => 'UFG operates a modern manufacturing plant covering an area of 350,000 square meters, with a production capacity of up to 700 tons per day.',
                        'type' => 'text',
                        'order' => 2,
                        'is_enabled' => true
                    ]
                ]
            ],
            [
                'title' => 'Contact Us',
                'slug' => 'contact',
                'route_name' => 'contact',
                'meta_description' => 'Get in touch with UFG. Contact us for inquiries about our glass products, services, or business opportunities.',
                'meta_keywords' => 'contact UFG, glass company contact, inquiries, business opportunities',
                'is_enabled' => true,
                'show_in_nav' => true,
                'sort_order' => 2,
                'template' => 'contact',
                'content_sections' => [
                    'contact_info' => [
                        'title' => 'Contact Information',
                        'content' => 'Reach out to us for any inquiries about our products and services.',
                        'type' => 'text',
                        'order' => 1,
                        'is_enabled' => true
                    ]
                ]
            ],
            [
                'title' => 'Products',
                'slug' => 'products',
                'route_name' => 'products',
                'meta_description' => 'Explore UFG\'s comprehensive range of high-quality ARALUX® glass products including float glass, mirrors, and specialty glass solutions.',
                'meta_keywords' => 'UFG products, ARALUX glass, float glass, mirrors, glass solutions',
                'is_enabled' => true,
                'show_in_nav' => true,
                'sort_order' => 3,
                'template' => 'default',
                'content_sections' => [
                    'products_intro' => [
                        'title' => 'Our Products',
                        'content' => 'UFG offers a wide range of high-quality ARALUX® glass products for various applications.',
                        'type' => 'text',
                        'order' => 1,
                        'is_enabled' => true
                    ]
                ]
            ],
            [
                'title' => 'News & Updates',
                'slug' => 'news',
                'route_name' => 'news',
                'meta_description' => 'Stay updated with the latest news, announcements, and developments from Arabian United Float Glass Company.',
                'meta_keywords' => 'UFG news, glass industry news, company announcements, updates',
                'is_enabled' => true,
                'show_in_nav' => true,
                'sort_order' => 4,
                'template' => 'default',
                'content_sections' => [
                    'news_intro' => [
                        'title' => 'Latest News',
                        'content' => 'Keep up with the latest developments and announcements from UFG.',
                        'type' => 'text',
                        'order' => 1,
                        'is_enabled' => true
                    ]
                ]
            ],
            [
                'title' => 'Careers',
                'slug' => 'careers',
                'route_name' => 'careers',
                'meta_description' => 'Join the UFG team. Explore career opportunities at Arabian United Float Glass Company and be part of our growing organization.',
                'meta_keywords' => 'UFG careers, jobs, employment opportunities, glass industry careers',
                'is_enabled' => true,
                'show_in_nav' => true,
                'sort_order' => 5,
                'template' => 'default',
                'content_sections' => [
                    'careers_intro' => [
                        'title' => 'Join Our Team',
                        'content' => 'Discover exciting career opportunities at UFG and be part of our innovative team.',
                        'type' => 'text',
                        'order' => 1,
                        'is_enabled' => true
                    ]
                ]
            ],
            [
                'title' => 'Investors',
                'slug' => 'investors',
                'route_name' => 'investors',
                'meta_description' => 'Investor relations information for Arabian United Float Glass Company including financial reports and company performance.',
                'meta_keywords' => 'UFG investors, investor relations, financial reports, company performance',
                'is_enabled' => true,
                'show_in_nav' => true,
                'sort_order' => 6,
                'template' => 'default',
                'content_sections' => [
                    'investors_intro' => [
                        'title' => 'Investor Relations',
                        'content' => 'Access financial information, reports, and updates for UFG shareholders and potential investors.',
                        'type' => 'text',
                        'order' => 1,
                        'is_enabled' => true
                    ]
                ]
            ],
            [
                'title' => 'Quality',
                'slug' => 'quality',
                'route_name' => 'quality',
                'meta_description' => 'Learn about UFG\'s commitment to quality manufacturing and our quality control processes.',
                'meta_keywords' => 'UFG quality, quality control, manufacturing standards, glass quality',
                'is_enabled' => true,
                'show_in_nav' => true,
                'sort_order' => 7,
                'template' => 'default',
                'content_sections' => [
                    'quality_intro' => [
                        'title' => 'Quality Commitment',
                        'content' => 'UFG is committed to delivering the highest quality glass products through rigorous quality control processes.',
                        'type' => 'text',
                        'order' => 1,
                        'is_enabled' => true
                    ]
                ]
            ],
            [
                'title' => 'Reports',
                'slug' => 'reports',
                'route_name' => 'reports',
                'meta_description' => 'Access UFG company reports, annual reports, and corporate publications.',
                'meta_keywords' => 'UFG reports, annual reports, corporate publications, company documents',
                'is_enabled' => true,
                'show_in_nav' => false,
                'sort_order' => 8,
                'template' => 'default',
                'content_sections' => [
                    'reports_intro' => [
                        'title' => 'Company Reports',
                        'content' => 'Download and access UFG\'s latest reports and corporate publications.',
                        'type' => 'text',
                        'order' => 1,
                        'is_enabled' => true
                    ]
                ]
            ],
            [
                'title' => 'Videos',
                'slug' => 'videos',
                'route_name' => 'videos',
                'meta_description' => 'Watch UFG corporate videos, product demonstrations, and company presentations.',
                'meta_keywords' => 'UFG videos, corporate videos, product demonstrations, company presentations',
                'is_enabled' => true,
                'show_in_nav' => false,
                'sort_order' => 9,
                'template' => 'default',
                'content_sections' => [
                    'videos_intro' => [
                        'title' => 'Corporate Videos',
                        'content' => 'Explore our collection of corporate videos and product demonstrations.',
                        'type' => 'text',
                        'order' => 1,
                        'is_enabled' => true
                    ]
                ]
            ],
            [
                'title' => 'Privacy Policy',
                'slug' => 'privacy',
                'route_name' => 'privacy',
                'meta_description' => 'UFG Privacy Policy - Learn how we collect, use, and protect your personal information.',
                'meta_keywords' => 'privacy policy, data protection, personal information, UFG privacy',
                'is_enabled' => true,
                'show_in_nav' => false,
                'sort_order' => 10,
                'template' => 'default',
                'content_sections' => [
                    'privacy_content' => [
                        'title' => 'Privacy Policy',
                        'content' => 'This Privacy Policy describes how UFG collects, uses, and protects your personal information.',
                        'type' => 'text',
                        'order' => 1,
                        'is_enabled' => true
                    ]
                ]
            ],
            [
                'title' => 'Terms of Service',
                'slug' => 'terms',
                'route_name' => 'terms',
                'meta_description' => 'UFG Terms of Service - Read our terms and conditions for using our website and services.',
                'meta_keywords' => 'terms of service, terms and conditions, website terms, UFG terms',
                'is_enabled' => true,
                'show_in_nav' => false,
                'sort_order' => 11,
                'template' => 'default',
                'content_sections' => [
                    'terms_content' => [
                        'title' => 'Terms of Service',
                        'content' => 'These Terms of Service govern your use of the UFG website and services.',
                        'type' => 'text',
                        'order' => 1,
                        'is_enabled' => true
                    ]
                ]
            ]
        ];

        foreach ($pages as $pageData) {
            Page::updateOrCreate(
                ['slug' => $pageData['slug']],
                $pageData
            );
        }
    }
}