<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ProjectSeeder extends Seeder
{
    public function run(): void
    {
        $projects = [
            [
                'project_number' => 'PRJ-2024-001',
                'project_name' => 'Downtown Office Complex',
                'project_division_id' => 2,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'project_number' => 'PRJ-2024-002',
                'project_name' => 'Sunset Residential Community',
                'project_division_id' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'project_number' => 'PRJ-2024-003',
                'project_name' => 'City Hospital Expansion',
                'project_division_id' => 5,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'project_number' => 'PRJ-2024-004',
                'project_name' => 'Highway Bridge Renovation',
                'project_division_id' => 3,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'project_number' => 'PRJ-2024-005',
                'project_name' => 'Manufacturing Facility',
                'project_division_id' => 4,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'project_number' => 'PRJ-2024-006',
                'project_name' => 'Elementary School Construction',
                'project_division_id' => 6,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'project_number' => 'PRJ-2024-007',
                'project_name' => 'Historic Building Renovation',
                'project_division_id' => 7,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'project_number' => 'PRJ-2024-008',
                'project_name' => 'Water Treatment Plant Upgrade',
                'project_division_id' => 8,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        DB::table('projects')->insert($projects);
    }
}