<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\SiteSetting;

class SiteSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $settings = [
            // General Settings
            [
                'key' => 'site_name',
                'value' => 'UFG - United Float Glass',
                'type' => 'text',
                'group' => 'general',
                'label' => 'Site Name',
                'description' => 'The name of your website',
                'is_active' => true,
                'sort_order' => 1
            ],
            [
                'key' => 'site_description',
                'value' => 'Leading manufacturer of high-quality float glass products',
                'type' => 'textarea',
                'group' => 'general',
                'label' => 'Site Description',
                'description' => 'A brief description of your website',
                'is_active' => true,
                'sort_order' => 2
            ],
            [
                'key' => 'site_logo',
                'value' => 'assets/images/aufg-logo.png',
                'type' => 'file',
                'group' => 'general',
                'label' => 'Site Logo',
                'description' => 'Upload your site logo (PNG, JPG, SVG)',
                'is_active' => true,
                'sort_order' => 3
            ],
            [
                'key' => 'site_favicon',
                'value' => 'images/favicon.ico',
                'type' => 'file',
                'group' => 'general',
                'label' => 'Site Favicon',
                'description' => 'Upload your site favicon (ICO, PNG)',
                'is_active' => true,
                'sort_order' => 4
            ],

            // Contact Information
            [
                'key' => 'contact_email',
                'value' => 'info@ufg.com',
                'type' => 'email',
                'group' => 'contact',
                'label' => 'Contact Email',
                'description' => 'Main contact email address',
                'is_active' => true,
                'sort_order' => 1
            ],
            [
                'key' => 'contact_phone',
                'value' => '+1 (555) 123-4567',
                'type' => 'phone',
                'group' => 'contact',
                'label' => 'Contact Phone',
                'description' => 'Main contact phone number',
                'is_active' => true,
                'sort_order' => 2
            ],
            [
                'key' => 'contact_address',
                'value' => '123 Glass Street, Industrial District, City, Country',
                'type' => 'textarea',
                'group' => 'contact',
                'label' => 'Contact Address',
                'description' => 'Main office address',
                'is_active' => true,
                'sort_order' => 3
            ],
            [
                'key' => 'business_hours',
                'value' => 'Monday - Friday: 8:00 AM - 6:00 PM\nSaturday: 9:00 AM - 4:00 PM\nSunday: Closed',
                'type' => 'textarea',
                'group' => 'contact',
                'label' => 'Business Hours',
                'description' => 'Operating hours',
                'is_active' => true,
                'sort_order' => 4
            ],

            // Social Media
            [
                'key' => 'facebook_url',
                'value' => 'https://facebook.com/ufg',
                'type' => 'url',
                'group' => 'social',
                'label' => 'Facebook URL',
                'description' => 'Facebook page URL',
                'is_active' => true,
                'sort_order' => 1
            ],
            [
                'key' => 'twitter_url',
                'value' => 'https://twitter.com/ufg',
                'type' => 'url',
                'group' => 'social',
                'label' => 'Twitter URL',
                'description' => 'Twitter profile URL',
                'is_active' => true,
                'sort_order' => 2
            ],
            [
                'key' => 'linkedin_url',
                'value' => 'https://linkedin.com/company/ufg',
                'type' => 'url',
                'group' => 'social',
                'label' => 'LinkedIn URL',
                'description' => 'LinkedIn company page URL',
                'is_active' => true,
                'sort_order' => 3
            ],
            [
                'key' => 'instagram_url',
                'value' => 'https://instagram.com/ufg',
                'type' => 'url',
                'group' => 'social',
                'label' => 'Instagram URL',
                'description' => 'Instagram profile URL',
                'is_active' => true,
                'sort_order' => 4
            ],

            // WhatsApp Settings
            [
                'key' => 'whatsapp_number',
                'value' => '+1234567890',
                'type' => 'text',
                'group' => 'whatsapp',
                'label' => 'WhatsApp Number',
                'description' => 'WhatsApp contact number (with country code)',
                'is_active' => true,
                'sort_order' => 1
            ],
            [
                'key' => 'whatsapp_message',
                'value' => 'Hello! I would like to inquire about your glass products.',
                'type' => 'textarea',
                'group' => 'whatsapp',
                'label' => 'Default WhatsApp Message',
                'description' => 'Default message for WhatsApp contact',
                'is_active' => true,
                'sort_order' => 2
            ],
            [
                'key' => 'whatsapp_enabled',
                'value' => '1',
                'type' => 'boolean',
                'group' => 'whatsapp',
                'label' => 'Enable WhatsApp',
                'description' => 'Enable/disable WhatsApp contact widget',
                'is_active' => true,
                'sort_order' => 3
            ],

            // SEO Settings
            [
                'key' => 'meta_title',
                'value' => 'UFG - United Float Glass | Premium Glass Manufacturing',
                'type' => 'text',
                'group' => 'seo',
                'label' => 'Meta Title',
                'description' => 'Default meta title for pages',
                'is_active' => true,
                'sort_order' => 1
            ],
            [
                'key' => 'meta_description',
                'value' => 'Leading manufacturer of high-quality float glass products for architectural and automotive applications. Premium glass solutions with international standards.',
                'type' => 'textarea',
                'group' => 'seo',
                'label' => 'Meta Description',
                'description' => 'Default meta description for pages',
                'is_active' => true,
                'sort_order' => 2
            ],
            [
                'key' => 'meta_keywords',
                'value' => 'float glass, architectural glass, automotive glass, glass manufacturing, premium glass',
                'type' => 'textarea',
                'group' => 'seo',
                'label' => 'Meta Keywords',
                'description' => 'Default meta keywords for pages',
                'is_active' => true,
                'sort_order' => 3
            ],

            // Footer Settings
            [
                'key' => 'footer_text',
                'value' => '© 2025 UFG - United Float Glass. All rights reserved.',
                'type' => 'text',
                'group' => 'footer',
                'label' => 'Footer Copyright Text',
                'description' => 'Copyright text displayed in footer',
                'is_active' => true,
                'sort_order' => 1
            ],
            [
                'key' => 'footer_description',
                'value' => 'Leading manufacturer of premium float glass products, serving architectural and automotive industries worldwide with cutting-edge technology and exceptional quality.',
                'type' => 'textarea',
                'group' => 'footer',
                'label' => 'Footer Description',
                'description' => 'Company description in footer',
                'is_active' => true,
                'sort_order' => 2
            ]
        ];

        foreach ($settings as $setting) {
            SiteSetting::updateOrCreate(
                ['key' => $setting['key']],
                $setting
            );
        }
    }
}