<?php

namespace Database\Seeders;

use App\Models\Category;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class VideoCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            [
                'name' => 'Company Overview',
                'slug' => 'company-overview',
                'description' => 'Videos showcasing company profile and corporate overview',
                'color' => '#038BB9',
                'icon' => 'business',
                'is_active' => true,
                'sort_order' => 1,
                'type' => 'video',
            ],
            [
                'name' => 'Product Showcase',
                'slug' => 'product-showcase',
                'description' => 'Product demonstrations and feature highlights',
                'color' => '#3B82F6',
                'icon' => 'inventory',
                'is_active' => true,
                'sort_order' => 2,
                'type' => 'video',
            ],
            [
                'name' => 'Manufacturing',
                'slug' => 'manufacturing-videos',
                'description' => 'Manufacturing processes and production facilities',
                'color' => '#6366F1',
                'icon' => 'precision_manufacturing',
                'is_active' => true,
                'sort_order' => 3,
                'type' => 'video',
            ],
            [
                'name' => 'Sustainability',
                'slug' => 'sustainability-videos',
                'description' => 'Environmental initiatives and sustainable practices',
                'color' => '#10B981',
                'icon' => 'eco',
                'is_active' => true,
                'sort_order' => 4,
                'type' => 'video',
            ],
            [
                'name' => 'Innovation',
                'slug' => 'innovation-videos',
                'description' => 'Innovation stories and technological breakthroughs',
                'color' => '#EC4899',
                'icon' => 'lightbulb',
                'is_active' => true,
                'sort_order' => 5,
                'type' => 'video',
            ],
            [
                'name' => 'Testimonials',
                'slug' => 'testimonials',
                'description' => 'Customer testimonials and success stories',
                'color' => '#F59E0B',
                'icon' => 'star',
                'is_active' => true,
                'sort_order' => 6,
                'type' => 'video',
            ],
            [
                'name' => 'Events',
                'slug' => 'event-videos',
                'description' => 'Event coverage, conferences, and exhibitions',
                'color' => '#8B5CF6',
                'icon' => 'event',
                'is_active' => true,
                'sort_order' => 7,
                'type' => 'video',
            ],
            [
                'name' => 'Tutorials',
                'slug' => 'tutorials',
                'description' => 'Educational content and how-to guides',
                'color' => '#EF4444',
                'icon' => 'school',
                'is_active' => true,
                'sort_order' => 8,
                'type' => 'video',
            ],
            [
                'name' => 'Behind the Scenes',
                'slug' => 'behind-scenes',
                'description' => 'Behind the scenes content and workplace culture',
                'color' => '#06B6D4',
                'icon' => 'visibility',
                'is_active' => true,
                'sort_order' => 9,
                'type' => 'video',
            ],
        ];

        foreach ($categories as $category) {
            Category::firstOrCreate(
                ['slug' => $category['slug'], 'type' => 'video'],
                $category
            );
        }

        $this->command->info('Video categories seeded successfully!');
    }
}
