// Simple admin layout initialization
document.addEventListener('DOMContentLoaded', function() {
    // Get current route for active menu highlighting
    const currentPath = window.location.pathname;
    
    // Initialize sidebar state
    let sidebarOpen = false;
    let careersMenuOpen = currentPath.includes('/admin/applications') || currentPath.includes('/admin/job-positions');
    
    // Toggle sidebar for mobile
    const mobileMenuBtn = document.querySelector('.mobile-menu-btn');
    const sidebar = document.querySelector('.admin-sidebar');
    const backdrop = document.querySelector('.mobile-backdrop');
    
    if (mobileMenuBtn) {
        mobileMenuBtn.addEventListener('click', () => {
            sidebarOpen = !sidebarOpen;
            sidebar.classList.toggle('-translate-x-full');
            if (backdrop) {
                backdrop.style.display = sidebarOpen ? 'block' : 'none';
            }
        });
    }
    
    if (backdrop) {
        backdrop.addEventListener('click', () => {
            sidebarOpen = false;
            sidebar.classList.add('-translate-x-full');
            backdrop.style.display = 'none';
        });
    }
    
    // Toggle careers dropdown
    const careersBtn = document.querySelector('.careers-menu-btn');
    const careersDropdown = document.querySelector('.careers-dropdown');
    const careersChevron = document.querySelector('.careers-chevron');
    
    if (careersBtn && careersDropdown) {
        careersBtn.addEventListener('click', () => {
            careersMenuOpen = !careersMenuOpen;
            if (careersMenuOpen) {
                careersDropdown.style.display = 'block';
                if (careersChevron) careersChevron.classList.add('rotate-180');
            } else {
                careersDropdown.style.display = 'none';
                if (careersChevron) careersChevron.classList.remove('rotate-180');
            }
        });
        
        // Set initial state
        if (careersMenuOpen) {
            careersDropdown.style.display = 'block';
            if (careersChevron) careersChevron.classList.add('rotate-180');
        }
    }
    
    // Profile dropdown functionality
    const profileBtn = document.querySelector('.profile-btn');
    const profileMenu = document.querySelector('.profile-menu');
    
    if (profileBtn && profileMenu) {
        // Toggle dropdown on click
        profileBtn.addEventListener('click', (e) => {
            e.stopPropagation();
            const isVisible = profileMenu.style.display === 'block';
            profileMenu.style.display = isVisible ? 'none' : 'block';
        });
        
        // Close dropdown when clicking outside
        document.addEventListener('click', (e) => {
            if (!e.target.closest('.profile-dropdown')) {
                profileMenu.style.display = 'none';
            }
        });
        
        // Prevent dropdown from closing when clicking inside
        profileMenu.addEventListener('click', (e) => {
            e.stopPropagation();
        });
    }
});