// Careers Page JavaScript

// Check if Alpine.js is loading
console.log('Careers.js loaded');

// Debug Alpine.js initialization
document.addEventListener('alpine:init', () => {
    console.log('Alpine.js initialized successfully');
});

// Check Alpine on window load
window.addEventListener('load', () => {
    console.log('Window loaded. Alpine available:', typeof Alpine !== 'undefined');
    const modal = document.getElementById('job-application-modal');
    if (modal) {
        console.log('Modal on window load:');
        console.log('- Display:', window.getComputedStyle(modal).display);
        console.log('- Has x-cloak:', modal.hasAttribute('x-cloak'));
        console.log('- Classes:', modal.className);
    }
});

// Early check and manual hiding if needed
document.addEventListener('DOMContentLoaded', function() {
    console.log('DOM loaded. Checking modal state...');
    const modal = document.getElementById('job-application-modal');
    const toast = document.getElementById('toast-notification');
    
    if (modal) {
        console.log('Modal on DOM ready:');
        console.log('- Display:', window.getComputedStyle(modal).display);
        console.log('- Has x-cloak:', modal.hasAttribute('x-cloak'));
        console.log('- Classes:', modal.className);
        
        // If x-cloak isn't working, manually hide until Alpine.js loads
        if (window.getComputedStyle(modal).display !== 'none') {
            console.log('x-cloak not working, manually hiding modal');
            modal.style.display = 'none';
            modal.setAttribute('data-manual-hidden', 'true');
        }
    }
    
    if (toast) {
        if (window.getComputedStyle(toast).display !== 'none') {
            console.log('x-cloak not working, manually hiding toast');
            toast.style.display = 'none';
            toast.setAttribute('data-manual-hidden', 'true');
        }
    }
});

// Remove manual hiding after Alpine.js initializes
document.addEventListener('alpine:init', () => {
    console.log('Alpine.js initialized, removing manual hiding');
    setTimeout(() => {
        const modal = document.getElementById('job-application-modal');
        const toast = document.getElementById('toast-notification');
        
        if (modal && modal.hasAttribute('data-manual-hidden')) {
            modal.removeAttribute('style');
            modal.removeAttribute('data-manual-hidden');
            console.log('Modal style cleared, Alpine.js now in control');
        }
        
        if (toast && toast.hasAttribute('data-manual-hidden')) {
            toast.removeAttribute('style');
            toast.removeAttribute('data-manual-hidden');
            console.log('Toast style cleared, Alpine.js now in control');
        }
    }, 100);
});

// Debug function to check modal state when button is clicked
document.addEventListener('DOMContentLoaded', function() {
    // Add click listener to Apply Now buttons for debugging
    setTimeout(() => {
        const applyButtons = document.querySelectorAll('button[x-on\\:click*="openApplication"], button[\\@click*="openApplication"]');
        console.log('Found apply buttons:', applyButtons.length);
        applyButtons.forEach((button, index) => {
            button.addEventListener('click', () => {
                console.log('Apply button clicked!');
                setTimeout(() => {
                    const modal = document.getElementById('job-application-modal');
                    if (modal) {
                        console.log('After click - Modal display:', window.getComputedStyle(modal).display);
                        console.log('After click - Modal visibility:', window.getComputedStyle(modal).visibility);
                        console.log('After click - Modal opacity:', window.getComputedStyle(modal).opacity);
                        console.log('After click - Modal classes:', modal.className);
                    }
                }, 500);
            });
        });
    }, 2000);
});

// Character counter for message field
document.addEventListener('DOMContentLoaded', function() {
    const messageField = document.getElementById('message');
    const charCountElement = document.getElementById('charCount');
    
    if (messageField && charCountElement) {
        messageField.addEventListener('input', function() {
            const remaining = 255 - this.value.length;
            charCountElement.textContent = remaining + ' remaining';
            
            // Change color based on remaining characters
            if (remaining < 50) {
                charCountElement.style.color = '#dc2626';
            } else if (remaining < 100) {
                charCountElement.style.color = '#f59e0b';
            } else {
                charCountElement.style.color = '#038BB9';
            }
        });
    }

    // File upload feedback
    const fileInput = document.getElementById('attachment');
    const fileLabel = document.querySelector('label[for="attachment"]');
    
    if (fileInput && fileLabel) {
        fileInput.addEventListener('change', function() {
            if (this.files.length > 0) {
                const fileName = this.files[0].name;
                fileLabel.querySelector('p').textContent = `Selected: ${fileName}`;
            }
        });
    }

    // Hiring Process Animation Script
    console.log('Setting up hiring process animations...');
    
    const hiringSection = document.getElementById('hiring-process');
    if (!hiringSection) {
        console.log('Hiring process section not found');
        return;
    }
    
    // Add classes to elements for animation  
    const processSteps = hiringSection.querySelectorAll('.space-y-16 > div');
    const centralLine = hiringSection.querySelector('.absolute.left-1\\/2.transform.-translate-x-1\\/2');
    
    // Add animation classes to steps
    processSteps.forEach((step, index) => {
        step.classList.add('hiring-process-step');
        
        // Add classes to cards and icons for hover effects
        const card = step.querySelector('.bg-white.rounded-3xl');
        const numberBadge = step.querySelector('.w-12.h-12.bg-aufg-gradient');
        
        if (card) card.classList.add('hiring-step-card');
        if (numberBadge) numberBadge.classList.add('hiring-step-number');
    });
    
    // Add class to central line
    if (centralLine) {
        centralLine.classList.add('hiring-process-line');
    }
    
    // Create intersection observer for animations
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -100px 0px'
    };
    
    const observer = new IntersectionObserver(function(entries) {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                console.log('Hiring process section is visible, starting animations');
                
                // Animate central line first
                if (centralLine) {
                    setTimeout(() => {
                        centralLine.classList.add('animate-in');
                    }, 200);
                }
                
                // Animate steps with staggered timing
                processSteps.forEach((step, index) => {
                    setTimeout(() => {
                        step.classList.add('animate-in');
                        console.log(`Step ${index + 1} animated in`);
                        
                        // Add active state to first step briefly
                        if (index === 0) {
                            setTimeout(() => {
                                step.classList.add('hiring-step-active');
                                setTimeout(() => {
                                    step.classList.remove('hiring-step-active');
                                }, 3000);
                            }, 500);
                        }
                    }, 300 + (index * 200));
                });
                
                // Stop observing after animation
                observer.unobserve(entry.target);
            }
        });
    }, observerOptions);
    
    // Start observing the hiring section
    observer.observe(hiringSection);
    
    // Add click interaction for steps
    processSteps.forEach((step, index) => {
        step.addEventListener('click', function() {
            // Remove active class from all steps
            processSteps.forEach(s => s.classList.remove('hiring-step-active'));
            // Add active class to clicked step
            this.classList.add('hiring-step-active');
            console.log(`Step ${index + 1} activated`);
        });
    });
    
    console.log('Hiring process animations initialized successfully');

    // General scroll animations
    const generalObserverOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };
    
    const generalObserver = new IntersectionObserver(function(entries) {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('animate-fade-in-up');
            }
        });
    }, generalObserverOptions);
    
    // Observe all sections
    document.querySelectorAll('section').forEach(section => {
        generalObserver.observe(section);
    });
});