<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Applications - UFG Admin</title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="{{ asset('assets/images/aufg-logo.png') }}">
    
    <!-- Vite Compiled Assets -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    
    <script>
        function appData() {
            return {
                sidebarOpen: false, 
                careersMenuOpen: {{ request()->is('admin/applications*') || request()->is('admin/job-positions*') ? 'true' : 'false' }},
                showDetailsModal: false,
                selectedApplication: null,
                showToast: false,
                toastMessage: '',
                toastType: 'success',
                
                showToastMessage(message, type = 'success') {
                    this.toastMessage = message;
                    this.toastType = type;
                    this.showToast = true;
                    setTimeout(() => {
                        this.showToast = false;
                    }, 5000);
                },
                
                viewApplication(application) {
                    this.selectedApplication = application;
                    this.showDetailsModal = true;
                },
                
                closeDetailsModal() {
                    this.showDetailsModal = false;
                    this.selectedApplication = null;
                },
                
                async updateStatus(applicationId, status) {
                    try {
                        const response = await fetch(`/admin/applications/${applicationId}/status`, {
                            method: 'PATCH',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                                'X-Requested-With': 'XMLHttpRequest'
                            },
                            body: JSON.stringify({ status })
                        });
                        
                        const data = await response.json();
                        
                        if (response.ok && data.success) {
                            this.showToastMessage('Status updated successfully!', 'success');
                            // Refresh page to show updated status
                            setTimeout(() => window.location.reload(), 1000);
                        } else {
                            this.showToastMessage(data.message || 'Failed to update status', 'error');
                        }
                    } catch (error) {
                        console.error('Error updating status:', error);
                        this.showToastMessage('An error occurred', 'error');
                    }
                }
            };
        }
    </script>
    
    <!-- Alpine.js for interactivity -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
</head>
<body class="bg-gray-50" x-data="appData()" @show-toast.window="showToastMessage($event.detail.message, $event.detail.type)">
    <div class="flex h-screen">
        <!-- Sidebar -->
        <div class="fixed inset-y-0 left-0 z-30 w-64 bg-white transform transition-transform duration-300 lg:translate-x-0 lg:static lg:inset-0"
             :class="{'translate-x-0': sidebarOpen, '-translate-x-full': !sidebarOpen}">
            
            <!-- Logo -->
            <div class="flex items-center justify-center h-16 bg-white">
                <img src="{{ asset('assets/images/aufg-logo.png') }}" alt="UFG" class="h-10 w-auto">
            </div>
            
            <!-- Navigation -->
            <nav class="p-4">
                <a href="{{ route('admin.dashboard') }}" class="flex items-center p-3 mb-2 text-gray-700 hover:bg-gray-100 rounded-lg">
                    <x-icon name="home" type="outline" class="w-5 h-5 mr-3" />
                    Dashboard
                </a>
                
                <a href="#" class="flex items-center p-3 mb-2 text-gray-700 hover:bg-gray-100 rounded-lg">
                    <x-icon name="users" type="outline" class="w-5 h-5 mr-3" />
                    Users
                </a>

                <!-- Careers Menu with Dropdown -->
                <div class="mb-2">
                    <button @click="careersMenuOpen = !careersMenuOpen" 
                            class="flex items-center justify-between w-full p-3 rounded-lg transition-colors
                                   {{ request()->is('admin/job-positions*') || request()->is('admin/applications*') ? 'bg-indigo-50 text-indigo-700 font-medium hover:bg-indigo-100' : 'text-gray-700 hover:bg-gray-100' }}">
                        <div class="flex items-center">
                            <x-icon name="academic-cap" type="outline" class="w-5 h-5 mr-3" />
                            Careers
                        </div>
                        <svg class="w-4 h-4 transition-transform duration-200" 
                             :class="{ 'rotate-180': careersMenuOpen }" 
                             fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </button>
                    
                    <!-- Careers Submenu -->
                    <div x-show="careersMenuOpen" 
                         x-transition:enter="transition ease-out duration-100"
                         x-transition:enter-start="opacity-0 transform -translate-y-2"
                         x-transition:enter-end="opacity-100 transform translate-y-0"
                         x-transition:leave="transition ease-in duration-75"
                         x-transition:leave-start="opacity-100 transform translate-y-0"
                         x-transition:leave-end="opacity-0 transform -translate-y-2"
                         class="mt-1 ml-4 border-l-2 border-gray-200 pl-4 space-y-1">
                        
                        <a href="{{ route('admin.job-positions') }}" 
                           class="flex items-center p-2 text-sm rounded-md transition-colors
                                  {{ request()->is('admin/job-positions*') ? 'bg-indigo-600 text-white' : 'text-gray-600 hover:bg-gray-50 hover:text-gray-900' }}">
                            <span class="mr-2 text-gray-400">•</span>
                            <x-icon name="briefcase" type="outline" class="w-4 h-4 mr-2" />
                            Job Positions
                        </a>
                        
                        <a href="{{ route('admin.applications') }}" 
                           class="flex items-center p-2 text-sm rounded-md transition-colors
                                  {{ request()->is('admin/applications*') ? 'bg-indigo-600 text-white' : 'text-gray-600 hover:bg-gray-50 hover:text-gray-900' }}">
                            <span class="mr-2 text-gray-400">•</span>
                            <x-icon name="document-text" type="outline" class="w-4 h-4 mr-2" />
                            Applications
                        </a>
                        
                        <!-- Career Enquiries -->
                        <a href="{{ route('admin.career-enquiries') }}" 
                           class="flex items-center p-2 text-sm rounded-md transition-colors
                                  {{ request()->is('admin/career-enquiries*') ? 'bg-indigo-600 text-white' : 'text-gray-600 hover:bg-gray-50 hover:text-gray-900' }}">
                            <span class="mr-2 text-gray-400">•</span>
                            <x-icon name="chat-bubble-left-right" type="outline" class="w-4 h-4 mr-2" />
                            Career Enquiries
                        </a>
                    </div>
                </div>
                
                <a href="#" class="flex items-center p-3 mb-2 text-gray-700 hover:bg-gray-100 rounded-lg">
                    <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                    </svg>
                    Analytics
                </a>
                
                <a href="#" class="flex items-center p-3 mb-2 text-gray-700 hover:bg-gray-100 rounded-lg">
                    <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                    </svg>
                    Settings
                </a>
            </nav>
            
            <!-- Admin Info & Logout -->
            <div class="absolute bottom-4 left-4 right-4">
                <div class="mb-3 px-3 py-2 bg-gray-50 rounded-lg">
                    <p class="text-sm font-semibold text-gray-800">UFG Admin</p>
                    <p class="text-xs text-gray-500">Administrator Panel</p>
                </div>
                <form action="{{ route('admin.logout') }}" method="POST">
                    @csrf
                    <button type="submit" class="flex items-center p-3 w-full text-gray-700 hover:bg-gray-100 rounded-lg">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                        </svg>
                        Logout
                    </button>
                </form>
            </div>
        </div>
        
        <!-- Mobile sidebar overlay -->
        <div class="fixed inset-0 z-20 bg-black bg-opacity-50 lg:hidden"
             x-show="sidebarOpen"
             @click="sidebarOpen = false"
             x-transition:enter="transition-opacity ease-linear duration-300"
             x-transition:enter-start="opacity-0"
             x-transition:enter-end="opacity-100"
             x-transition:leave="transition-opacity ease-linear duration-300"
             x-transition:leave-start="opacity-100"
             x-transition:leave-end="opacity-0">
        </div>

        <!-- Main Content -->
        <div class="flex-1 flex flex-col overflow-hidden">
            <!-- Top Navigation -->
            <header class="bg-white shadow-sm">
                <div class="flex items-center justify-between px-6 py-4">
                    <div class="flex items-center">
                        <button @click="sidebarOpen = !sidebarOpen" class="lg:hidden p-2 rounded-md text-gray-400 hover:text-gray-500 hover:bg-gray-100">
                            <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                            </svg>
                        </button>
                        <div class="ml-4 flex items-center">
                            <h1 class="text-2xl font-semibold text-gray-900">Job Applications</h1>
                            <span class="ml-3 px-3 py-1 bg-blue-100 text-blue-800 text-sm font-medium rounded-full">{{ $applications->count() }} Total</span>
                        </div>
                    </div>
                    
                    <div class="flex items-center space-x-4">
                        <div class="flex items-center">
                            <div class="w-8 h-8 bg-gray-600 text-white rounded-full flex items-center justify-center">
                                {{ substr(auth()->user()->name, 0, 1) }}
                            </div>
                            <span class="ml-2 text-sm font-medium text-gray-700">{{ auth()->user()->name }}</span>
                        </div>
                    </div>
                </div>
            </header>

            <!-- Dashboard Content -->
            <main class="flex-1 overflow-y-auto p-6">
                <!-- Stats Cards -->
                <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
                    <div class="bg-white rounded-lg shadow p-6">
                        <div class="flex items-center">
                            <div class="p-3 rounded-full bg-blue-100">
                                <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-600">Total Applications</p>
                                <p class="text-2xl font-bold text-gray-900">{{ $applications->count() }}</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bg-white rounded-lg shadow p-6">
                        <div class="flex items-center">
                            <div class="p-3 rounded-full bg-yellow-100">
                                <svg class="w-6 h-6 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-600">Pending</p>
                                <p class="text-2xl font-bold text-gray-900">{{ $applications->where('status', 'pending')->count() }}</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bg-white rounded-lg shadow p-6">
                        <div class="flex items-center">
                            <div class="p-3 rounded-full bg-green-100">
                                <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-600">Accepted</p>
                                <p class="text-2xl font-bold text-gray-900">{{ $applications->where('status', 'accepted')->count() }}</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bg-white rounded-lg shadow p-6">
                        <div class="flex items-center">
                            <div class="p-3 rounded-full bg-red-100">
                                <svg class="w-6 h-6 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-600">Rejected</p>
                                <p class="text-2xl font-bold text-gray-900">{{ $applications->where('status', 'rejected')->count() }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Applications Table -->
                <div class="bg-white rounded-lg shadow">
                    <div class="p-6">
                        <h3 class="text-lg font-semibold mb-4">All Applications</h3>
                        <div class="overflow-x-auto">
                            <table class="w-full">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Applicant</th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Position</th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Contact</th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Applied Date</th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                        <th class="px-4 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                                    </tr>
                                </thead>
                                <tbody class="divide-y divide-gray-200">
                                    @forelse($applications as $application)
                                    <tr>
                                        <td class="px-4 py-4">
                                            <div>
                                                <div class="font-medium text-gray-900">{{ $application->first_name }} {{ $application->last_name }}</div>
                                                @if($application->resume_path)
                                                    <a href="{{ Storage::url($application->resume_path) }}" 
                                                       target="_blank"
                                                       class="text-sm text-indigo-600 hover:text-indigo-800 flex items-center mt-1">
                                                        <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                                        </svg>
                                                        View Resume
                                                    </a>
                                                @endif
                                            </div>
                                        </td>
                                        <td class="px-4 py-4">
                                            <div class="text-sm text-gray-900">{{ $application->jobPosition->title }}</div>
                                            <div class="text-sm text-gray-500">{{ $application->jobPosition->location }}</div>
                                        </td>
                                        <td class="px-4 py-4">
                                            <div class="text-sm text-gray-900">{{ $application->email }}</div>
                                            <div class="text-sm text-gray-500">{{ $application->phone }}</div>
                                        </td>
                                        <td class="px-4 py-4 text-sm text-gray-500">
                                            {{ $application->created_at->format('M j, Y') }}
                                        </td>
                                        <td class="px-4 py-4">
                                            <span class="px-2 py-1 text-xs font-semibold rounded-full
                                                @if($application->status === 'pending') bg-yellow-100 text-yellow-800
                                                @elseif($application->status === 'reviewed') bg-blue-100 text-blue-800
                                                @elseif($application->status === 'accepted') bg-green-100 text-green-800
                                                @elseif($application->status === 'rejected') bg-red-100 text-red-800
                                                @endif">
                                                {{ ucfirst($application->status) }}
                                            </span>
                                        </td>
                                        <td class="px-4 py-4 text-center">
                                            <div class="flex items-center justify-center space-x-2">
                                                <button @click="viewApplication({{ $application->toJson() }})"
                                                        class="text-indigo-600 hover:text-indigo-900">
                                                    View
                                                </button>
                                                <select @change="updateStatus({{ $application->id }}, $event.target.value)"
                                                        class="text-sm border-gray-300 rounded-md">
                                                    <option value="pending" {{ $application->status === 'pending' ? 'selected' : '' }}>Pending</option>
                                                    <option value="reviewed" {{ $application->status === 'reviewed' ? 'selected' : '' }}>Reviewed</option>
                                                    <option value="accepted" {{ $application->status === 'accepted' ? 'selected' : '' }}>Accepted</option>
                                                    <option value="rejected" {{ $application->status === 'rejected' ? 'selected' : '' }}>Rejected</option>
                                                </select>
                                            </div>
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="6" class="px-6 py-4 text-center text-gray-500">
                                            No applications found.
                                        </td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <!-- Application Details Modal -->
    <div x-show="showDetailsModal" class="fixed inset-0 z-50 overflow-y-auto" style="display: none;">
        <div class="flex items-center justify-center min-h-screen px-4">
            <div class="fixed inset-0 bg-black opacity-50" @click="closeDetailsModal()"></div>
            <div class="bg-white rounded-lg max-w-2xl w-full p-6 relative">
                <h2 class="text-xl font-bold text-gray-900 mb-4">Application Details</h2>
                
                <div x-show="selectedApplication">
                    <div class="space-y-4">
                        <div>
                            <h3 class="text-lg font-medium text-gray-900">
                                <span x-text="selectedApplication?.first_name"></span> <span x-text="selectedApplication?.last_name"></span>
                            </h3>
                            <p class="text-gray-600" x-text="selectedApplication?.job_position?.title"></p>
                        </div>
                        
                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <label class="text-sm font-medium text-gray-700">Email</label>
                                <p class="text-gray-900" x-text="selectedApplication?.email"></p>
                            </div>
                            <div>
                                <label class="text-sm font-medium text-gray-700">Phone</label>
                                <p class="text-gray-900" x-text="selectedApplication?.phone"></p>
                            </div>
                        </div>
                        
                        <div x-show="selectedApplication?.cover_letter">
                            <label class="text-sm font-medium text-gray-700">Cover Letter</label>
                            <div class="mt-1 p-3 bg-gray-50 rounded-lg">
                                <p class="text-gray-900 whitespace-pre-wrap" x-text="selectedApplication?.cover_letter"></p>
                            </div>
                        </div>
                        
                        <div class="flex justify-end space-x-3">
                            <button @click="closeDetailsModal()" 
                                    class="px-4 py-2 bg-gray-300 text-gray-700 rounded-lg hover:bg-gray-400">
                                Close
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Toast Notification -->
    <div x-show="showToast" 
         x-transition:enter="transition ease-out duration-300 transform"
         x-transition:enter-start="translate-y-full opacity-0"
         x-transition:enter-end="translate-y-0 opacity-100"
         x-transition:leave="transition ease-in duration-200 transform"
         x-transition:leave-start="translate-y-0 opacity-100"
         x-transition:leave-end="translate-y-full opacity-0"
         class="fixed z-50 max-w-sm"
         style="bottom: 1rem; right: 1rem; min-width: 300px; display: none;">
        <div class="rounded-lg shadow-lg overflow-hidden"
             :class="{
                 'bg-green-500 text-white': toastType === 'success',
                 'bg-red-500 text-white': toastType === 'error'
             }">
            <div class="p-4">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <!-- Success Icon -->
                        <svg x-show="toastType === 'success'" class="h-5 w-5" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                        
                        <!-- Error Icon -->
                        <svg x-show="toastType === 'error'" class="h-5 w-5" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path>
                        </svg>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm font-medium" x-text="toastMessage"></p>
                    </div>
                    <div class="ml-auto pl-3">
                        <button @click="showToast = false" class="inline-flex text-white hover:text-gray-200 focus:outline-none focus:text-gray-200">
                            <svg class="h-4 w-4" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>