<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Career Enquiries - UFG Admin</title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="{{ asset('assets/images/aufg-logo.png') }}">
    
    <!-- Vite Compiled Assets -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    
    <script>
        function appData() {
            return {
                sidebarOpen: false, 
                careersMenuOpen: {{ request()->is('admin/career-enquiries*') || request()->is('admin/job-positions*') || request()->is('admin/applications*') ? 'true' : 'false' }},
                showToast: false,
                toastMessage: '',
                toastType: 'success',
                
                showToastMessage(message, type = 'success') {
                    this.toastMessage = message;
                    this.toastType = type;
                    this.showToast = true;
                    setTimeout(() => {
                        this.showToast = false;
                    }, 3000);
                }
            }
        }
    </script>
    
    <!-- Alpine.js for interactivity -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>

    <!-- FontAwesome for icons -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- Additional custom CSS for missing Tailwind classes -->
    <link href="{{ asset('css/careers.css') }}" rel="stylesheet">
</head>
<body class="bg-gray-50" x-data="appData()" @show-toast.window="showToastMessage($event.detail.message, $event.detail.type)">
    <div class="flex h-screen">
        <!-- Sidebar -->
        <div class="fixed inset-y-0 left-0 z-30 w-64 bg-white transform transition-transform duration-300 lg:translate-x-0 lg:static lg:inset-0"
             :class="{'translate-x-0': sidebarOpen, '-translate-x-full': !sidebarOpen}">
            
            <!-- Logo -->
            <div class="flex items-center justify-center h-16 bg-white">
                <img src="{{ asset('assets/images/aufg-logo.png') }}" alt="UFG" class="h-10 w-auto">
            </div>
            
            <!-- Navigation -->
            <nav class="p-4">
                <a href="{{ route('admin.dashboard') }}" class="flex items-center p-3 mb-2 text-gray-700 hover:bg-gray-100 rounded-lg">
                    <i class="fas fa-home w-5 h-5 mr-3"></i>
                    Dashboard
                </a>
                
                <a href="#" class="flex items-center p-3 mb-2 text-gray-700 hover:bg-gray-100 rounded-lg">
                    <i class="fas fa-users w-5 h-5 mr-3"></i>
                    Users
                </a>

                <!-- Careers Menu with Dropdown -->
                <div class="mb-2">
                    <button @click="careersMenuOpen = !careersMenuOpen" 
                            class="flex items-center justify-between w-full p-3 rounded-lg transition-colors
                                   {{ request()->is('admin/career-enquiries*') ? 'bg-indigo-50 text-indigo-700 font-medium hover:bg-indigo-100' : 'text-gray-700 hover:bg-gray-100' }}">
                        <div class="flex items-center">
                            <i class="fas fa-graduation-cap w-5 h-5 mr-3"></i>
                            Careers
                        </div>
                        <svg class="w-4 h-4 transition-transform duration-200" 
                             :class="{ 'rotate-180': careersMenuOpen }" 
                             fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </button>
                    
                    <!-- Careers Submenu -->
                    <div x-show="careersMenuOpen" 
                         x-transition:enter="transition ease-out duration-100"
                         x-transition:enter-start="opacity-0 transform -translate-y-2"
                         x-transition:enter-end="opacity-100 transform translate-y-0"
                         x-transition:leave="transition ease-in duration-75"
                         x-transition:leave-start="opacity-100 transform translate-y-0"
                         x-transition:leave-end="opacity-0 transform -translate-y-2"
                         class="mt-1 ml-4 border-l-2 border-gray-200 pl-4 space-y-1">
                        
                        <a href="{{ route('admin.job-positions') }}" 
                           class="flex items-center p-2 text-sm rounded-md transition-colors
                                  {{ request()->is('admin/job-positions*') ? 'bg-indigo-600 text-white' : 'text-gray-600 hover:bg-gray-50 hover:text-gray-900' }}">
                            <span class="mr-2 text-gray-400">•</span>
                            <i class="fas fa-briefcase w-4 h-4 mr-2"></i>
                            Job Positions
                        </a>
                        
                        <a href="{{ route('admin.applications') }}" 
                           class="flex items-center p-2 text-sm rounded-md transition-colors
                                  {{ request()->is('admin/applications*') ? 'bg-indigo-600 text-white' : 'text-gray-600 hover:bg-gray-50 hover:text-gray-900' }}">
                            <span class="mr-2 text-gray-400">•</span>
                            <i class="fas fa-file-alt w-4 h-4 mr-2"></i>
                            Applications
                        </a>
                        
                        <!-- Career Enquiries -->
                        <a href="{{ route('admin.career-enquiries') }}" 
                           class="flex items-center p-2 text-sm rounded-md transition-colors
                                  {{ request()->is('admin/career-enquiries*') ? 'bg-indigo-600 text-white' : 'text-gray-600 hover:bg-gray-50 hover:text-gray-900' }}">
                            <span class="mr-2 text-gray-400">•</span>
                            <i class="fas fa-comments w-4 h-4 mr-2"></i>
                            Career Enquiries
                        </a>
                    </div>
                </div>
                
                <a href="#" class="flex items-center p-3 mb-2 text-gray-700 hover:bg-gray-100 rounded-lg">
                    <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                    </svg>
                    Analytics
                </a>
                
                <a href="#" class="flex items-center p-3 mb-2 text-gray-700 hover:bg-gray-100 rounded-lg">
                    <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                    </svg>
                    Settings
                </a>
            </nav>
            
            <!-- Admin Info & Logout -->
            <div class="absolute bottom-4 left-4 right-4">
                <div class="mb-3 px-3 py-2 bg-gray-50 rounded-lg">
                    <div class="text-sm text-gray-600">Logged in as</div>
                    <div class="font-medium text-gray-900">{{ Auth::user()->name }}</div>
                </div>
                <form method="POST" action="{{ route('admin.logout') }}">
                    @csrf
                    <button type="submit" class="w-full flex items-center px-4 py-2 text-red-600 hover:bg-red-50 rounded-lg transition-colors">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                        </svg>
                        Logout
                    </button>
                </form>
            </div>
        </div>

        <!-- Main Content -->
        <div class="flex-1 overflow-auto">
            <!-- Mobile Sidebar Toggle -->
            <div class="lg:hidden fixed top-4 left-4 z-50">
                <button @click="sidebarOpen = !sidebarOpen" class="bg-white p-2 rounded-md shadow-md">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                    </svg>
                </button>
            </div>

            <!-- Header -->
            <div class="bg-white border-b border-gray-200 p-6">
                <div class="flex justify-between items-center">
                    <div>
                        <h1 class="text-2xl font-semibold text-gray-900">Career Enquiries</h1>
                        <p class="text-gray-600 mt-1">Manage career enquiries and general inquiries</p>
                    </div>
                </div>
            </div>

            <!-- Content -->
            <div class="p-6">
                <!-- Stats Cards -->
                <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
                    <div class="bg-white rounded-lg shadow p-6">
                        <div class="flex items-center">
                            <div class="p-3 rounded-full bg-blue-100">
                                <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                                </svg>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-600">Total Enquiries</p>
                                <p class="text-2xl font-bold text-gray-900">{{ $careerEnquiries->count() }}</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bg-white rounded-lg shadow p-6">
                        <div class="flex items-center">
                            <div class="p-3 rounded-full bg-yellow-100">
                                <svg class="w-6 h-6 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-600">New</p>
                                <p class="text-2xl font-bold text-gray-900">{{ $careerEnquiries->where('status', 'new')->count() }}</p>
                            </div>
                        </div>
                    </div>

                    <div class="bg-white rounded-lg shadow p-6">
                        <div class="flex items-center">
                            <div class="p-3 rounded-full bg-green-100">
                                <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-600">Contacted</p>
                                <p class="text-2xl font-bold text-gray-900">{{ $careerEnquiries->where('status', 'contacted')->count() }}</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bg-white rounded-lg shadow p-6">
                        <div class="flex items-center">
                            <div class="p-3 rounded-full bg-gray-100">
                                <svg class="w-6 h-6 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 8l6 6m0 0l6-6m-6 6V3"></path>
                                </svg>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-600">Archived</p>
                                <p class="text-2xl font-bold text-gray-900">{{ $careerEnquiries->where('status', 'archived')->count() }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Career Enquiries Table -->
                <div class="bg-white rounded-lg shadow">
                    <div class="p-6">
                        <h3 class="text-lg font-semibold mb-4">All Career Enquiries</h3>
                        <div class="overflow-x-auto">
                            <table class="w-full">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Name</th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Email</th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Type</th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Message</th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">CV</th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                    @foreach($careerEnquiries as $enquiry)
                                    <tr class="hover:bg-gray-50">
                                        <td class="px-4 py-4 whitespace-nowrap">
                                            <div class="flex items-center">
                                                <div class="flex-shrink-0 h-8 w-8">
                                                    <div class="h-8 w-8 rounded-full bg-indigo-500 flex items-center justify-center">
                                                        <span class="text-sm font-medium text-white">{{ substr($enquiry->first_name, 0, 1) }}</span>
                                                    </div>
                                                </div>
                                                <div class="ml-4">
                                                    <div class="text-sm font-medium text-gray-900">{{ $enquiry->first_name }} {{ $enquiry->last_name }}</div>
                                                    @if($enquiry->phone)
                                                        <div class="text-sm text-gray-500">{{ $enquiry->phone }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                        </td>
                                        <td class="px-4 py-4 whitespace-nowrap">
                                            <div class="text-sm text-gray-900">{{ $enquiry->email }}</div>
                                        </td>
                                        <td class="px-4 py-4 whitespace-nowrap">
                                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                                @if($enquiry->enquiry_type === 'cv-submission') bg-blue-100 text-blue-800
                                                @elseif($enquiry->enquiry_type === 'coop-request') bg-purple-100 text-purple-800
                                                @elseif($enquiry->enquiry_type === 'internship') bg-green-100 text-green-800
                                                @else bg-gray-100 text-gray-800
                                                @endif">
                                                {{ ucwords(str_replace('-', ' ', $enquiry->enquiry_type)) }}
                                            </span>
                                        </td>
                                        <td class="px-4 py-4">
                                            <div class="text-sm text-gray-900 max-w-xs truncate" title="{{ $enquiry->message }}">
                                                {{ Str::limit($enquiry->message, 50) }}
                                            </div>
                                        </td>
                                        <td class="px-4 py-4 whitespace-nowrap text-sm text-gray-500">
                                            @if($enquiry->cv_path)
                                                <a href="{{ asset('storage/' . $enquiry->cv_path) }}" target="_blank" class="text-indigo-600 hover:text-indigo-900">
                                                    <i class="fas fa-file-pdf mr-1"></i>
                                                    View CV
                                                </a>
                                            @else
                                                <span class="text-gray-400">No CV</span>
                                            @endif
                                        </td>
                                        <td class="px-4 py-4 whitespace-nowrap">
                                            <select onchange="updateEnquiryStatus({{ $enquiry->id }}, this.value)" 
                                                    class="text-sm rounded-md border-gray-300 
                                                    @if($enquiry->status === 'new') bg-yellow-50 text-yellow-800 border-yellow-200
                                                    @elseif($enquiry->status === 'reviewed') bg-blue-50 text-blue-800 border-blue-200
                                                    @elseif($enquiry->status === 'contacted') bg-green-50 text-green-800 border-green-200
                                                    @else bg-gray-50 text-gray-800 border-gray-200
                                                    @endif">
                                                <option value="new" {{ $enquiry->status === 'new' ? 'selected' : '' }}>New</option>
                                                <option value="reviewed" {{ $enquiry->status === 'reviewed' ? 'selected' : '' }}>Reviewed</option>
                                                <option value="contacted" {{ $enquiry->status === 'contacted' ? 'selected' : '' }}>Contacted</option>
                                                <option value="archived" {{ $enquiry->status === 'archived' ? 'selected' : '' }}>Archived</option>
                                            </select>
                                        </td>
                                        <td class="px-4 py-4 whitespace-nowrap text-sm text-gray-500">
                                            {{ $enquiry->created_at->format('M j, Y') }}
                                        </td>
                                        <td class="px-4 py-4 whitespace-nowrap text-sm font-medium">
                                            <div class="flex space-x-2">
                                                <a href="mailto:{{ $enquiry->email }}" class="text-indigo-600 hover:text-indigo-900">
                                                    <i class="fas fa-envelope"></i>
                                                </a>
                                                @if($enquiry->phone)
                                                    <a href="tel:{{ $enquiry->phone }}" class="text-green-600 hover:text-green-900">
                                                        <i class="fas fa-phone"></i>
                                                    </a>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                            
                            @if($careerEnquiries->count() === 0)
                                <div class="text-center py-8">
                                    <div class="text-gray-400 mb-2">
                                        <svg class="mx-auto h-12 w-12" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                                        </svg>
                                    </div>
                                    <p class="text-gray-500">No career enquiries yet</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Function to update enquiry status
        async function updateEnquiryStatus(enquiryId, newStatus) {
            try {
                const response = await fetch(`/admin/career-enquiries/${enquiryId}/status`, {
                    method: 'PATCH',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                        'Accept': 'application/json'
                    },
                    body: JSON.stringify({
                        status: newStatus
                    })
                });

                if (response.ok) {
                    const result = await response.json();
                    // Show success message
                    window.dispatchEvent(new CustomEvent('show-toast', {
                        detail: {
                            message: 'Status updated successfully!',
                            type: 'success'
                        }
                    }));
                    // Refresh page to show updated status
                    setTimeout(() => window.location.reload(), 1000);
                } else {
                    window.dispatchEvent(new CustomEvent('show-toast', {
                        detail: {
                            message: 'Failed to update status',
                            type: 'error'
                        }
                    }));
                }
            } catch (error) {
                console.error('Error updating status:', error);
                window.dispatchEvent(new CustomEvent('show-toast', {
                    detail: {
                        message: 'An error occurred',
                        type: 'error'
                    }
                }));
            }
        }
    </script>

    <!-- Toast Notification -->
    <div x-show="showToast" 
         x-transition:enter="transition ease-out duration-300 transform"
         x-transition:enter-start="translate-y-full opacity-0"
         x-transition:enter-end="translate-y-0 opacity-100"
         x-transition:leave="transition ease-in duration-200 transform"
         x-transition:leave-start="translate-y-0 opacity-100"
         x-transition:leave-end="translate-y-full opacity-0"
         class="fixed bottom-0 right-0 mb-4 mr-4 w-96 max-w-sm z-50">
        <div class="rounded-lg shadow-lg overflow-hidden" 
             :class="{
                 'bg-green-500 text-white': toastType === 'success',
                 'bg-red-500 text-white': toastType === 'error'
             }">
            <div class="p-4">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <!-- Success Icon -->
                        <svg x-show="toastType === 'success'" class="h-5 w-5" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                        
                        <!-- Error Icon -->
                        <svg x-show="toastType === 'error'" class="h-5 w-5" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path>
                        </svg>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm font-medium" x-text="toastMessage"></p>
                    </div>
                    <div class="ml-auto pl-3">
                        <button @click="showToast = false" class="inline-flex text-white hover:text-gray-200 focus:outline-none focus:text-gray-200">
                            <svg class="h-4 w-4" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>