@extends('layouts.admin-simple')

@section('title', 'Permissions')
@section('page-title', 'System Permissions')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.roles') }}">Roles</a></li>
    <li class="breadcrumb-item active" aria-current="page">Permissions</li>
@endsection

@section('page-actions')
    <div class="ml-auto">
        <a href="{{ route('admin.roles') }}" class="btn btn-outline-primary">
            <i class="material-icons">arrow_back</i> Back to Roles
        </a>
    </div>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="alert alert-info">
                <i class="material-icons">info</i>
                Permissions are system-defined and cannot be modified directly. To manage permissions, edit the roles that use them.
            </div>
        </div>
    </div>
    
    <div class="row">
        @foreach($permissions as $group => $groupPermissions)
        <div class="col-md-6 col-lg-4 mb-4">
            <div class="card h-100">
                <div class="card-header bg-white">
                    <h5 class="card-header__title">
                        <i class="material-icons mr-2">folder</i>
                        {{ ucfirst(str_replace('_', ' ', $group)) }}
                    </h5>
                    <span class="badge badge-soft-info">{{ count($groupPermissions) }} permissions</span>
                </div>
                <div class="card-body">
                    <div class="list-group list-group-flush">
                        @foreach($groupPermissions as $permission)
                        <div class="list-group-item px-0">
                            <div class="d-flex align-items-start">
                                <i class="material-icons text-muted mr-2" style="font-size: 18px;">lock</i>
                                <div class="flex">
                                    <div class="font-weight-bold">{{ $permission->display_name }}</div>
                                    <div class="text-muted small">{{ $permission->name }}</div>
                                    @if($permission->description)
                                        <div class="text-muted small mt-1">{{ $permission->description }}</div>
                                    @endif
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
        @endforeach
    </div>
    
    <div class="card">
        <div class="card-header bg-white">
            <h4 class="card-header__title">Permission Matrix</h4>
            <div class="card-subtitle text-muted">Overview of all permissions in the system</div>
        </div>
        <div class="table-responsive">
            <table class="table table-sm">
                <thead>
                    <tr>
                        <th>Permission Name</th>
                        <th>Display Name</th>
                        <th>Group</th>
                        <th>Description</th>
                        <th>Used by Roles</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($permissions as $group => $groupPermissions)
                        @foreach($groupPermissions as $permission)
                        <tr>
                            <td><code>{{ $permission->name }}</code></td>
                            <td>{{ $permission->display_name }}</td>
                            <td>
                                <span class="badge badge-light">{{ ucfirst($group) }}</span>
                            </td>
                            <td>{{ $permission->description ?? '-' }}</td>
                            <td>
                                @php
                                    $roleCount = $permission->roles()->count();
                                @endphp
                                @if($roleCount > 0)
                                    <span class="badge badge-soft-success">{{ $roleCount }} roles</span>
                                @else
                                    <span class="badge badge-soft-warning">Unused</span>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection