@extends('layouts.admin-simple')

@section('title', 'Site Settings')
@section('page-title', 'Site Settings')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item active" aria-current="page">Site Settings</li>
@endsection

@section('page-actions')
    <!-- No add button needed - settings are pre-defined -->
@endsection

@section('content')
    <!-- Filters -->
    <div class="card mb-3">
        <div class="card-body">
            <form method="GET" class="row align-items-end">
                <div class="col-md-3">
                    <label for="search" class="form-label">Search</label>
                    <input type="text" class="form-control" id="search" name="search" value="{{ request('search') }}" placeholder="Key, label, value...">
                </div>
                <div class="col-md-2">
                    <label for="group" class="form-label">Group</label>
                    <select class="form-control" id="group" name="group">
                        <option value="">All Groups</option>
                        <option value="general" {{ request('group') == 'general' ? 'selected' : '' }}>General</option>
                        <option value="admin" {{ request('group') == 'admin' ? 'selected' : '' }}>Admin</option>
                        <option value="contact" {{ request('group') == 'contact' ? 'selected' : '' }}>Contact</option>
                        <option value="social" {{ request('group') == 'social' ? 'selected' : '' }}>Social Media</option>
                        <option value="whatsapp" {{ request('group') == 'whatsapp' ? 'selected' : '' }}>WhatsApp</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label for="type" class="form-label">Type</label>
                    <select class="form-control" id="type" name="type">
                        <option value="">All Types</option>
                        <option value="text" {{ request('type') == 'text' ? 'selected' : '' }}>Text</option>
                        <option value="email" {{ request('type') == 'email' ? 'selected' : '' }}>Email</option>
                        <option value="phone" {{ request('type') == 'phone' ? 'selected' : '' }}>Phone</option>
                        <option value="url" {{ request('type') == 'url' ? 'selected' : '' }}>URL</option>
                        <option value="textarea" {{ request('type') == 'textarea' ? 'selected' : '' }}>Textarea</option>
                        <option value="file" {{ request('type') == 'file' ? 'selected' : '' }}>File</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label for="status" class="form-label">Status</label>
                    <select class="form-control" id="status" name="status">
                        <option value="">All Status</option>
                        <option value="1" {{ request('status') == '1' ? 'selected' : '' }}>Active</option>
                        <option value="0" {{ request('status') == '0' ? 'selected' : '' }}>Inactive</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn btn-outline-primary">
                        <i class="material-icons">search</i> Search
                    </button>
                    <a href="{{ route('admin.site-settings.index') }}" class="btn btn-outline-secondary">
                        <i class="material-icons">clear</i> Clear
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Settings Table -->
    <div class="card">
        <div class="card-header card-header-large bg-white d-flex align-items-center">
            <div class="flex">
                <h4 class="card-header__title">Site Settings</h4>
                <div class="card-subtitle text-muted">Manage dynamic site configuration</div>
            </div>
            <div class="ml-auto">
                <span class="badge badge-light">{{ $settings->total() }} total settings</span>
            </div>
        </div>
        
        <form method="POST" action="{{ route('admin.site-settings.bulk-update') }}" id="bulkUpdateForm" enctype="multipart/form-data">
            @csrf
            <div class="table-responsive">
                <table class="table mb-0">
                    <thead>
                        <tr>
                            <th style="width: 30%;">Setting</th>
                            <th style="width: 40%;">Value</th>
                            <th>Group</th>
                            <th>Type</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                        <tbody>
                            @forelse($settings as $setting)
                                <tr>
                                    <td>
                                        <div class="media align-items-center">
                                            <div class="media-body">
                                                <strong>{{ $setting->label }}</strong>
                                                <div class="text-muted small"><code>{{ $setting->key }}</code></div>
                                                @if($setting->description)
                                                    <div class="text-muted small">{{ Str::limit($setting->description, 50) }}</div>
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        @if($setting->type === 'textarea')
                                            <div class="form-group mb-0">
                                                <textarea name="settings[{{ $setting->id }}][value]" 
                                                         class="form-control" 
                                                         rows="3" 
                                                         placeholder="Enter {{ strtolower($setting->label) }}">{{ $setting->value }}</textarea>
                                            </div>
                                        @elseif($setting->type === 'url')
                                            <input type="url" 
                                                   name="settings[{{ $setting->id }}][value]" 
                                                   value="{{ $setting->value }}" 
                                                   class="form-control" 
                                                   placeholder="https://example.com">
                                        @elseif($setting->type === 'email')
                                            <input type="email" 
                                                   name="settings[{{ $setting->id }}][value]" 
                                                   value="{{ $setting->value }}" 
                                                   class="form-control" 
                                                   placeholder="email@example.com">
                                        @elseif($setting->type === 'phone')
                                            <input type="tel" 
                                                   name="settings[{{ $setting->id }}][value]" 
                                                   value="{{ $setting->value }}" 
                                                   class="form-control" 
                                                   placeholder="+966 xxx xxx xxxx">
                                        @elseif($setting->type === 'boolean')
                                            <select name="settings[{{ $setting->id }}][value]" class="form-control">
                                                <option value="1" {{ $setting->value ? 'selected' : '' }}>Yes</option>
                                                <option value="0" {{ !$setting->value ? 'selected' : '' }}>No</option>
                                            </select>
                                        @elseif($setting->type === 'file')
                                            <div class="file-upload-wrapper">
                                                @if($setting->value)
                                                    <div class="current-file mb-2">
                                                        <small class="text-muted">Current:</small>
                                                        @if(in_array(strtolower(pathinfo($setting->value, PATHINFO_EXTENSION)), ['jpg', 'jpeg', 'png', 'gif', 'svg']))
                                                            <div class="current-image mt-1">
                                                                <img src="{{ asset($setting->value) }}" alt="{{ $setting->label }}" style="max-height: 60px; max-width: 200px; border: 1px solid #dee2e6; border-radius: 4px;">
                                                            </div>
                                                        @else
                                                            <code>{{ $setting->value }}</code>
                                                        @endif
                                                    </div>
                                                @endif
                                                <input type="file"
                                                       name="settings[{{ $setting->id }}][file]"
                                                       class="form-control-file"
                                                       accept="{{ in_array($setting->key, ['favicon', 'site_favicon', 'admin_favicon']) ? '.ico,.png' : 'image/*' }}">
                                                <input type="hidden" name="settings[{{ $setting->id }}][value]" value="{{ $setting->value }}">
                                                <small class="form-text text-muted">
                                                    @if(in_array($setting->key, ['favicon', 'site_favicon', 'admin_favicon']))
                                                        Upload ICO or PNG file
                                                    @else
                                                        Upload JPG, PNG, or SVG file
                                                    @endif
                                                </small>
                                            </div>
                                        @else
                                            <input type="text" 
                                                   name="settings[{{ $setting->id }}][value]" 
                                                   value="{{ $setting->value }}" 
                                                   class="form-control" 
                                                   placeholder="Enter {{ strtolower($setting->label) }}">
                                        @endif
                                        <input type="hidden" name="settings[{{ $setting->id }}][is_active]" value="{{ $setting->is_active ? '1' : '0' }}">
                                    </td>
                                    <td>
                                        <span class="badge badge-soft-{{ $setting->group === 'contact' ? 'info' : ($setting->group === 'social' ? 'success' : ($setting->group === 'whatsapp' ? 'warning' : 'secondary')) }}">
                                            {{ ucfirst($setting->group) }}
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge badge-light">{{ ucfirst($setting->type) }}</span>
                                    </td>
                                    <td>
                                        <div class="custom-control custom-switch">
                                            <input type="checkbox" 
                                                   class="custom-control-input status-toggle" 
                                                   id="status_{{ $setting->id }}"
                                                   data-setting-id="{{ $setting->id }}"
                                                   {{ $setting->is_active ? 'checked' : '' }}>
                                            <label class="custom-control-label" for="status_{{ $setting->id }}">
                                                @if($setting->is_active)
                                                    <span class="badge badge-soft-success">Active</span>
                                                @else
                                                    <span class="badge badge-soft-secondary">Inactive</span>
                                                @endif
                                            </label>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center py-5">
                                        <div class="text-muted">
                                            <i class="material-icons mb-3" style="font-size: 64px; color: #dee2e6;">settings</i>
                                            <h5>No settings found</h5>
                                            <p class="mb-0">Try adjusting your filters or create a new setting</p>
                                        </div>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                
                @if($settings->isNotEmpty())
                    <div class="card-footer bg-white">
                        <button type="submit" class="btn btn-success">
                            <i class="material-icons mr-1">save</i> Save All Changes
                        </button>
                        <span class="text-muted ml-3">Inline editing enabled - changes are saved together</span>
                    </div>
                @endif
            </form>
    </div>

    <!-- Pagination -->
    @if($settings->hasPages())
        <div class="d-flex justify-content-center mt-3">
            {{ $settings->withQueryString()->links() }}
        </div>
    @endif
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // Handle status toggle
        $('.status-toggle').on('change', function() {
            var settingId = $(this).data('setting-id');
            var isActive = $(this).is(':checked') ? '1' : '0';
            var hiddenInput = $('input[name="settings[' + settingId + '][is_active]"]');
            var label = $(this).next('label');
            
            hiddenInput.val(isActive);
            
            // Update badge
            if (isActive === '1') {
                label.html('<span class="badge badge-soft-success">Active</span>');
            } else {
                label.html('<span class="badge badge-soft-secondary">Inactive</span>');
            }
            
            // Show unsaved indicator
            showUnsavedIndicator($(this).closest('tr'));
        });
        
        // Show save indicator when form changes
        $('#bulkUpdateForm').on('change', 'input:not(.status-toggle), textarea, select', function() {
            showUnsavedIndicator($(this).closest('tr'));
        });
        
        function showUnsavedIndicator(row) {
            $('.save-indicator').remove();
            if (!row.find('.save-indicator').length) {
                row.find('td:first').append('<span class="save-indicator badge badge-warning ml-2">Unsaved</span>');
            }
        }
        
        // Clear indicators on save
        $('#bulkUpdateForm').on('submit', function() {
            $('.save-indicator').remove();
        });
    });
</script>
@endsection

@push('styles')
<style>
    /* FlowDash soft badges */
    .badge-soft-info {
        background-color: rgba(23, 162, 184, 0.1);
        color: #17a2b8;
    }
    .badge-soft-success {
        background-color: rgba(40, 167, 69, 0.1);
        color: #28a745;
    }
    .badge-soft-warning {
        background-color: rgba(255, 193, 7, 0.1);
        color: #ffc107;
    }
    .badge-soft-secondary {
        background-color: rgba(108, 117, 125, 0.1);
        color: #6c757d;
    }
    
    /* Form controls styling */
    .table td .form-control {
        font-size: 14px;
        padding: 8px 12px;
        background-color: #f8f9fa;
        border: 1px solid #dee2e6;
        transition: all 0.2s ease;
    }
    
    .table td .form-control:focus {
        background-color: #fff;
        border-color: #80bdff;
        box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.1);
    }
    
    .table td textarea.form-control {
        min-height: 80px;
        resize: vertical;
    }
    
    /* Custom switch styling */
    .custom-control-switch .custom-control-label::before {
        border: 1px solid #adb5bd;
        background-color: #e9ecef;
    }
    
    .custom-control-switch .custom-control-input:checked ~ .custom-control-label::before {
        background-color: #28a745;
        border-color: #28a745;
    }
    
    /* Save indicator */
    .save-indicator {
        font-size: 11px;
        padding: 3px 8px;
        animation: pulse 2s infinite;
    }
    
    @keyframes pulse {
        0% { opacity: 1; }
        50% { opacity: 0.7; }
        100% { opacity: 1; }
    }
    
    /* Table cell padding adjustment */
    .table td {
        vertical-align: middle;
        padding: 1rem;
    }
    
    /* Card footer styling */
    .card-footer {
        border-top: 1px solid #e3e6ef;
        padding: 1.25rem;
    }
    
    /* File upload styling */
    .file-upload-wrapper {
        position: relative;
    }
    
    .form-control-file {
        background-color: #f8f9fa;
        border: 1px solid #dee2e6;
        border-radius: 0.375rem;
        padding: 8px 12px;
        width: 100%;
        font-size: 14px;
    }
    
    .form-control-file:focus {
        background-color: #fff;
        border-color: #80bdff;
        outline: none;
        box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.1);
    }
    
    .current-image img {
        transition: opacity 0.2s ease;
    }
    
    .current-image img:hover {
        opacity: 0.8;
    }
</style>
@endpush