@php
    $iconPath = base_path("node_modules/heroicons/24/{$type}/{$name}.svg");
    $svgContent = '';
    
    if (file_exists($iconPath)) {
        $svgContent = file_get_contents($iconPath);
        // Remove the xmlns and data-slot attributes, and update classes
        $svgContent = preg_replace('/xmlns="[^"]*"/', '', $svgContent);
        $svgContent = preg_replace('/data-slot="[^"]*"/', '', $svgContent);
        $svgContent = preg_replace('/aria-hidden="[^"]*"/', '', $svgContent);
        $svgContent = preg_replace('/<svg/', '<svg ' . $attributes->merge(['class' => $class ?? 'w-5 h-5'])->toHtml(), $svgContent);
    }
@endphp

{!! $svgContent !!}