<!-- Warehouse Breadcrumb Component -->
@props(['items' => []])

<nav aria-label="breadcrumb" class="warehouse-breadcrumb mb-3">
    <ol class="breadcrumb bg-transparent p-0 m-0">
        <!-- Home/Dashboard -->
        <li class="breadcrumb-item">
            <a href="{{ route('warehouse.dashboard') }}" class="text-decoration-none">
                <i class="material-icons" style="font-size: 16px; vertical-align: middle;">home</i>
                <span class="ml-1">Warehouse</span>
            </a>
        </li>

        <!-- Dynamic Items -->
        @foreach($items as $item)
            @if($loop->last)
                <li class="breadcrumb-item active" aria-current="page">
                    @if(isset($item['icon']))
                        <i class="material-icons mr-1" style="font-size: 16px; vertical-align: middle;">{{ $item['icon'] }}</i>
                    @endif
                    {{ $item['title'] }}
                </li>
            @else
                <li class="breadcrumb-item">
                    @if(isset($item['url']))
                        <a href="{{ $item['url'] }}" class="text-decoration-none">
                            @if(isset($item['icon']))
                                <i class="material-icons mr-1" style="font-size: 16px; vertical-align: middle;">{{ $item['icon'] }}</i>
                            @endif
                            {{ $item['title'] }}
                        </a>
                    @else
                        @if(isset($item['icon']))
                            <i class="material-icons mr-1" style="font-size: 16px; vertical-align: middle;">{{ $item['icon'] }}</i>
                        @endif
                        {{ $item['title'] }}
                    @endif
                </li>
            @endif
        @endforeach

        <!-- Slot for additional content -->
        {{ $slot ?? '' }}
    </ol>
</nav>

<style>
.warehouse-breadcrumb .breadcrumb-item + .breadcrumb-item::before {
    content: ">";
    color: #6c757d;
    font-weight: bold;
}

.warehouse-breadcrumb .breadcrumb-item a {
    color: #007bff;
    transition: color 0.15s ease-in-out;
}

.warehouse-breadcrumb .breadcrumb-item a:hover {
    color: #0056b3;
    text-decoration: none;
}

.warehouse-breadcrumb .breadcrumb-item.active {
    color: #6c757d;
}
</style>