<header class="warehouse-header py-3">
    <div class="container-fluid">
        <div class="d-flex justify-content-between align-items-center">
            <!-- Left side: Brand and Mobile Toggle -->
            <div class="d-flex align-items-center">
                <button class="btn btn-link text-white d-lg-none mr-3" id="sidebarToggle">
                    <i class="material-icons">menu</i>
                </button>
                <div class="d-flex align-items-center">
                    @if(isset($siteSettings['site_logo']))
                        <img src="{{ asset($siteSettings['site_logo']) }}" alt="{{ $siteSettings['site_name'] ?? 'KCG' }}"
                             class="mr-2" style="height: 32px;">
                    @endif
                    <h4 class="mb-0 font-weight-bold">
                        <span class="d-none d-sm-inline">Warehouse Management System</span>
                        <span class="d-sm-none">WMS</span>
                    </h4>
                </div>
            </div>

            <!-- Right side: Quick Actions and User Menu -->
            <div class="d-flex align-items-center">
                <!-- Quick Search -->
                <div class="mr-3 d-none d-md-block">
                    <div class="input-group" style="width: 300px;">
                        <input type="text" class="form-control form-control-sm" placeholder="Search items, locations..." id="quickSearch">
                        <div class="input-group-append">
                            <button class="btn btn-light btn-sm" type="button">
                                <i class="material-icons" style="font-size: 16px;">search</i>
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Notifications -->
                <div class="dropdown mr-3">
                    <button class="btn btn-link text-white" type="button" id="notificationDropdown"
                            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="material-icons">notifications</i>
                        <span class="badge badge-danger badge-pill position-absolute" style="top: 5px; right: 5px; font-size: 10px;">
                            3
                        </span>
                    </button>
                    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="notificationDropdown" style="width: 300px;">
                        <div class="dropdown-header">
                            <strong>Notifications</strong>
                            <small class="text-muted ml-2">(3 unread)</small>
                        </div>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item py-2" href="#">
                            <div class="d-flex align-items-start">
                                <i class="material-icons text-warning mr-2">warning</i>
                                <div class="flex-fill">
                                    <div class="font-weight-semibold">Low Stock Alert</div>
                                    <small class="text-muted">5 items below reorder point</small>
                                </div>
                                <small class="text-muted">2m ago</small>
                            </div>
                        </a>
                        <a class="dropdown-item py-2" href="#">
                            <div class="d-flex align-items-start">
                                <i class="material-icons text-info mr-2">inventory</i>
                                <div class="flex-fill">
                                    <div class="font-weight-semibold">Incoming Shipment</div>
                                    <small class="text-muted">PO-2024-001 ready for receiving</small>
                                </div>
                                <small class="text-muted">1h ago</small>
                            </div>
                        </a>
                        <a class="dropdown-item py-2" href="#">
                            <div class="d-flex align-items-start">
                                <i class="material-icons text-success mr-2">check_circle</i>
                                <div class="flex-fill">
                                    <div class="font-weight-semibold">Transfer Complete</div>
                                    <small class="text-muted">Location A to B completed</small>
                                </div>
                                <small class="text-muted">3h ago</small>
                            </div>
                        </a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item text-center small" href="#">View all notifications</a>
                    </div>
                </div>

                <!-- User Menu -->
                <div class="dropdown">
                    <button class="btn btn-link text-white d-flex align-items-center" type="button"
                            id="userDropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <div class="mr-2 d-none d-sm-block text-right">
                            <div class="font-weight-semibold">{{ Auth::user()->name }}</div>
                            <small class="opacity-75">{{ Auth::user()->role->display_name ?? 'No Role' }}</small>
                        </div>
                        <div class="bg-light rounded-circle d-flex align-items-center justify-content-center"
                             style="width: 32px; height: 32px;">
                            <span class="text-dark font-weight-bold">
                                {{ strtoupper(substr(Auth::user()->name, 0, 2)) }}
                            </span>
                        </div>
                        <i class="material-icons ml-1">arrow_drop_down</i>
                    </button>
                    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="userDropdown">
                        <div class="dropdown-header">
                            <strong>{{ Auth::user()->name }}</strong>
                            <br>
                            <small class="text-muted">{{ Auth::user()->email }}</small>
                        </div>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item" href="#">
                            <i class="material-icons mr-2" style="font-size: 16px;">person</i>
                            Profile
                        </a>
                        <a class="dropdown-item" href="#">
                            <i class="material-icons mr-2" style="font-size: 16px;">settings</i>
                            Settings
                        </a>
                        <a class="dropdown-item" href="#">
                            <i class="material-icons mr-2" style="font-size: 16px;">help</i>
                            Help & Support
                        </a>
                        <div class="dropdown-divider"></div>
                        @if(app(\App\Services\Auth\RoleBasedAccessService::class)->isAdmin(Auth::user()))
                        <a class="dropdown-item" href="{{ route('admin.dashboard') }}">
                            <i class="material-icons mr-2" style="font-size: 16px;">admin_panel_settings</i>
                            Admin Dashboard
                        </a>
                        <div class="dropdown-divider"></div>
                        @endif
                        <form method="POST" action="{{ route('admin.logout') }}" class="d-inline">
                            @csrf
                            <button type="submit" class="dropdown-item text-danger">
                                <i class="material-icons mr-2" style="font-size: 16px;">logout</i>
                                Logout
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>