@extends('layouts.main')

@push('styles')
    <!-- Page Specific CSS Files -->
    
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Custom CSS Files -->
    <link rel='stylesheet' href='{{ asset("assets/css/custom-nav-hover.css") }}' media='all' />
    <link rel='stylesheet' href='{{ asset("assets/css/media-dropdown.css") }}' media='all' />
    <link rel='stylesheet' href='{{ asset("assets/css/aufg-logo-fix.css") }}' media='all' />
    <link rel='stylesheet' href='{{ asset("assets/css/hero-exact-match.css") }}' media='all' />
    <link rel='stylesheet' href='{{ asset("assets/css/about-section.css") }}' media='all' />
    <link rel='stylesheet' href='{{ asset("assets/css/modern-video-player.css") }}' media='all' />
    <link rel='stylesheet' href='{{ asset("assets/css/stats-section.css") }}' media='all' />
    <link rel='stylesheet' href='{{ asset("assets/css/global-poppins-font.css") }}' media='all' />
    <link rel='stylesheet' href='{{ asset("assets/css/global-buttons.css") }}' media='all' />
    <link rel='stylesheet' href='{{ asset("assets/css/global-colors.css") }}' media='all' />
    <link rel='stylesheet' href='{{ asset("assets/css/products-section.css") }}' media='all' />
    <link rel='stylesheet' href='{{ asset("assets/css/news-section.css") }}' media='all' />
    <link rel='stylesheet' href='{{ asset("assets/css/home-page-progressive-filters.css") }}' media='all' />
    <link rel='stylesheet' href='{{ asset("assets/css/home-page-specific.css") }}' media='all' />
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
@endpush

@section('content')
<!-- Hero Section - Exact Match to Original -->
<section class="hero-section-exact">
    <!-- Video Background Container -->
    <div class="hero-video-bg" aria-hidden="true">
        <!-- Video will be injected here -->
    </div>
    
    <!-- Content Container -->
    <div class="hero-content-container">
        <div class="hero-text-content">
            <div class="hero-welcome-box">
                <h1 class="hero-welcome">Welcome to</h1>
            </div>
            <h2 class="hero-company-name">Arabian United Float Glass Company</h2>
        </div>
    </div>
</section>

<!-- About Section -->
<section class="about-section">
    <div class="about-container">
        <div class="about-content">
            <div class="about-text-content">
                <h2 class="about-heading">Who we are</h2>
                <div class="about-description">
                    <p>
                        <span class="company-name">Arabian United Float Glass Company (UFG)</span>
                        <span class="text-content"> is a leading Arab manufacturer of glass, </span>
                        <span class="text-content">established in</span>
                        <span class="year"> 2006</span>
                        <span class="text-content"> in the Kingdom of Saudi Arabia as a closed joint-stock company with the participation of major strategic founding investors. In an important step towards expansion and growth, the company was listed on the Nomu Stock Market in 2024.</span>
                    </p>
                    <br><br>
                    <p class="text-content">
                        The company's headquarters are located in Yanbu on the Red Sea coast, where it operates a modern manufacturing plant covering an area of 350,000 square meters, with a production capacity of up to 700 tons per day. Today, UFG proudly offers a wide range of high-quality ARALUX® glass products, exporting large quantities to local, regional, and international markets…
                    </p>
                </div>
                <div class="about-button-container">
                    <button class="about-learn-more-btn" onclick="window.location.href='/about'">
                        Learn More
                    </button>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Modern Video Showcase Section -->
<section class="modern-video-showcase">
    <div class="showcase-container">
        <div class="video-theater">
            <!-- Video Background Gradient -->
            <div class="video-glow"></div>
            
            <!-- Main Player Container -->
            <div class="modern-player">
                <!-- Video Frame -->
                <div class="video-frame">
                    <iframe 
                        class="ufg-video" 
                        frameborder="0" 
                        allowfullscreen
                        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" 
                        title="UFG - Innovation in Glass Manufacturing" 
                        width="1280" 
                        height="720" 
                        src="https://www.youtube.com/embed/MNzWVa9q9xE?autoplay=1&mute=1&loop=1&playlist=MNzWVa9q9xE&controls=0&showinfo=0&rel=0&modestbranding=1&enablejsapi=1" 
                        id="ufg-player">
                    </iframe>
                    
                    <!-- Overlay Gradient -->
                    <div class="video-overlay"></div>
                </div>
                
                <!-- Modern Control Bar -->
                <div class="modern-controls">
                    <div class="control-gradient"></div>
                    <div class="control-bar">
                        <!-- Play/Pause -->
                        <button class="ctrl-btn play-pause" aria-label="Play/Pause">
                            <svg class="play-icon" viewBox="0 0 24 24">
                                <path d="M8 5v14l11-7z" fill="currentColor"/>
                            </svg>
                            <svg class="pause-icon" style="display:none" viewBox="0 0 24 24">
                                <path d="M6 4h4v16H6V4zm8 0h4v16h-4V4z" fill="currentColor"/>
                            </svg>
                        </button>
                        
                        <!-- Time Display -->
                        <div class="time-display">
                            <span class="current-time">0:00</span>
                            <span class="separator">/</span>
                            <span class="duration">0:00</span>
                        </div>
                        
                        <!-- Progress Bar -->
                        <div class="progress-container">
                            <div class="progress-track">
                                <div class="progress-buffered"></div>
                                <div class="progress-played"></div>
                                <div class="progress-handle"></div>
                            </div>
                        </div>
                        
                        <!-- Volume Control -->
                        <div class="volume-control">
                            <button class="ctrl-btn volume-btn" aria-label="Volume">
                                <svg class="volume-icon" viewBox="0 0 24 24">
                                    <path d="M3 9v6h4l5 5V4L7 9H3zm13.5 3c0-1.77-1.02-3.29-2.5-4.03v8.05c1.48-.73 2.5-2.25 2.5-4.02zM14 3.23v2.06c2.89.86 5 3.54 5 6.71s-2.11 5.85-5 6.71v2.06c4.01-.91 7-4.49 7-8.77s-2.99-7.86-7-8.77z" fill="currentColor"/>
                                </svg>
                            </button>
                            <div class="volume-slider">
                                <div class="volume-track">
                                    <div class="volume-fill"></div>
                                    <div class="volume-handle"></div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Fullscreen -->
                        <button class="ctrl-btn fullscreen-btn" aria-label="Fullscreen">
                            <svg class="fullscreen-icon" viewBox="0 0 24 24">
                                <path d="M7 14H5v5h5v-2H7v-3zm-2-4h2V7h3V5H5v5zm12 7h-3v2h5v-5h-2v3zM14 5v2h3v3h2V5h-5z" fill="currentColor"/>
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Stats Section - UFG IN NUMBERS -->
<section class="stats-section" style="background-image: url('{{ asset('assets/2025/08/2d798430fc0e6ab7087749eab6eaa37312a3da9e-scaled.png') }}');">
    <div class="stats-container">
        <div class="stats-header">
            <h2 class="stats-title">UFG IN NUMBERS</h2>
        </div>
        
        <div class="stats-grid">
            <!-- Years of Experience -->
            <div class="stat-card">
                <div class="stat-icon">
                    <img src="{{ asset('assets/2025/08/bff9b080454c9118e8d0dbc2c1724937.png') }}" alt="Years of Experience" width="60" height="60">
                </div>
                <div class="stat-counter">
                    <div class="stat-title">Years of experience</div>
                    <div class="stat-number-wrapper">
                        <span class="stat-number" data-target="19" data-duration="2000">0</span>
                        <span class="stat-suffix">+</span>
                    </div>
                </div>
            </div>
            
            <!-- Production Capacity -->
            <div class="stat-card">
                <div class="stat-icon">
                    <img src="{{ asset('assets/2025/08/c93c91a50a25d4d0b6ea4930271037ed.png') }}" alt="Tons per Year" width="60" height="60">
                </div>
                <div class="stat-counter">
                    <div class="stat-title">Tons/Years</div>
                    <div class="stat-number-wrapper">
                        <span class="stat-number" data-target="250000" data-duration="2000">0</span>
                    </div>
                </div>
            </div>
            
            <!-- Markets -->
            <div class="stat-card">
                <div class="stat-icon">
                    <img src="{{ asset('assets/2025/08/81724b2f21c4b49c246720f67b2283c1.svg') }}" alt="Markets" width="60" height="60">
                </div>
                <div class="stat-counter">
                    <div class="stat-title">Market</div>
                    <div class="stat-number-wrapper">
                        <span class="stat-number" data-target="30" data-duration="2000">0</span>
                        <span class="stat-suffix">+</span>
                    </div>
                </div>
            </div>
            
            <!-- Employees -->
            <div class="stat-card">
                <div class="stat-icon">
                    <img src="{{ asset('assets/2025/08/8394273d9fc34a498707fa6fe82c9d7a.png') }}" alt="Employees" width="60" height="60">
                </div>
                <div class="stat-counter">
                    <div class="stat-title">Employees</div>
                    <div class="stat-number-wrapper">
                        <span class="stat-number" data-target="30" data-duration="2000">0</span>
                        <span class="stat-suffix">+</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Products Section -->
<section class="products-section">
    <div class="products-container">
        <div class="products-layout">
            <!-- Left Side: Content -->
            <div class="products-left">
                <div class="products-badge">
                    <span class="products-badge-text">Masterpieces</span>
                </div>
                <h2 class="products-main-title">OUR PRODUCTS</h2>
                <p class="products-description">Arabian United Float Glass Company (UFG) is a leading Arab manufacturer of glass, established in 2006 in the Kingdom of Saudi Arabia as a closed joint-stock company with the participation of major strategic founding investors. In an important</p>
            </div>
            
            <!-- Right Side: Carousel -->
            <div class="products-right">
                <div class="products-carousel-container">
                    <div class="products-carousel" id="productsCarousel">
                        <!-- All Products View -->
                        <div class="product-slide active" data-category="all">
                            <div class="products-horizontal-scroll" id="productCarousel">
                                @forelse($allProducts as $product)
                                @php
                                    $categorySlug = '';
                                    if ($product->application && $product->application->standard && $product->application->standard->category) {
                                        $categorySlug = $product->application->standard->category->slug;
                                    } elseif ($product->standard && $product->standard->category) {
                                        $categorySlug = $product->standard->category->slug;
                                    }
                                @endphp
                                <a href="{{ route('products.show', ['category' => $categorySlug ?: 'products', 'product' => $product->slug]) }}" class="product-card" style="text-decoration: none; color: inherit; display: block;">
                                    <div class="product-image">
                                        @if($product->image)
                                            <img src="{{ asset('storage/' . $product->image) }}" alt="{{ $product->name }}">
                                        @else
                                            <img src="{{ asset('assets/2025/08/22dafa95b499b0bb8e5259edab864dd8.png') }}" alt="{{ $product->name }}">
                                        @endif
                                    </div>
                                    <div class="product-content">
                                        <h3 class="product-title">{{ strtoupper($product->name) }}</h3>
                                        <p class="product-subtitle">ARALUX ® {{ strtoupper($product->application->standard->category->name ?? $product->name) }}</p>
                                    </div>
                                </a>
                                @empty
                                <!-- Fallback static products -->
                                <div class="product-card">
                                    <div class="product-image">
                                        <img src="{{ asset('assets/2025/08/22dafa95b499b0bb8e5259edab864dd8.png') }}" alt="Clear Float Glass">
                                    </div>
                                    <div class="product-content">
                                        <h3 class="product-title">CLEAR FLOAT</h3>
                                        <p class="product-subtitle">ARALUX ® CLEAR FLOAT GLASS</p>
                                    </div>
                                </div>
                                <div class="product-card">
                                    <div class="product-image">
                                        <img src="{{ asset('assets/2025/08/916e25dc6d0624ef199078ceca60f5a3.png') }}" alt="Silver Mirror">
                                    </div>
                                    <div class="product-content">
                                        <h3 class="product-title">SILVER MIRROR</h3>
                                        <p class="product-subtitle">ARALUX ® SILVER MIRROR</p>
                                    </div>
                                </div>
                                @endforelse
                            </div>
                            <!-- Navigation Arrows -->
                            <button class="carousel-nav prev" id="scrollPrev">
                                <svg viewBox="0 0 24 24">
                                    <path d="M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z"/>
                                </svg>
                            </button>
                            <button class="carousel-nav next" id="scrollNext">
                                <svg viewBox="0 0 24 24">
                                    <path d="M10 6L8.59 7.41 13.17 12l-4.58 4.59L10 18l6-6z"/>
                                </svg>
                            </button>
                        </div>
                        
                        <!-- Individual Product Views by Category -->
                        @foreach($categories as $category)
                        <div class="product-slide" data-category="{{ $category->slug }}">
                            @php
                                $categoryProducts = collect();
                                foreach($category->standards as $standard) {
                                    foreach($standard->applications as $application) {
                                        $categoryProducts = $categoryProducts->merge($application->products);
                                    }
                                }
                                $featured = $categoryProducts->where('is_featured', true)->first();
                                $product = $featured ?: $categoryProducts->first();
                            @endphp
                            
                            @if($product)
                            <div class="product-card">
                                <div class="product-image">
                                    @if($product->image)
                                        <img src="{{ asset('storage/' . $product->image) }}" alt="{{ $product->name }}">
                                    @else
                                        <img src="{{ asset('assets/2025/08/22dafa95b499b0bb8e5259edab864dd8.png') }}" alt="{{ $product->name }}">
                                    @endif
                                </div>
                                <div class="product-content">
                                    <h3 class="product-title">{{ strtoupper($product->name) }}</h3>
                                    <p class="product-subtitle">ARALUX ® {{ strtoupper($category->name) }}</p>
                                </div>
                            </div>
                            @endif
                        </div>
                        @endforeach
                    </div>
                </div>
                
                <!-- Progressive Filter Tabs -->
                <div class="products-filter-tabs">
                    <!-- Back Button (hidden initially) -->
                    <button id="back-button" class="filter-tab back-btn" style="display: none;">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z"/>
                        </svg>
                    </button>
                    
                    <!-- Dynamic Tab Container -->
                    <div id="filter-tabs-container">
                        <!-- Categories (Initial) -->
                        <button class="filter-tab active" data-category="all">All</button>
                        @foreach($categories as $category)
                            <button class="filter-tab" data-category="{{ $category->slug }}">{{ $category->name }}</button>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Mobile Products Section - Direct Implementation -->
<section class="mobile-products-section">
    <div class="mobile-products-header">
        <div class="mobile-products-badge">Masterpieces</div>
        <h2 class="mobile-products-title">Our Products</h2>
        <p class="mobile-products-subtitle">Premium glass solutions for every need</p>
    </div>
    
    <div class="mobile-filter-tabs">
        <div class="mobile-filter-tab active" data-category="all">All</div>
        <div class="mobile-filter-tab" data-category="float">Float Glass</div>
        <div class="mobile-filter-tab" data-category="pattern">Pattern Glass</div>
        <div class="mobile-filter-tab" data-category="mirror">Mirror</div>
    </div>
    
    <div class="mobile-products-grid">
        <div class="mobile-product-card" data-category="float">
            <div class="mobile-product-icon">CF</div>
            <div class="mobile-product-image">
                <img src="{{ asset('assets/2025/08/22dafa95b499b0bb8e5259edab864dd8.png') }}" alt="Clear Float" loading="lazy">
            </div>
            <div class="mobile-product-content">
                <h3 class="mobile-product-title">Clear Float</h3>
                <p class="mobile-product-subtitle">ARALUX® Clear Float Glass</p>
                <p class="mobile-product-description">Premium quality clear float glass for modern applications</p>
            </div>
        </div>
        
        <div class="mobile-product-card" data-category="mirror">
            <div class="mobile-product-icon">SM</div>
            <div class="mobile-product-image">
                <img src="{{ asset('assets/2025/08/4eceeb29fe07bf385a17da7c6ce72470.png') }}" alt="Silver Mirror" loading="lazy">
            </div>
            <div class="mobile-product-content">
                <h3 class="mobile-product-title">Silver Mirror</h3>
                <p class="mobile-product-subtitle">ARALUX® Silver Mirror</p>
                <p class="mobile-product-description">High-quality silver mirror with superior reflectivity</p>
            </div>
        </div>
        
        <div class="mobile-product-card" data-category="pattern">
            <div class="mobile-product-icon">PG</div>
            <div class="mobile-product-image">
                <img src="{{ asset('assets/2025/08/916e25dc6d0624ef199078ceca60f5a3.png') }}" alt="Pattern Glass" loading="lazy">
            </div>
            <div class="mobile-product-content">
                <h3 class="mobile-product-title">Pattern Glass</h3>
                <p class="mobile-product-subtitle">ARALUX® Pattern Glass</p>
                <p class="mobile-product-description">Decorative pattern glass for aesthetic applications</p>
            </div>
        </div>
        
        <div class="mobile-product-card" data-category="mirror">
            <div class="mobile-product-icon">DM</div>
            <div class="mobile-product-image">
                <img src="{{ asset('assets/2025/08/916e25dc6d0624ef199078ceca60f5a3.png') }}" alt="Decorative Mirror" loading="lazy">
            </div>
            <div class="mobile-product-content">
                <h3 class="mobile-product-title">Decorative Mirror</h3>
                <p class="mobile-product-subtitle">ARALUX® Decorative Mirror</p>
                <p class="mobile-product-description">Artistic decorative mirrors for premium spaces</p>
            </div>
        </div>
    </div>
</section>

<!-- News Section -->
<section class="news-section">
    <div class="news-container">
        <div class="news-header">
            <div class="news-badge">
                <span class="news-badge-text">News</span>
            </div>
            <h2 class="news-main-title">LATEST UPDATES</h2>
        </div>
        
        <div class="news-cards-grid">
            @forelse($latestNews as $news)
                <article class="news-card">
                    <img src="{{ $news->featured_image_url }}" alt="{{ $news->title }}" class="news-image">
                    <div class="news-card-content">
                        <span class="news-category {{ strtolower($news->category ?: 'company') }}">{{ ucfirst($news->category ?: 'Company') }}</span>
                        <h3 class="news-title">{{ $news->title }}</h3>
                        <p class="news-description">{{ $news->excerpt }}</p>
                        <div class="news-footer">
                            <span class="news-date">{{ $news->published_at ? $news->published_at->format('F Y') : 'Recent' }}</span>
                            <a href="/news/{{ $news->slug }}" class="news-read-more">Read More</a>
                        </div>
                    </div>
                </article>
            @empty
                <div class="no-news-message" style="text-align: center; padding: 2rem; color: #666;">
                    <p>No news articles available at the moment.</p>
                </div>
            @endforelse
        </div>
        
        <div class="news-footer">
            <a href="/news" class="view-all-news-btn">
                <span>View All News</span>
                <svg class="btn-arrow" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M8.59 16.59L13.17 12L8.59 7.41L10 6l6 6l-6 6l-1.41-1.41z"/>
                </svg>
            </a>
        </div>
    </div>
</section>
@endsection

@push('scripts')
    <!-- Essential jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Hero Section Video Background -->
    <script src="{{ asset('assets/js/hero-section.js') }}"></script>
    
    <!-- Stats Counter Animation -->
    <script src="{{ asset('assets/js/stats-counter-animation.js') }}"></script>
    
    <!-- Dynamic Video Manager (replaces hardcoded video scripts) -->
    <script src="{{ asset('assets/js/dynamic-video-manager.js') }}"></script>
    
    <!-- Mobile Products Filtering Script -->
    <script src="{{ asset('assets/js/mobile-products-filter.js') }}"></script>
    
    <!-- Progressive Tab Morphing Script -->
    <script>
        // Pass Laravel data to global scope for external script
        window.homePageData = {
            categories: @json($categories),
            standards: @json($standards),
            applications: @json($applications),
            allProducts: @json($allProducts)
        };
    </script>
    <script src="{{ asset('assets/js/progressive-tab-morphing.js') }}"></script>
@endpush