@php
    use Illuminate\Support\Facades\Storage;
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Admin Panel')</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="{{ asset('css/careers.css') }}" rel="stylesheet">
    <script src="{{ asset('js/admin-layout.js') }}" defer></script>
    @stack('styles')
</head>
<body class="bg-gray-100">
    <div class="flex h-screen bg-gray-100">
        <!-- Sidebar -->
        <div class="admin-sidebar fixed inset-y-0 left-0 z-50 w-64 bg-white shadow-lg transform transition-transform duration-200 ease-in-out -translate-x-full lg:translate-x-0">
            
            <!-- Logo -->
            <div class="flex items-center justify-center p-6 border-b">
                <img src="{{ asset('assets/2025/08/aufg-logo.png') }}" alt="UFG Logo" class="h-12">
            </div>
            
            <!-- Navigation -->
            <nav class="mt-6 px-4">
                <a href="{{ route('admin.dashboard') }}" 
                   class="flex items-center p-3 mb-2 rounded-lg transition-colors {{ request()->is('admin/dashboard') ? 'bg-indigo-50 text-indigo-700' : 'text-gray-700 hover:bg-gray-100' }}">
                    <i class="fas fa-home w-5 h-5 mr-3"></i>
                    Dashboard
                </a>
                
                <!-- Careers Menu with Dropdown -->
                <div class="mb-2">
                    <button class="careers-menu-btn flex items-center justify-between w-full p-3 rounded-lg transition-colors
                                   {{ request()->is('admin/job-positions*') || request()->is('admin/applications*') ? 'bg-indigo-50 text-indigo-700 font-medium hover:bg-indigo-100' : 'text-gray-700 hover:bg-gray-100' }}">
                        <div class="flex items-center">
                            <i class="fas fa-briefcase w-5 h-5 mr-3"></i>
                            Careers
                        </div>
                        <i class="fas fa-chevron-down w-4 h-4 transition-transform duration-200 careers-chevron"></i>
                    </button>
                    
                    <div class="careers-dropdown ml-6 mt-1 space-y-1" style="display: none;">
                        <a href="{{ route('admin.job-positions') }}" 
                           class="flex items-center p-2 pl-4 rounded-lg transition-colors text-sm border-l-2 border-gray-200 hover:border-indigo-300 {{ request()->is('admin/job-positions*') ? 'bg-indigo-50 text-indigo-700 font-medium border-indigo-400' : 'text-gray-600 hover:bg-gray-50 hover:text-gray-800' }}">
                            <i class="fas fa-file-text w-4 h-4 mr-2"></i>
                            Job Positions
                        </a>
                        <a href="{{ route('admin.applications') }}" 
                           class="flex items-center p-2 pl-4 rounded-lg transition-colors text-sm border-l-2 border-gray-200 hover:border-indigo-300 {{ request()->is('admin/applications*') ? 'bg-indigo-50 text-indigo-700 font-medium border-indigo-400' : 'text-gray-600 hover:bg-gray-50 hover:text-gray-800' }}">
                            <i class="fas fa-users w-4 h-4 mr-2"></i>
                            Applications
                        </a>
                    </div>
                </div>

                <!-- Page Management -->
                <a href="{{ route('admin.pages.index') }}" 
                   class="flex items-center p-3 mb-2 rounded-lg transition-colors {{ request()->is('admin/pages*') ? 'bg-indigo-50 text-indigo-700' : 'text-gray-700 hover:bg-gray-100' }}">
                    <i class="fas fa-file-alt w-5 h-5 mr-3"></i>
                    Pages
                </a>
            </nav>
            
            <!-- Logout -->
            <div class="absolute bottom-4 left-4 right-4">
                <form method="POST" action="{{ route('admin.logout') }}">
                    @csrf
                    <button type="submit" class="flex items-center w-full p-3 text-red-600 hover:bg-red-50 rounded-lg transition-colors">
                        <i class="fas fa-sign-out-alt w-5 h-5 mr-3"></i>
                        Logout
                    </button>
                </form>
            </div>
        </div>
        
        <!-- Mobile backdrop -->
        <div class="mobile-backdrop fixed inset-0 z-40 bg-black bg-opacity-50 transition-opacity lg:hidden" style="display: none;"></div>
        
        <!-- Main content -->
        <div class="flex-1 flex flex-col lg:ml-64">
            <!-- Header -->
            <header class="bg-white shadow-sm border-b border-gray-200 p-4">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <button class="mobile-menu-btn lg:hidden p-2 rounded-lg text-gray-500 hover:bg-gray-100">
                            <i class="fas fa-bars w-6 h-6"></i>
                        </button>
                        <h1 class="ml-4 lg:ml-0 text-2xl font-bold text-gray-900">
                            @yield('page-title', 'Admin Panel')
                        </h1>
                    </div>
                    
                    <!-- Profile Dropdown -->
                    <div class="relative profile-dropdown">
                        <button class="profile-btn flex items-center space-x-3 p-2 rounded-lg hover:bg-gray-100 transition-colors focus:outline-none focus:ring-2 focus:ring-indigo-500">
                            <img alt="Avatar" 
                                 src="{{ asset('admin-assets/images/256_daniel-gaffey-1060698-unsplash.jpg') }}" 
                                 class="w-10 h-10 rounded-full object-cover border-2 border-gray-200">
                            <div class="hidden md:block text-left">
                                <p class="text-sm font-medium text-gray-700">{{ auth()->user()->name ?? 'Admin' }}</p>
                                <p class="text-xs text-gray-500">{{ auth()->user()->email ?? '' }}</p>
                            </div>
                            <i class="fas fa-chevron-down text-gray-400 text-xs"></i>
                        </button>
                        
                        <!-- Dropdown Menu -->
                        <div class="profile-menu hidden absolute right-0 mt-2 w-56 bg-white rounded-lg shadow-lg border border-gray-200 py-2" style="display: none; z-index: 9999;">
                            <div class="px-4 py-3 border-b border-gray-200">
                                <p class="text-sm font-medium text-gray-900">{{ auth()->user()->name ?? 'Admin' }}</p>
                                <p class="text-sm text-gray-500">{{ auth()->user()->email ?? '' }}</p>
                            </div>
                            
                            <a href="#" 
                               class="flex items-center px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 transition-colors"
                               onclick="alert('Profile settings page coming soon!'); return false;">
                                <i class="fas fa-user-cog w-4 h-4 mr-3 text-gray-400"></i>
                                Profile Settings
                            </a>
                            
                            <a href="#" 
                               class="flex items-center px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 transition-colors"
                               onclick="alert('Change password feature coming soon!'); return false;">
                                <i class="fas fa-lock w-4 h-4 mr-3 text-gray-400"></i>
                                Change Password
                            </a>
                            
                            <div class="border-t border-gray-200 mt-2 pt-2">
                                <form method="POST" action="{{ route('admin.logout') }}">
                                    @csrf
                                    <button type="submit" class="flex items-center w-full px-4 py-2 text-sm text-red-600 hover:bg-red-50 transition-colors">
                                        <i class="fas fa-sign-out-alt w-4 h-4 mr-3"></i>
                                        Logout
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </header>
            
            <!-- Main content area -->
            <main class="flex-1 p-6 overflow-auto">
                @yield('content')
            </main>
        </div>
    </div>

    @yield('modals')

    <!-- Toast Notification -->
    <div id="toast-notification" style="display: none;"
         class="fixed bottom-4 right-4 z-50">
        <div id="toast-content" class="text-white px-6 py-4 rounded-lg shadow-lg">
            <p id="toast-message"></p>
        </div>
    </div>

    <script>
    // Toast notification function
    function showToastMessage(message, type = 'success') {
        const toast = document.getElementById('toast-notification');
        const content = document.getElementById('toast-content');
        const messageEl = document.getElementById('toast-message');
        
        messageEl.textContent = message;
        content.className = `text-white px-6 py-4 rounded-lg shadow-lg ${type === 'success' ? 'bg-green-500' : 'bg-red-500'}`;
        
        toast.style.display = 'block';
        
        setTimeout(() => {
            toast.style.display = 'none';
        }, 5000);
    }
    
    // Profile dropdown functionality (inline fallback)
    document.addEventListener('DOMContentLoaded', function() {
        console.log('DOM loaded, initializing profile dropdown');
        
        const profileBtn = document.querySelector('.profile-btn');
        const profileMenu = document.querySelector('.profile-menu');
        
        console.log('Profile dropdown elements found:', {
            profileBtn: !!profileBtn, 
            profileMenu: !!profileMenu
        });
        
        if (profileBtn && profileMenu) {
            console.log('Setting up click event listener');
            
            // Toggle dropdown on click
            profileBtn.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                console.log('Profile button clicked!');
                
                // Toggle visibility using classes instead of inline styles
                if (profileMenu.classList.contains('hidden')) {
                    profileMenu.classList.remove('hidden');
                    profileMenu.style.display = 'block';
                    console.log('Showing menu');
                } else {
                    profileMenu.classList.add('hidden');
                    profileMenu.style.display = 'none';
                    console.log('Hiding menu');
                }
            });
            
            // Close dropdown when clicking outside
            document.addEventListener('click', function(e) {
                if (!e.target.closest('.profile-dropdown')) {
                    profileMenu.classList.add('hidden');
                    profileMenu.style.display = 'none';
                }
            });
            
            // Prevent dropdown from closing when clicking inside
            profileMenu.addEventListener('click', function(e) {
                e.stopPropagation();
            });
            
            console.log('Profile dropdown initialized successfully');
        } else {
            console.error('Profile dropdown elements not found!', {
                profileBtn: profileBtn,
                profileMenu: profileMenu
            });
        }
    });
    </script>
    
    @stack('scripts')
</body>
</html>