@extends('layouts.admin-simple')

@section('title', 'Incoming Operations')

@section('breadcrumb')
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item active">Incoming Operations</li>
@endsection

@section('page-title')
    <div class="page-title-left">
        <h3 class="mb-1">Incoming Operations</h3>
        <p class="text-muted mb-0" style="font-size: 13px;">Enhanced construction materials receiving system</p>
    </div>
@endsection

@section('content')
    <!-- Layout Debug Info -->
    <div class="alert alert-info mb-4">
        <strong>Debug Info:</strong>
        Layout loaded successfully. If you can see this message and the navigation sidebar, the layout is working correctly.
        <br><small>Current route: {{ request()->route()->getName() }}</small>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <x-warehouse.stats-card
                title="Total Operations"
                :value="$operations->count() ?? 0"
                icon="input"
                color="primary"
                subtitle="All incoming operations"
            />
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <x-warehouse.stats-card
                title="Direct Processing"
                :value="$operations->whereIn('operation_type', ['supplier_delivery', 'site_return'])->count() ?? 0"
                icon="flash_on"
                color="warning"
                subtitle="Auto-processed operations"
            />
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <x-warehouse.stats-card
                title="Pending Review"
                :value="$operations->whereIn('status', ['pending_inspection', 'approved'])->count() ?? 0"
                icon="check_circle"
                color="success"
                subtitle="Needs manual approval"
            />
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <x-warehouse.stats-card
                title="Completed"
                :value="$operations->where('status', 'completed')->count() ?? 0"
                icon="done_all"
                color="info"
                subtitle="Inventory updated"
            />
        </div>
    </div>

    <!-- Simple Operations List -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">list</i>
                Operations List
            </h5>
        </div>
        <div class="card-body">
            @if($operations->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Operation #</th>
                                <th>Type</th>
                                <th>Date</th>
                                <th>Supplier/Source</th>
                                <th>Status</th>
                                <th>Total (AED)</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($operations as $operation)
                                <tr>
                                    <td>{{ $operation->operation_number }}</td>
                                    <td>
                                        <span class="badge badge-primary">
                                            {{ ucfirst(str_replace('_', ' ', $operation->operation_type)) }}
                                        </span>
                                    </td>
                                    <td>{{ $operation->operation_date }}</td>
                                    <td>{{ $operation->supplier->name ?? '-' }}</td>
                                    <td>
                                        <span class="badge badge-{{ $operation->status === 'completed' ? 'success' : ($operation->status === 'pending_inspection' ? 'warning' : 'secondary') }}">
                                            {{ ucfirst(str_replace('_', ' ', $operation->status)) }}
                                        </span>
                                    </td>
                                    <td>{{ number_format($operation->total_amount_aed ?? 0, 2) }}</td>
                                    <td>
                                        <a href="{{ route('warehouse.incoming-operations.show', $operation->id) }}" class="btn btn-sm btn-outline-primary">
                                            <i class="material-icons" style="font-size: 16px;">visibility</i>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                @if($operations->hasPages())
                    <div class="d-flex justify-content-center mt-4">
                        {{ $operations->links() }}
                    </div>
                @endif
            @else
                <div class="text-center py-4">
                    <i class="material-icons text-muted mb-3" style="font-size: 48px;">inbox</i>
                    <h5 class="text-muted">No Operations Found</h5>
                    <p class="text-muted mb-4">There are no incoming operations to display.</p>
                    @can('warehouse.incoming.create')
                        <a href="{{ route('warehouse.incoming-operations.create', ['type' => 'supplier_delivery']) }}" class="btn btn-primary">
                            <i class="material-icons mr-1">add</i>
                            Create First Operation
                        </a>
                    @endcan
                </div>
            @endif
        </div>
    </div>

    <!-- JavaScript Debug -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            console.log('✅ Incoming Operations page loaded successfully');
            console.log('✅ Layout structure:', {
                header: document.querySelector('#header') ? 'Found' : 'Missing',
                sidebar: document.querySelector('.mdk-drawer') ? 'Found' : 'Missing',
                content: document.querySelector('.page') ? 'Found' : 'Missing',
                preloader: document.querySelector('.preloader') ? 'Found' : 'Missing'
            });

            // Hide preloader if it's still showing
            const preloader = document.querySelector('.preloader');
            if (preloader) {
                setTimeout(() => {
                    preloader.style.display = 'none';
                }, 1000);
            }
        });
    </script>
@endsection

@push('styles')
    <style>
        .icon {
            width: 3rem;
            height: 3rem;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .icon-shape {
            padding: 12px;
            text-align: center;
            display: inline-flex;
            align-items: center;
            justify-content: center;
        }

        .bg-primary {
            background-color: #5e72e4 !important;
        }

        .bg-warning {
            background-color: #fb6340 !important;
        }

        .bg-success {
            background-color: #2dce89 !important;
        }

        .bg-info {
            background-color: #11cdef !important;
        }

        .rounded-circle {
            border-radius: 50% !important;
        

        .shadow {
            box-shadow: 0 0.15rem 1.75rem 0 rgba(33, 40, 50, 0.15) !important;
        }
    </style>
@endpush