@extends('layouts.admin-simple')

@section('title', 'Incoming Operation Details')

@section('breadcrumb')
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.incoming-operations.index') }}">Incoming Operations</a></li>
    <li class="breadcrumb-item active">Operation #{{ $operation->operation_number }}</li>
@endsection

@section('page-title')
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">Operation #{{ $operation->operation_number }}</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">{{ $operation->operation_type_label }} - {{ $operation->status }}</p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <a href="{{ route('warehouse.incoming-operations.index') }}" class="btn btn-sm btn-outline-secondary mr-2">
                <i class="material-icons mr-1" style="font-size: 16px;">arrow_back</i>
                Back to List
            </a>
            @if($operation->status !== 'completed')
                <a href="{{ route('warehouse.incoming-operations.edit', $operation) }}" class="btn btn-sm btn-primary">
                    <i class="material-icons mr-1" style="font-size: 16px;">edit</i>
                    Edit
                </a>
            @endif
        </div>
    </div>
@endsection

@section('content')
    <!-- Operation Details Card -->
    <div class="card mb-3">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">info</i>
                Operation Details
            </h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Operation Number:</strong></td>
                            <td>{{ $operation->operation_number }}</td>
                        </tr>
                        <tr>
                            <td><strong>Operation Type:</strong></td>
                            <td>{{ $operation->operation_type_label }}</td>
                        </tr>
                        <tr>
                            <td><strong>Operation Date:</strong></td>
                            <td>{{ $operation->operation_date->format('d M, Y') }}</td>
                        </tr>
                        <tr>
                            <td><strong>Status:</strong></td>
                            <td><span class="badge {{ $operation->status_badge_class }}">{{ ucfirst($operation->status) }}</span></td>
                        </tr>
                        @if($operation->supplier)
                        <tr>
                            <td><strong>Supplier:</strong></td>
                            <td>{{ $operation->supplier->name }}</td>
                        </tr>
                        @endif
                        @if($operation->operation_type === 'site_return' && $operation->materialRequest)
                        <tr>
                            <td><strong>MR Reference:</strong></td>
                            <td>
                                <span class="badge badge-info">
                                    {{ $operation->materialRequest->material_request_number ?: 'MR-' . str_pad($operation->material_request_id, 6, '0', STR_PAD_LEFT) }}
                                </span>
                            </td>
                        </tr>
                        @endif
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Division:</strong></td>
                            <td>{{ $operation->division }}</td>
                        </tr>
                    </table>
                </div>
            </div>

            @if($operation->notes)
            <div class="row mt-3">
                <div class="col-12">
                    <strong>Notes:</strong>
                    <p class="text-muted mb-0">{{ $operation->notes }}</p>
                </div>
            </div>
            @endif
        </div>
    </div>

    <!-- Items Card -->
    <div class="card mb-3">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">inventory</i>
                Items ({{ $operation->items->count() }})
            </h6>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-sm mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th>Item</th>
                            <th>Quantity</th>
                            <th>Batch</th>
                            <th>Production Date</th>
                            <th>Expiry Date</th>
                            <th>Quality Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($operation->items as $item)
                        <tr>
                            <td>
                                <strong>{{ $item->item->item_description ?? 'Unknown Item' }}</strong><br>
                                <small class="text-muted">{{ $item->item->item_code ?? 'NO-CODE' }}</small>
                            </td>
                            <td>{{ number_format($item->quantity_delivered, 2) }} {{ $item->item->unit_of_measure ?? 'units' }}</td>
                            <td>{{ $item->batch_number ?: '-' }}</td>
                            <td>{{ $item->production_date ? $item->production_date->format('d M, Y') : '-' }}</td>
                            <td>{{ $item->expiry_date ? $item->expiry_date->format('d M, Y') : '-' }}</td>
                            <td><span class="badge {{ $item->quality_status_badge_class }}">{{ ucfirst($item->quality_status) }}</span></td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="6" class="text-center text-muted">No items found</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Receiving Information Card -->
    <div class="card">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">person</i>
                Receiving Information
            </h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Received By:</strong></td>
                            <td>{{ $operation->receiver->name ?? 'Unknown' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Received By Name:</strong></td>
                            <td>{{ $operation->received_by_name ?: '-' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Created At:</strong></td>
                            <td>{{ $operation->created_at->format('d M, Y H:i') }}</td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    @if($operation->lpo_number)
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>LPO Number:</strong></td>
                            <td>{{ $operation->lpo_number }}</td>
                        </tr>
                        @if($operation->delivery_note_number)
                        <tr>
                            <td><strong>Delivery Note:</strong></td>
                            <td>{{ $operation->delivery_note_number }}</td>
                        </tr>
                        @endif
                    </table>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection

@push('styles')
    <style>
        .card-title {
            font-size: 16px;
            font-weight: 600;
            color: #495057;
        }

        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
            font-size: 13px;
        }

        .table td {
            vertical-align: middle;
            font-size: 13px;
        }

        .table-borderless td {
            border: none;
            padding: 0.25rem 0.5rem;
        }

        .badge {
            font-size: 11px;
            padding: 4px 8px;
        }
    </style>
@endpush