@extends('layouts.admin-simple')

@section('title', $project->project_name)
@section('page-title', $project->project_name)
@section('page-subtitle', 'Project Details')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('warehouse.projects.index') }}">Projects</a></li>
    <li class="breadcrumb-item active">{{ $project->project_name }}</li>
@endsection

@section('page-actions')
    <div class="d-flex">
        @can('warehouse.projects.edit')
        <a href="{{ route('warehouse.projects.edit', $project) }}" class="btn btn-primary btn-sm">
            <i class="material-icons mr-1" style="font-size: 16px;">edit</i>
            Edit Project
        </a>
        @endcan
    </div>
@endsection

@section('content')
    <!-- Project Information -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Project Information</h6>
        </div>

        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <h6 class="text-primary font-weight-bold mb-3">Basic Information</h6>
                    <dl class="row">
                        <dt class="col-sm-4 text-muted">Project Number</dt>
                        <dd class="col-sm-8">{{ $project->project_number ?: 'Not set' }}</dd>

                        <dt class="col-sm-4 text-muted">Project ID</dt>
                        <dd class="col-sm-8">{{ $project->project_id ?: 'Not synced' }}</dd>

                        <dt class="col-sm-4 text-muted">Project Name</dt>
                        <dd class="col-sm-8">{{ $project->project_name }}</dd>

                        <dt class="col-sm-4 text-muted">Project Division</dt>
                        <dd class="col-sm-8">
                            @if($project->projectDivision)
                                {{ $project->projectDivision->division_name }} ({{ $project->projectDivision->division_code }})
                            @else
                                <span class="text-muted">Not assigned</span>
                            @endif
                        </dd>

                        <dt class="col-sm-4 text-muted">Created Date</dt>
                        <dd class="col-sm-8">{{ $project->created_at->format('M d, Y H:i') }}</dd>

                        <dt class="col-sm-4 text-muted">Last Updated</dt>
                        <dd class="col-sm-8">{{ $project->updated_at->format('M d, Y H:i') }}</dd>
                    </dl>
                </div>

                <div class="col-md-6">
                    <h6 class="text-primary font-weight-bold mb-3">Project Status</h6>
                    <dl class="row">
                        <dt class="col-sm-4 text-muted">Status</dt>
                        <dd class="col-sm-8">
                            <span class="badge badge-success">Active</span>
                        </dd>

                        <dt class="col-sm-4 text-muted">External ID</dt>
                        <dd class="col-sm-8">{{ $project->external_project_id ?: 'Not set' }}</dd>

                        <dt class="col-sm-4 text-muted">Last Synced</dt>
                        <dd class="col-sm-8">
                            @if($project->last_synced_at)
                                {{ $project->last_synced_at->format('M d, Y H:i') }}
                            @else
                                <span class="text-muted">Never</span>
                            @endif
                        </dd>
                    </dl>
                </div>
            </div>
        </div>
    </div>
@endsection