@extends('layouts.admin-simple')

@section('title', 'Warehouse Reports')

@section('breadcrumb')
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item active">Reports</li>
@endsection

@section('page-title')
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">Warehouse Reports</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">Comprehensive warehouse analytics and reports</p>
        </div>
    </div>
@endsection

@section('content')
    <div class="row">
        <!-- Inventory Report -->
        <div class="col-lg-4 col-md-6 mb-4">
            <div class="card h-100 report-card">
                <div class="card-body">
                    <div class="d-flex align-items-center mb-3">
                        <div class="report-icon bg-primary text-white mr-3">
                            <i class="material-icons">inventory</i>
                        </div>
                        <div>
                            <h5 class="card-title mb-0">Inventory Report</h5>
                            <p class="text-muted mb-0 small">Detailed inventory analysis</p>
                        </div>
                    </div>
                    <p class="card-text">Comprehensive inventory report with pricing insights, stock levels, expiry tracking, and division-wise distribution.</p>
                    <div class="mt-auto">
                        <a href="{{ route('warehouse.reports.inventory') }}" class="btn btn-primary btn-sm">
                            <i class="material-icons mr-1" style="font-size: 16px;">assessment</i>
                            View Report
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Supplier Delivery Report -->
        <div class="col-lg-4 col-md-6 mb-4">
            <div class="card h-100 report-card">
                <div class="card-body">
                    <div class="d-flex align-items-center mb-3">
                        <div class="report-icon bg-success text-white mr-3">
                            <i class="material-icons">local_shipping</i>
                        </div>
                        <div>
                            <h5 class="card-title mb-0">Supplier Delivery</h5>
                            <p class="text-muted mb-0 small">Supplier deliveries tracking</p>
                        </div>
                    </div>
                    <p class="card-text">Track supplier deliveries, LPO fulfillment, quality control, batch tracking, and pricing analysis by supplier and division.</p>
                    <div class="mt-auto">
                        <a href="{{ route('warehouse.reports.incoming') }}" class="btn btn-success btn-sm">
                            <i class="material-icons mr-1" style="font-size: 16px;">local_shipping</i>
                            View Report
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Site Return Report -->
        <div class="col-lg-4 col-md-6 mb-4">
            <div class="card h-100 report-card">
                <div class="card-body">
                    <div class="d-flex align-items-center mb-3">
                        <div class="report-icon bg-warning text-white mr-3">
                            <i class="material-icons">assignment_return</i>
                        </div>
                        <div>
                            <h5 class="card-title mb-0">Site Return</h5>
                            <p class="text-muted mb-0 small">Site returns tracking</p>
                        </div>
                    </div>
                    <p class="card-text">Track returned materials from sites, return conditions, actions taken, and processing status by project and division.</p>
                    <div class="mt-auto">
                        <a href="{{ route('warehouse.reports.returns') }}" class="btn btn-warning btn-sm">
                            <i class="material-icons mr-1" style="font-size: 16px;">assignment_return</i>
                            View Report
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Material Request Report -->
        <div class="col-lg-4 col-md-6 mb-4">
            <div class="card h-100 report-card">
                <div class="card-body">
                    <div class="d-flex align-items-center mb-3">
                        <div class="report-icon bg-warning text-white mr-3">
                            <i class="material-icons">outbound</i>
                        </div>
                        <div>
                            <h5 class="card-title mb-0">Material Request</h5>
                            <p class="text-muted mb-0 small">Material requests tracking</p>
                        </div>
                    </div>
                    <p class="card-text">Track material requests, quantities requested vs released, fulfillment status, and receiver details by project and division.</p>
                    <div class="mt-auto">
                        <a href="{{ route('warehouse.reports.outgoing') }}" class="btn btn-warning btn-sm">
                            <i class="material-icons mr-1" style="font-size: 16px;">assignment_turned_in</i>
                            View Report
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Stock Movements Report -->
        <div class="col-lg-4 col-md-6 mb-4">
            <div class="card h-100 report-card">
                <div class="card-body">
                    <div class="d-flex align-items-center mb-3">
                        <div class="report-icon bg-success text-white mr-3">
                            <i class="material-icons">swap_horiz</i>
                        </div>
                        <div>
                            <h5 class="card-title mb-0">Stock Movements</h5>
                            <p class="text-muted mb-0 small">Track inventory movements</p>
                        </div>
                    </div>
                    <p class="card-text">Track all inventory movements, transfers between divisions, and transaction history.</p>
                    <div class="mt-auto">
                        <a href="{{ route('warehouse.reports.stock-movements') }}" class="btn btn-success btn-sm">
                            <i class="material-icons mr-1" style="font-size: 16px;">timeline</i>
                            View Report
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Material Issue Report -->
        <div class="col-lg-4 col-md-6 mb-4">
            <div class="card h-100 report-card">
                <div class="card-body">
                    <div class="d-flex align-items-center mb-3">
                        <div class="report-icon bg-info text-white mr-3">
                            <i class="material-icons">receipt</i>
                        </div>
                        <div>
                            <h5 class="card-title mb-0">Material Issue Report</h5>
                            <p class="text-muted mb-0 small">Material issue and dispatch tracking</p>
                        </div>
                    </div>
                    <p class="card-text">Detailed analysis of all material issues, dispatches, and fulfillment activities with status tracking.</p>
                    <div class="mt-auto">
                        <a href="{{ route('warehouse.reports.transactions') }}" class="btn btn-info btn-sm">
                            <i class="material-icons mr-1" style="font-size: 16px;">list_alt</i>
                            View Report
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Low Stock Report -->
        <div class="col-lg-4 col-md-6 mb-4">
            <div class="card h-100 report-card">
                <div class="card-body">
                    <div class="d-flex align-items-center mb-3">
                        <div class="report-icon bg-warning text-white mr-3">
                            <i class="material-icons">warning</i>
                        </div>
                        <div>
                            <h5 class="card-title mb-0">Low Stock Alert</h5>
                            <p class="text-muted mb-0 small">Items below reorder point</p>
                        </div>
                    </div>
                    <p class="card-text">Monitor items that are running low on stock and need immediate attention for reordering.</p>
                    <div class="mt-auto">
                        <a href="{{ route('warehouse.reports.low-stock') }}" class="btn btn-warning btn-sm">
                            <i class="material-icons mr-1" style="font-size: 16px;">notification_important</i>
                            View Report
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Aging Report -->
        <div class="col-lg-4 col-md-6 mb-4">
            <div class="card h-100 report-card">
                <div class="card-body">
                    <div class="d-flex align-items-center mb-3">
                        <div class="report-icon bg-secondary text-white mr-3">
                            <i class="material-icons">schedule</i>
                        </div>
                        <div>
                            <h5 class="card-title mb-0">Aging Report</h5>
                            <p class="text-muted mb-0 small">Inventory age analysis</p>
                        </div>
                    </div>
                    <p class="card-text">Analyze inventory age, identify slow-moving items, and track expiry dates for better inventory management.</p>
                    <div class="mt-auto">
                        <a href="{{ route('warehouse.reports.aging') }}" class="btn btn-secondary btn-sm">
                            <i class="material-icons mr-1" style="font-size: 16px;">access_time</i>
                            View Report
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Supplier Performance -->
        <div class="col-lg-4 col-md-6 mb-4">
            <div class="card h-100 report-card">
                <div class="card-body">
                    <div class="d-flex align-items-center mb-3">
                        <div class="report-icon bg-danger text-white mr-3">
                            <i class="material-icons">business</i>
                        </div>
                        <div>
                            <h5 class="card-title mb-0">Supplier Performance</h5>
                            <p class="text-muted mb-0 small">Supplier analytics and ratings</p>
                        </div>
                    </div>
                    <p class="card-text">Comprehensive supplier performance analysis including delivery times, quality metrics, and cost effectiveness.</p>
                    <div class="mt-auto">
                        <a href="{{ route('warehouse.reports.supplier-performance') }}" class="btn btn-danger btn-sm">
                            <i class="material-icons mr-1" style="font-size: 16px;">trending_up</i>
                            View Report
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('styles')
    <style>
        .report-card {
            transition: transform 0.2s ease, box-shadow 0.2s ease;
        }

        .report-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }

        .report-icon {
            width: 50px;
            height: 50px;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .card-body {
            display: flex;
            flex-direction: column;
            height: 100%;
        }

        .card-text {
            flex-grow: 1;
            margin-bottom: 1rem;
        }
    </style>
@endpush