@extends('layouts.admin-simple')

@section('title', 'Reference Allocations - ' . $item->item_description)

@section('breadcrumb')
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item">Reports</li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.reports.stock-on-project') }}">Stock on Project</a></li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.reports.stock-on-project.details', $project->id) }}">{{ $project->project_name }}</a></li>
    <li class="breadcrumb-item active">Reference Allocations</li>
@endsection

@section('page-title')
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">Reference Allocations</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">
                Item: {{ $item->item_description }} ({{ $item->item_code }}) |
                Project: {{ $project->project_name }}
            </p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <a href="{{ route('warehouse.reports.stock-on-project.details', $project->id) }}" class="btn btn-sm btn-secondary mr-2">
                <i class="material-icons mr-1" style="font-size: 16px;">arrow_back</i>
                Back to Stock Details
            </a>
            <button type="button" onclick="exportAllocations()" class="btn btn-sm btn-success mr-2" title="Export to Excel">
                <i class="material-icons mr-1" style="font-size: 16px;">file_download</i>
                Export
            </button>
            <button type="button" onclick="printAllocations()" class="btn btn-sm btn-info" title="Print Report">
                <i class="material-icons mr-1" style="font-size: 16px;">print</i>
                Print
            </button>
        </div>
    </div>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Item Information Card -->
    <div class="card mb-4">
        <div class="card-header bg-primary text-white">
            <h6 class="mb-0">
                <i class="material-icons mr-2">inventory_2</i>
                Item Information
            </h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-4">
                    <div class="d-flex align-items-center mb-2">
                        <strong class="mr-2">Item Code:</strong>
                        <span class="badge badge-light">{{ $item->item_code }}</span>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="d-flex align-items-center mb-2">
                        <strong class="mr-2">Description:</strong>
                        <span>{{ $item->item_description }}</span>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="d-flex align-items-center mb-2">
                        <strong class="mr-2">Unit:</strong>
                        <span class="badge badge-secondary">{{ $item->unit_of_measure }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card border-primary">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="mr-3">
                            <i class="material-icons text-primary" style="font-size: 36px;">output</i>
                        </div>
                        <div>
                            <div class="text-muted small">Total Released</div>
                            <div class="h4 mb-0 text-primary">{{ number_format($totals['total_released'], 2) }}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-warning">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="mr-3">
                            <i class="material-icons text-warning" style="font-size: 36px;">undo</i>
                        </div>
                        <div>
                            <div class="text-muted small">Total Returned</div>
                            <div class="h4 mb-0 text-warning">{{ number_format($totals['total_returned'], 2) }}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-info">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="mr-3">
                            <i class="material-icons text-info" style="font-size: 36px;">swap_horiz</i>
                        </div>
                        <div>
                            <div class="text-muted small">Total Transferred</div>
                            <div class="h4 mb-0 text-info">{{ number_format($totals['total_transferred'], 2) }}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-success">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="mr-3">
                            <i class="material-icons text-success" style="font-size: 36px;">check_circle</i>
                        </div>
                        <div>
                            <div class="text-muted small">Net Available</div>
                            <div class="h4 mb-0 text-success">{{ number_format($totals['total_net'], 2) }}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Reference Allocations Table -->
    <div class="card">
        <div class="card-header">
            <h6 class="card-title mb-0">
                <i class="material-icons mr-2">receipt_long</i>
                Reference Allocations Detail
                @if($references->count() > 0)
                    <span class="badge badge-primary ml-2">{{ $references->count() }} References</span>
                @endif
            </h6>
        </div>
        <div class="card-body">
            @if($references->count() > 0)
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th>Type</th>
                                <th>Reference #</th>
                                <th>Date</th>
                                <th>Requested By / Supplier</th>
                                <th>Division / From</th>
                                <th>Status</th>
                                <th class="text-right">Released</th>
                                <th class="text-right">Returned</th>
                                <th class="text-right">Transferred</th>
                                <th class="text-right">Net Qty</th>
                                <th class="text-right">Value (AED)</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($references as $ref)
                                @php
                                    $typeClass = $ref['type'] === 'Material Request' ? 'badge-primary' :
                                                ($ref['type'] === 'Direct Delivery' ? 'badge-success' : 'badge-info');
                                    $statusClass = in_array(strtolower($ref['status']), ['successful', 'delivered', 'approved', 'received']) ?
                                                   'badge-success' : 'badge-warning';
                                @endphp
                                <tr>
                                    <td>
                                        <span class="badge {{ $typeClass }}">{{ $ref['type'] }}</span>
                                    </td>
                                    <td>
                                        <strong>{{ $ref['reference_number'] }}</strong>
                                    </td>
                                    <td>{{ $ref['date'] }}</td>
                                    <td>{{ $ref['requested_by'] }}</td>
                                    <td>{{ $ref['division'] }}</td>
                                    <td>
                                        <span class="badge {{ $statusClass }}">{{ $ref['status'] }}</span>
                                    </td>
                                    <td class="text-right">
                                        {{ number_format($ref['quantity_released'], 2) }}
                                    </td>
                                    <td class="text-right text-warning">
                                        {{ number_format($ref['quantity_returned'], 2) }}
                                    </td>
                                    <td class="text-right text-info">
                                        {{ number_format($ref['quantity_transferred'], 2) }}
                                    </td>
                                    <td class="text-right text-success">
                                        <strong>{{ number_format($ref['net_quantity'], 2) }}</strong>
                                    </td>
                                    <td class="text-right">
                                        AED {{ number_format($ref['total_value'], 2) }}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot class="bg-light">
                            <tr>
                                <th colspan="6"><strong>Total</strong></th>
                                <th class="text-right">
                                    <strong>{{ number_format($totals['total_released'], 2) }}</strong>
                                </th>
                                <th class="text-right text-warning">
                                    <strong>{{ number_format($totals['total_returned'], 2) }}</strong>
                                </th>
                                <th class="text-right text-info">
                                    <strong>{{ number_format($totals['total_transferred'], 2) }}</strong>
                                </th>
                                <th class="text-right text-success">
                                    <strong>{{ number_format($totals['total_net'], 2) }}</strong>
                                </th>
                                <th class="text-right">
                                    <strong>AED {{ number_format($totals['total_value'], 2) }}</strong>
                                </th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            @else
                <div class="text-center py-5">
                    <i class="material-icons text-muted mb-3" style="font-size: 48px;">inbox</i>
                    <h5 class="text-muted mb-2">No Reference Allocations Found</h5>
                    <p class="text-muted">
                        No reference allocations found for this item in the selected project.<br>
                        This means the item hasn't been delivered or transferred to this project.
                    </p>
                    <a href="{{ route('warehouse.reports.stock-on-project.details', $project->id) }}" class="btn btn-primary mt-3">
                        <i class="material-icons mr-1">arrow_back</i>
                        Back to Stock Details
                    </a>
                </div>
            @endif
        </div>
    </div>

    <!-- Additional Information -->
    @if($references->count() > 0)
    <div class="card mt-4">
        <div class="card-header">
            <h6 class="card-title mb-0">
                <i class="material-icons mr-2">info</i>
                Allocation Summary
            </h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <h6 class="text-muted mb-3">Reference Type Distribution</h6>
                    @php
                        $materialRequests = $references->where('type', 'Material Request')->count();
                        $directDeliveries = $references->where('type', 'Direct Delivery')->count();
                        $materialTransfers = $references->where('type', 'Material Transfer')->count();
                    @endphp
                    <div class="mb-2">
                        <span class="badge badge-primary mr-2">Material Requests: {{ $materialRequests }}</span>
                    </div>
                    <div class="mb-2">
                        <span class="badge badge-success mr-2">Direct Deliveries: {{ $directDeliveries }}</span>
                    </div>
                    <div class="mb-2">
                        <span class="badge badge-info mr-2">Material Transfers: {{ $materialTransfers }}</span>
                    </div>
                </div>
                <div class="col-md-6">
                    <h6 class="text-muted mb-3">Key Metrics</h6>
                    <div class="mb-2">
                        <strong>Total References:</strong> {{ $references->count() }}
                    </div>
                    <div class="mb-2">
                        <strong>Total Value:</strong> AED {{ number_format($totals['total_value'], 2) }}
                    </div>
                    <div class="mb-2">
                        <strong>Return Rate:</strong>
                        @if($totals['total_released'] > 0)
                            {{ number_format(($totals['total_returned'] / $totals['total_released']) * 100, 2) }}%
                        @else
                            0%
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>
@endsection

@push('scripts')
<script>
function exportAllocations() {
    alert('Export functionality will be implemented soon.');
}

function printAllocations() {
    window.print();
}
</script>
@endpush