@extends('layouts.admin-simple')

@section('title', 'Site Return Report')

@section('breadcrumb')
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.reports.index') }}">Reports</a></li>
    <li class="breadcrumb-item active">Site Return</li>
@endsection

@section('page-title')
    <div class="page-title-left">
        <h3 class="mb-1">Site Return Report</h3>
        <p class="text-muted mb-0" style="font-size: 13px;">Site returns and material return tracking</p>
    </div>
@endsection

@section('content')
    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <x-warehouse.stats-card
                title="Total Returns"
                :value="$returnItems->count()"
                icon="assignment_return"
                color="warning"
                subtitle="All returned items"
            />
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <x-warehouse.stats-card
                title="Total Quantity"
                :value="number_format($returnItems->sum('quantity'), 2)"
                icon="inventory_2"
                color="info"
                subtitle="Total quantity returned"
            />
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <x-warehouse.stats-card
                title="Total Value"
                :value="'AED ' . number_format($returnItems->sum('total_price'), 2)"
                icon="attach_money"
                color="danger"
                subtitle="Total value of returns"
            />
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <x-warehouse.stats-card
                title="Quality Passed"
                :value="$returnItems->where('quality_status', 'passed')->count()"
                icon="verified"
                color="success"
                subtitle="Items passed quality check"
            />
        </div>
    </div>

    <!-- Filters Panel -->
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">filter_list</i>
                Filters
            </h5>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('warehouse.reports.returns') }}">
                <div class="row">
                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Search</label>
                        <input type="text" name="search" value="{{ request('search') }}" class="form-control" placeholder="Item code, description, or return number">
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Project</label>
                        <select name="project_id" id="project_filter" class="form-control searchable-dropdown">
                            <option value="">All Projects</option>
                            @foreach($projects as $project)
                                <option value="{{ $project->id }}" {{ request('project_id') == $project->id ? 'selected' : '' }}>
                                    {{ $project->project_name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Division</label>
                        <select name="division_id" id="division_filter" class="form-control searchable-dropdown">
                            <option value="">All Divisions</option>
                            @foreach($divisions as $division)
                                <option value="{{ $division->id }}" {{ request('division_id') == $division->id ? 'selected' : '' }}>
                                    {{ $division->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Category</label>
                        <select name="category_id" id="category_filter" class="form-control searchable-dropdown">
                            <option value="">All Categories</option>
                            @foreach($categories as $category)
                                <option value="{{ $category->id }}" {{ request('category_id') == $category->id ? 'selected' : '' }}>
                                    {{ $category->category_name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Quality Status</label>
                        <select name="quality_status" id="quality_filter" class="form-control searchable-dropdown">
                            <option value="">All Quality Status</option>
                            @foreach($qualityStatuses as $status)
                                <option value="{{ $status }}" {{ request('quality_status') == $status ? 'selected' : '' }}>
                                    {{ ucfirst($status) }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Date From</label>
                        <input type="date" name="date_from" value="{{ request('date_from') }}" class="form-control">
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Date To</label>
                        <input type="date" name="date_to" value="{{ request('date_to') }}" class="form-control">
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3 d-flex align-items-end">
                        <div class="w-100">
                            <button type="submit" class="btn btn-primary btn-block">
                                <i class="material-icons mr-1" style="font-size: 16px;">search</i>
                                Apply Filters
                            </button>
                        </div>
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3 d-flex align-items-end">
                        <div class="w-100">
                            <a href="{{ route('warehouse.reports.returns') }}" class="btn btn-outline-secondary btn-block">
                                <i class="material-icons mr-1" style="font-size: 16px;">clear</i>
                                Clear Filters
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Site Return Report Table -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">assignment_return</i>
                Site Return Report ({{ $returnItems->count() }} items)
            </h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-sm table-hover mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th style="width: 18%;">Reference Details</th>
                            <th style="width: 20%;">Project & Division</th>
                            <th style="width: 12%;">Type of Goods</th>
                            <th style="width: 25%;">Item Details</th>
                            <th style="width: 10%;">Quantity & Unit</th>
                            <th style="width: 8%;">Unit Price</th>
                            <th style="width: 8%;">Total Price</th>
                            <th style="width: 6%;">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($returnItems as $item)
                            <tr>
                                <td>
                                    <div class="mb-1">
                                        <code class="font-weight-bold">{{ $item->reference_number }}</code>
                                    </div>
                                    <div>
                                        @if($item->reference_type == 'Material Request')
                                            <span class="badge badge-success badge-sm">{{ $item->reference_type }}</span>
                                        @elseif($item->reference_type == 'Direct Delivery')
                                            <span class="badge badge-info badge-sm">{{ $item->reference_type }}</span>
                                        @elseif($item->reference_type == 'Material Transfer')
                                            <span class="badge badge-warning badge-sm">{{ $item->reference_type }}</span>
                                        @else
                                            <span class="badge badge-secondary badge-sm">{{ $item->reference_type }}</span>
                                        @endif
                                    </div>
                                </td>
                                <td>
                                    <div class="font-weight-medium mb-1">{{ $item->project_name }}</div>
                                    <div>
                                        <span class="badge badge-outline-secondary badge-sm">{{ $item->division }}</span>
                                    </div>
                                </td>
                                <td>
                                    <span class="badge badge-outline-primary">{{ $item->type_of_goods }}</span>
                                </td>
                                <td>
                                    <div class="mb-1">
                                        <code class="item-code">{{ $item->item_code }}</code>
                                    </div>
                                    <div class="text-muted small">{{ $item->item_description }}</div>
                                </td>
                                <td>
                                    <div class="text-right font-weight-bold">{{ number_format($item->quantity, 2) }}</div>
                                    <div class="text-center text-muted small">{{ $item->unit }}</div>
                                </td>
                                <td class="text-right">
                                    <strong>AED {{ number_format($item->unit_price, 2) }}</strong>
                                </td>
                                <td class="text-right">
                                    <strong class="text-danger">AED {{ number_format($item->total_price, 2) }}</strong>
                                </td>
                                <td class="text-center">
                                    <a href="{{ route('warehouse.reports.returns.item-details', $item->id) }}" class="btn btn-sm btn-outline-primary" title="View detailed information">
                                        <i class="material-icons" style="font-size: 16px;">visibility</i>
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center py-4">
                                    <i class="material-icons text-muted mb-3" style="font-size: 48px;">assignment_return</i>
                                    <h5 class="text-muted">No Return Goods Found</h5>
                                    <p class="text-muted mb-0">No returns match your current filters.</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

@push('styles')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <style>
        .badge-outline-primary {
            color: #007bff;
            border: 1px solid #007bff;
            background-color: transparent;
        }

        .badge-outline-secondary {
            color: #6c757d;
            border: 1px solid #6c757d;
            background-color: transparent;
        }

        .badge-outline-info {
            color: #17a2b8;
            border: 1px solid #17a2b8;
            background-color: transparent;
        }

        .badge-outline-success {
            color: #28a745;
            border: 1px solid #28a745;
            background-color: transparent;
        }

        .badge-outline-warning {
            color: #ffc107;
            border: 1px solid #ffc107;
            background-color: transparent;
        }

        .badge-outline-danger {
            color: #dc3545;
            border: 1px solid #dc3545;
            background-color: transparent;
        }

        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
            font-size: 12px;
            white-space: nowrap;
        }

        .table td {
            vertical-align: middle;
            font-size: 13px;
        }

        .badge {
            font-size: 10px;
            padding: 3px 6px;
        }

        .small {
            font-size: 11px;
        }

        code {
            font-size: 12px;
            color: #6c757d;
            background-color: #f8f9fa;
            padding: 2px 6px;
            border-radius: 3px;
        }

        code.item-code {
            font-size: 11px;
            font-weight: bold;
        }

        .badge-sm {
            font-size: 9px;
            padding: 2px 5px;
        }

        .table td > div {
            line-height: 1.3;
        }

        .table td .mb-1 {
            margin-bottom: 3px !important;
        }

        /* Select2 customization */
        .select2-container--default .select2-selection--single {
            height: 38px;
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: 36px;
            color: #495057;
            padding-left: 12px;
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: 36px;
            right: 12px;
        }

        .select2-dropdown {
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
        }

        .select2-container {
            width: 100% !important;
        }

        .select2-dropdown .select2-search .select2-search__field {
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
        }

        /* Fix date picker visibility */
        input[type="date"]::-webkit-calendar-picker-indicator,
        input[type="date"]::-webkit-inner-spin-button {
            color: #000;
            opacity: 1;
        }

        input[type="date"] {
            color: #495057;
        }

        input[type="date"]::-webkit-datetime-edit {
            color: #495057;
        }

        input[type="date"]::-webkit-datetime-edit-text {
            color: #495057;
        }

        input[type="date"]::-webkit-datetime-edit-month-field {
            color: #495057;
        }

        input[type="date"]::-webkit-datetime-edit-day-field {
            color: #495057;
        }

        input[type="date"]::-webkit-datetime-edit-year-field {
            color: #495057;
        }
    </style>
@endpush

@push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            // Initialize Select2 for all searchable dropdowns
            $('.searchable-dropdown').select2({
                placeholder: function() {
                    return $(this).find('option:first').text();
                },
                allowClear: true,
                width: 'resolve'
            });
        });
    </script>
@endpush