@extends('layouts.admin-simple')

@section('title', 'Stock Details - ' . $project->project_name)

@section('breadcrumb')
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item">Reports</li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.reports.stock-on-project') }}">Stock on Project</a></li>
    <li class="breadcrumb-item active">{{ $project->project_name }}</li>
@endsection

@section('page-title')
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">{{ $project->project_name }} - Stock Details</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">
                Project: {{ $project->project_number ?: 'N/A' }} |
                Status: {{ ucfirst(str_replace('_', ' ', $project->status)) }}
            </p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <a href="{{ route('warehouse.reports.stock-on-project') }}" class="btn btn-sm btn-secondary mr-2">
                <i class="material-icons mr-1" style="font-size: 16px;">arrow_back</i>
                Back to Report
            </a>
            <button type="button" onclick="exportReport()" class="btn btn-sm btn-success mr-2" title="Export to Excel">
                <i class="material-icons mr-1" style="font-size: 16px;">file_download</i>
                Export
            </button>
            <button type="button" onclick="printReport()" class="btn btn-sm btn-info" title="Print Report">
                <i class="material-icons mr-1" style="font-size: 16px;">print</i>
                Print
            </button>
        </div>
    </div>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Project Summary -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="mr-3">
                            <i class="material-icons" style="font-size: 36px;">inventory_2</i>
                        </div>
                        <div>
                            <div class="h5 mb-0">{{ $totalItems }}</div>
                            <div class="small">Total Items</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="mr-3">
                            <i class="material-icons" style="font-size: 36px;">inventory</i>
                        </div>
                        <div>
                            <div class="h5 mb-0">{{ number_format($totalStock) }}</div>
                            <div class="small">Total Quantity</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="mr-3">
                            <i class="material-icons" style="font-size: 36px;">attach_money</i>
                        </div>
                        <div>
                            <div class="h5 mb-0">{{ number_format($totalValue, 2) }}</div>
                            <div class="small">Total Value (AED)</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="mr-3">
                            <i class="material-icons" style="font-size: 36px;">date_range</i>
                        </div>
                        <div>
                            <div class="h5 mb-0">{{ $project->created_at->format('M Y') }}</div>
                            <div class="small">Project Created</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters Card -->
    <div class="card mb-3">
        <div class="card-header">
            <h6 class="card-title mb-0">
                <i class="material-icons mr-2">filter_list</i>
                Filter Items
            </h6>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('warehouse.reports.stock-on-project.details', $project->id) }}" id="filterForm">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="search">Search Items</label>
                            <input type="text" name="search" id="search" class="form-control"
                                   placeholder="Item name, code or description..."
                                   value="{{ request('search') }}">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="category_id">Category</label>
                            <select name="category_id" id="category_id" class="form-control">
                                <option value="">All Categories</option>
                                @foreach($categories as $category)
                                    <option value="{{ $category->id }}" {{ request('category_id') == $category->id ? 'selected' : '' }}>
                                        {{ $category->category_name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="stock_status">Stock Status</label>
                            <select name="stock_status" id="stock_status" class="form-control">
                                <option value="">All Stock Levels</option>
                                <option value="low_stock" {{ request('stock_status') == 'low_stock' ? 'selected' : '' }}>Low Stock</option>
                                <option value="out_of_stock" {{ request('stock_status') == 'out_of_stock' ? 'selected' : '' }}>Out of Stock</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <button type="submit" class="btn btn-primary">
                            <i class="material-icons mr-1" style="font-size: 16px;">search</i>
                            Filter Items
                        </button>
                        <a href="{{ route('warehouse.reports.stock-on-project.details', $project->id) }}" class="btn btn-secondary ml-2">
                            <i class="material-icons mr-1" style="font-size: 16px;">clear</i>
                            Clear Filters
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Items Table -->
    <div class="card">
        <div class="card-header">
            <h6 class="card-title mb-0">
                <i class="material-icons mr-2">inventory</i>
                Stock Details - {{ $project->project_name }}
                @if($items->count() > 0)
                    <span class="badge badge-primary ml-2">{{ $items->count() }} Items</span>
                @endif
            </h6>
        </div>
        <div class="card-body">
            @if($items->count() > 0)
                <div class="table-responsive">
                    <table class="table table-striped dataTable">
                        <thead>
                            <tr>
                                <th>Item</th>
                                <th>Code</th>
                                <th>Category</th>
                                <th>Unit</th>
                                <th class="text-right">Current Stock</th>
                                <th class="text-right">Total Delivered</th>
                                <th class="text-right">Min Stock Level</th>
                                <th class="text-right">Unit Cost (AED)</th>
                                <th class="text-right">Total Value (AED)</th>
                                <th class="text-center">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($items as $item)
                                @php
                                    $currentStock = $item->project_stock ?? 0;
                                    $totalValue = $currentStock * ($item->effective_unit_price ?? $item->unit_cost);
                                    $isLowStock = $currentStock <= $item->min_stock_level;
                                    $isOutOfStock = $currentStock == 0;
                                @endphp
                                <tr class="{{ $isOutOfStock ? 'table-danger' : ($isLowStock ? 'table-warning' : '') }}">
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <i class="material-icons mr-2 text-primary" style="font-size: 20px;">inventory_2</i>
                                            <div>
                                                <div class="font-weight-semibold">{{ $item->item_description }}</div>
                                                <small class="text-muted">{{ $item->item_code }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge badge-light" style="font-size: 12px; padding: 4px 8px;">{{ $item->item_code }}</span>
                                    </td>
                                    <td>{{ $item->category->category_name ?? 'N/A' }}</td>
                                    <td>{{ $item->unit_of_measure }}</td>
                                    <td class="text-right">
                                        <span class="font-weight-semibold {{ $isOutOfStock ? 'text-danger' : ($isLowStock ? 'text-warning' : 'text-success') }}">
                                            {{ number_format($currentStock) }}
                                        </span>
                                    </td>
                                    <td class="text-right">
                                        <span class="badge badge-primary">{{ number_format($item->total_delivered ?? 0) }}</span>
                                    </td>
                                    <td class="text-right">
                                        <span class="text-muted">{{ number_format($item->min_stock_level) }}</span>
                                    </td>
                                    <td class="text-right">
                                        <span class="font-weight-semibold">{{ number_format($item->effective_unit_price ?? $item->unit_cost, 2) }}</span>
                                    </td>
                                    <td class="text-right">
                                        <span class="font-weight-semibold text-success">
                                            {{ number_format($totalValue, 2) }}
                                        </span>
                                    </td>
                                    <td class="text-center">
                                        <a href="{{ route('warehouse.reports.item-reference-allocations', [$project->id, $item->id]) }}"
                                           class="btn btn-sm btn-info"
                                           title="View Reference Allocations">
                                            <i class="material-icons" style="font-size: 18px;">visibility</i>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr class="table-info">
                                <th colspan="4"><strong>Total</strong></th>
                                <th class="text-right">
                                    <strong>{{ number_format($totalStock) }}</strong>
                                </th>
                                <th class="text-right">
                                    <strong class="text-primary">{{ number_format($items->sum('total_delivered')) }}</strong>
                                </th>
                                <th></th>
                                <th></th>
                                <th class="text-right">
                                    <strong class="text-success">{{ number_format($totalValue, 2) }}</strong>
                                </th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            @else
                <div class="text-center py-5">
                    <i class="material-icons text-muted mb-3" style="font-size: 48px;">inventory</i>
                    <h5 class="text-muted mb-2">No Items Found</h5>
                    <p class="text-muted">
                        No items match your current filter criteria for this project.<br>
                        Try adjusting your filters or check if items have been assigned to this project.
                    </p>
                </div>
            @endif
        </div>
    </div>

    @if($items->count() > 0)
    <!-- Stock Status Summary -->
    <div class="card mt-4">
        <div class="card-header">
            <h6 class="card-title mb-0">
                <i class="material-icons mr-2">analytics</i>
                Stock Status Summary
            </h6>
        </div>
        <div class="card-body">
            @php
                $inStockCount = $items->filter(function($item) {
                    $stock = $item->project_stock ?? 0;
                    return $stock > $item->min_stock_level;
                })->count();

                $lowStockCount = $items->filter(function($item) {
                    $stock = $item->project_stock ?? 0;
                    return $stock > 0 && $stock <= $item->min_stock_level;
                })->count();

                $outOfStockCount = $items->filter(function($item) {
                    return ($item->project_stock ?? 0) == 0;
                })->count();
            @endphp

            <div class="row">
                <div class="col-md-4">
                    <div class="d-flex align-items-center mb-3">
                        <div class="badge badge-success mr-3" style="font-size: 14px; padding: 8px 12px;">
                            {{ $inStockCount }}
                        </div>
                        <div>
                            <div class="font-weight-semibold">Items in Stock</div>
                            <small class="text-muted">Above minimum stock level</small>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="d-flex align-items-center mb-3">
                        <div class="badge badge-warning mr-3" style="font-size: 14px; padding: 8px 12px;">
                            {{ $lowStockCount }}
                        </div>
                        <div>
                            <div class="font-weight-semibold">Low Stock Items</div>
                            <small class="text-muted">At or below minimum stock level</small>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="d-flex align-items-center mb-3">
                        <div class="badge badge-danger mr-3" style="font-size: 14px; padding: 8px 12px;">
                            {{ $outOfStockCount }}
                        </div>
                        <div>
                            <div class="font-weight-semibold">Out of Stock Items</div>
                            <small class="text-muted">No stock available</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>
@endsection

@push('scripts')
<script>
function exportReport() {
    alert('Export functionality will be implemented soon.');
}

function printReport() {
    window.print();
}
</script>
@endpush