@extends('layouts.admin-simple')

@section('title', 'Material Issue Report')

@section('breadcrumb')
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.reports.index') }}">Reports</a></li>
    <li class="breadcrumb-item active">Material Issue</li>
@endsection

@section('page-title')
    <div class="page-title-left">
        <h3 class="mb-1">Material Issue Report</h3>
        <p class="text-muted mb-0" style="font-size: 13px;">All material issue and dispatch history</p>
    </div>
@endsection

@section('content')
    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <x-warehouse.stats-card
                title="Total Material Issues"
                :value="$stats['total']"
                icon="receipt_long"
                color="primary"
                subtitle="All material issues"
            />
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <x-warehouse.stats-card
                title="Incoming Operations"
                :value="$stats['incoming']"
                icon="download"
                color="success"
                subtitle="Supply deliveries & returns"
            />
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <x-warehouse.stats-card
                title="Outgoing/DD"
                :value="$stats['outgoing'] + $stats['direct_deliveries']"
                icon="upload"
                color="info"
                subtitle="Outgoing & Direct Deliveries"
            />
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <x-warehouse.stats-card
                title="Transfers"
                :value="$stats['transfers']"
                icon="swap_horiz"
                color="warning"
                subtitle="Material transfers"
            />
        </div>
    </div>

    <!-- Filters Panel -->
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">filter_list</i>
                Filters
            </h5>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('warehouse.reports.transactions') }}">
                <div class="row">
                    <div class="col-xl-3 col-md-4 mb-3">
                        <label class="form-label">Search</label>
                        <input type="text" name="search" value="{{ request('search') }}" class="form-control" placeholder="Search material issues...">
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Issue Type</label>
                        <select name="type" id="type_filter" class="form-control searchable-dropdown">
                            <option value="">All Types</option>
                            <option value="supplier_delivery" {{ request('type') == 'supplier_delivery' ? 'selected' : '' }}>Supplier Delivery</option>
                            <option value="outgoing" {{ request('type') == 'outgoing' ? 'selected' : '' }}>Outgoing</option>
                            <option value="direct_delivery" {{ request('type') == 'direct_delivery' ? 'selected' : '' }}>Direct Delivery</option>
                            <option value="transfer" {{ request('type') == 'transfer' ? 'selected' : '' }}>Transfer</option>
                        </select>
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Date From</label>
                        <input type="date" name="date_from" value="{{ request('date_from') }}" class="form-control">
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Date To</label>
                        <input type="date" name="date_to" value="{{ request('date_to') }}" class="form-control">
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Status</label>
                        <select name="status" id="status_filter" class="form-control searchable-dropdown">
                            <option value="">All Status</option>
                            <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                            <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Completed</option>
                            <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                        </select>
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="material-icons mr-1" style="font-size: 16px;">search</i>
                            Search
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Material Issue List -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Material Issue History</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Issue ID</th>
                            <th>Date</th>
                            <th>Type</th>
                            <th>Reference</th>
                            <th>Entity</th>
                            <th>Project</th>
                            <th>Status</th>
                            <th>Created By</th>
                            <th width="100">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($transactions as $transaction)
                            <tr>
                                <td>{{ $transaction['id'] }}</td>
                                <td>{{ \Carbon\Carbon::parse($transaction['date'])->format('d-M-Y') }}</td>
                                <td>
                                    <span class="badge badge-{{ $transaction['type_badge'] }}">
                                        {{ $transaction['type'] }}
                                    </span>
                                </td>
                                <td>{{ $transaction['reference'] ?: '-' }}</td>
                                <td>{{ $transaction['entity'] }}</td>
                                <td>{{ $transaction['project'] }}</td>
                                <td>
                                    <span class="badge badge-{{ $transaction['status_badge'] }}">
                                        {{ $transaction['status'] }}
                                    </span>
                                </td>
                                <td>{{ $transaction['created_by'] }}</td>
                                <td>
                                    @if($transaction['model'] == 'incoming')
                                        <a href="{{ route('warehouse.incoming-operations.show', $transaction['model_id']) }}"
                                           class="btn btn-sm btn-info" title="View Details">
                                            <i class="material-icons" style="font-size: 16px;">visibility</i>
                                        </a>
                                    @elseif($transaction['model'] == 'outgoing')
                                        <a href="{{ route('warehouse.outgoing.show', $transaction['model_id']) }}"
                                           class="btn btn-sm btn-info" title="View Details">
                                            <i class="material-icons" style="font-size: 16px;">visibility</i>
                                        </a>
                                    @elseif($transaction['model'] == 'direct_delivery')
                                        <a href="{{ route('warehouse.direct-deliveries.show', $transaction['model_id']) }}"
                                           class="btn btn-sm btn-info" title="View Details">
                                            <i class="material-icons" style="font-size: 16px;">visibility</i>
                                        </a>
                                    @elseif($transaction['model'] == 'transfer')
                                        <a href="{{ route('warehouse.transfer-requests.show', $transaction['model_id']) }}"
                                           class="btn btn-sm btn-info" title="View Details">
                                            <i class="material-icons" style="font-size: 16px;">visibility</i>
                                        </a>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="9" class="text-center">
                                    <p class="text-muted my-3">No material issues found</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Pagination Links -->
            @if($transactions->hasPages())
                <div class="card-footer">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            Showing {{ $transactions->firstItem() }} to {{ $transactions->lastItem() }} of {{ $transactions->total() }} results
                        </div>
                        <div>
                            {{ $transactions->links('pagination::bootstrap-4') }}
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
@endsection

@push('styles')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <style>
        /* Select2 customization */
        .select2-container--default .select2-selection--single {
            height: 38px;
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: 36px;
            color: #495057;
            padding-left: 12px;
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: 36px;
            right: 12px;
        }

        .select2-dropdown {
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
        }

        .select2-container {
            width: 100% !important;
        }

        .select2-dropdown .select2-search .select2-search__field {
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
        }

        /* Fix date picker visibility */
        input[type="date"]::-webkit-calendar-picker-indicator,
        input[type="date"]::-webkit-inner-spin-button {
            color: #000;
            opacity: 1;
        }

        input[type="date"] {
            color: #495057;
        }

        input[type="date"]::-webkit-datetime-edit {
            color: #495057;
        }

        input[type="date"]::-webkit-datetime-edit-text {
            color: #495057;
        }

        input[type="date"]::-webkit-datetime-edit-month-field {
            color: #495057;
        }

        input[type="date"]::-webkit-datetime-edit-day-field {
            color: #495057;
        }

        input[type="date"]::-webkit-datetime-edit-year-field {
            color: #495057;
        }

        /* Fix search button layout */
        .btn {
            white-space: nowrap;
            display: inline-flex;
            align-items: center;
            justify-content: center;
        }

        .btn .material-icons {
            display: inline-block;
        }
    </style>
@endpush

@push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            // Initialize Select2 for all searchable dropdowns
            $('.searchable-dropdown').select2({
                placeholder: function() {
                    return $(this).find('option:first').text();
                },
                allowClear: true,
                width: 'resolve'
            });
        });
    </script>
@endpush