@extends('layouts.admin-simple')

@section('title', 'Material Request Returns')

@section('breadcrumb')
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.site-return.index') }}">Site Return</a></li>
    <li class="breadcrumb-item active">MR Returns</li>
@endsection

@section('page-title')
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">Material Request Returns</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">All returns for {{ $materialRequest->material_request_number ?: 'MR-' . str_pad($materialRequest->id, 6, '0', STR_PAD_LEFT) }}</p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <a href="{{ route('warehouse.site-return.index') }}" class="btn btn-sm btn-outline-secondary mr-2">
                <i class="material-icons mr-1" style="font-size: 16px;">arrow_back</i>
                Back to Site Returns
            </a>
            <button type="button" onclick="printAllReturns()" class="btn btn-sm btn-info">
                <i class="material-icons mr-1" style="font-size: 16px;">print</i>
                Print All Returns
            </button>
        </div>
    </div>
@endsection

@section('content')
    <!-- Material Request Summary -->
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">assignment</i>
                Material Request Details
            </h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>MR Number:</strong></td>
                            <td>{{ $materialRequest->material_request_number ?: 'MR-' . str_pad($materialRequest->id, 6, '0', STR_PAD_LEFT) }}</td>
                        </tr>
                        <tr>
                            <td><strong>Project:</strong></td>
                            <td>{{ $materialRequest->project->project_name ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Division:</strong></td>
                            <td>{{ $materialRequest->division->division_name ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Requested By:</strong></td>
                            <td>{{ $materialRequest->requester->name ?? 'N/A' }}</td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Total Returns:</strong></td>
                            <td><span class="badge badge-primary">{{ $summary['total_returns'] }} returns</span></td>
                        </tr>
                        <tr>
                            <td><strong>Items Returned:</strong></td>
                            <td>{{ number_format($summary['total_items_returned'], 2) }} units</td>
                        </tr>
                        <tr>
                            <td><strong>Pending Total:</strong></td>
                            <td><strong>{{ number_format($summary['pending_quantity'], 2) }} units</strong></td>
                        </tr>
                        <tr>
                            <td><strong>Return Status:</strong></td>
                            <td>
                                <span class="badge badge-{{
                                    $summary['completion_status'] === 'fully_returned' ? 'success' :
                                    ($summary['completion_status'] === 'partially_returned' ? 'warning' : 'danger')
                                }}">
                                    {{ ucfirst(str_replace('_', ' ', $summary['completion_status'])) }}
                                </span>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Returns List -->
    <div class="card">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">assignment_return</i>
                All Returns ({{ $returns->count() }})
            </h6>
        </div>
        <div class="card-body">
            @if($returns->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Return Operation</th>
                                <th>Return Date</th>
                                <th>Status</th>
                                <th>Items Count</th>
                                <th>Quantities</th>
                                <th>Received By</th>
                                <th class="text-right">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($returns as $return)
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="mr-3">
                                                <div class="bg-warning text-white d-flex align-items-center justify-content-center rounded-circle" style="width: 40px; height: 40px;">
                                                    <i class="material-icons" style="font-size: 18px;">assignment_return</i>
                                                </div>
                                            </div>
                                            <div>
                                                <div class="font-weight-medium">{{ $return->operation_number }}</div>
                                                <small class="text-muted">{{ $return->delivery_note_number ?? 'N/A' }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>{{ $return->operation_date->format('d M, Y') }}</td>
                                    <td>
                                        <span class="badge badge-{{
                                            $return->status === 'completed' ? 'success' :
                                            ($return->status === 'processed' ? 'info' :
                                            ($return->status === 'pending_processing' ? 'warning' : 'secondary'))
                                        }}">
                                            {{ ucfirst(str_replace('_', ' ', $return->status)) }}
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge badge-outline-primary">{{ $return->items->count() }} items</span>
                                    </td>
                                    <td>
                                        <strong>{{ number_format($return->items->sum('quantity_delivered'), 2) }} units returned</strong>
                                    </td>
                                    <td>{{ $return->received_by_name ?? 'N/A' }}</td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('warehouse.incoming-operations.show', $return->id) }}" class="btn btn-sm btn-outline-primary" title="View Details">
                                                <i class="material-icons" style="font-size: 16px;">visibility</i>
                                            </a>
                                            <button onclick="printReturn({{ $return->id }})" class="btn btn-sm btn-outline-info" title="Print Return">
                                                <i class="material-icons" style="font-size: 16px;">print</i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Items Breakdown -->
                <div class="mt-4">
                    <h6>Items Breakdown</h6>
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead class="bg-light">
                                <tr>
                                    <th>Item</th>
                                    <th>Total Issued</th>
                                    <th>Total Returned</th>
                                    <th>Pending</th>
                                    <th>Return Operations</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $itemsBreakdown = [];

                                    // First, get issued quantities from material request
                                    foreach($materialRequest->items as $outgoingItem) {
                                        $key = $outgoingItem->item_id;
                                        $itemsBreakdown[$key] = [
                                            'item' => $outgoingItem->item,
                                            'total_issued' => $outgoingItem->quantity_released,
                                            'total_returned' => 0,
                                            'operations' => []
                                        ];
                                    }

                                    // Then, calculate returned quantities from all return operations
                                    foreach($returns as $return) {
                                        foreach($return->items as $item) {
                                            $key = $item->item_id;
                                            if (isset($itemsBreakdown[$key])) {
                                                $itemsBreakdown[$key]['total_returned'] += $item->quantity_delivered;
                                                $itemsBreakdown[$key]['operations'][] = [
                                                    'operation' => $return->operation_number,
                                                    'quantity' => $item->quantity_delivered,
                                                    'date' => $return->operation_date
                                                ];
                                            }
                                        }
                                    }
                                @endphp
                                @foreach($itemsBreakdown as $breakdown)
                                    <tr>
                                        <td>
                                            <strong>{{ $breakdown['item']->item_description }}</strong><br>
                                            <small class="text-muted">{{ $breakdown['item']->item_code }}</small>
                                        </td>
                                        <td>
                                            <strong>{{ number_format($breakdown['total_issued'], 2) }}</strong> {{ $breakdown['item']->unit_of_measure }}
                                        </td>
                                        <td>
                                            <strong>{{ number_format($breakdown['total_returned'], 2) }}</strong> {{ $breakdown['item']->unit_of_measure }}
                                        </td>
                                        <td>
                                            @php $pending = $breakdown['total_issued'] - $breakdown['total_returned']; @endphp
                                            <strong class="{{ $pending > 0 ? 'text-warning' : 'text-success' }}">
                                                {{ number_format($pending, 2) }}
                                            </strong> {{ $breakdown['item']->unit_of_measure }}
                                        </td>
                                        <td>
                                            @foreach($breakdown['operations'] as $operation)
                                                <span class="badge badge-secondary mr-1 mb-1">
                                                    {{ $operation['operation'] }}: {{ number_format($operation['quantity'], 2) }}
                                                </span>
                                            @endforeach
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            @else
                <div class="text-center py-4">
                    <i class="material-icons text-muted mb-3" style="font-size: 48px;">assignment_return</i>
                    <h5 class="text-muted">No Returns Found</h5>
                    <p class="text-muted mb-4">No returns have been made against this material request yet.</p>
                    <a href="{{ route('warehouse.site-return.create') }}" class="btn btn-primary">
                        <i class="material-icons mr-1">add</i>
                        Create First Return
                    </a>
                </div>
            @endif
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        function printReturn(returnId) {
            window.open(`{{ url('warehouse/incoming-operations') }}/${returnId}/print`, '_blank');
        }

        function printAllReturns() {
            alert('Print all returns functionality will be implemented');
        }
    </script>
@endpush

@push('styles')
    <style>
        .table-borderless td {
            border: none;
            padding: 0.25rem 0.5rem;
        }

        .badge {
            font-size: 11px;
            padding: 4px 8px;
        }

        .badge-outline-primary {
            color: #007bff;
            border: 1px solid #007bff;
            background-color: transparent;
        }
    </style>
@endpush