<?php $__env->startSection('title', $category->category_name); ?>
<?php $__env->startSection('page-title', $category->category_name); ?>
<?php $__env->startSection('page-subtitle', 'Item Category Details'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('warehouse.item-categories.index')); ?>">Item Categories</a></li>
    <li class="breadcrumb-item active"><?php echo e($category->category_name); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-actions'); ?>
    <div class="d-flex">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.item-categories.edit')): ?>
        <a href="<?php echo e(route('warehouse.item-categories.edit', $category)); ?>" class="btn btn-primary btn-sm">
            <i class="material-icons mr-1" style="font-size: 16px;">edit</i>
            Edit Category
        </a>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Category Information -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Category Information</h6>
        </div>

        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <h6 class="text-primary font-weight-bold mb-3">Basic Information</h6>
                    <dl class="row">
                        <dt class="col-sm-4 text-muted">Category Name</dt>
                        <dd class="col-sm-8"><?php echo e($category->category_name); ?></dd>

                        <dt class="col-sm-4 text-muted">Category Code</dt>
                        <dd class="col-sm-8">
                            <?php if($category->category_code): ?>
                                <code class="category-code-display"><?php echo e($category->category_code); ?></code>
                            <?php else: ?>
                                <span class="text-muted font-italic">Not assigned</span>
                            <?php endif; ?>
                        </dd>

                        <dt class="col-sm-4 text-muted">Type of Goods</dt>
                        <dd class="col-sm-8"><?php echo e($category->type_of_goods ?: 'Not specified'); ?></dd>

                        <dt class="col-sm-4 text-muted">Status</dt>
                        <dd class="col-sm-8">
                            <?php if($category->status === 'active'): ?>
                                <span class="badge badge-success">Active</span>
                            <?php else: ?>
                                <span class="badge badge-secondary">Inactive</span>
                            <?php endif; ?>
                        </dd>

                        <dt class="col-sm-4 text-muted">Created Date</dt>
                        <dd class="col-sm-8"><?php echo e($category->created_at->format('M d, Y H:i')); ?></dd>

                        <dt class="col-sm-4 text-muted">Last Updated</dt>
                        <dd class="col-sm-8"><?php echo e($category->updated_at->format('M d, Y H:i')); ?></dd>
                    </dl>
                </div>

                <div class="col-md-6">
                    <h6 class="text-primary font-weight-bold mb-3">Statistics</h6>
                    <dl class="row">
                        <dt class="col-sm-4 text-muted">Total Items</dt>
                        <dd class="col-sm-8">
                            <?php
                                $itemCount = $category->items()->count();
                            ?>
                            <span class="badge badge-info"><?php echo e($itemCount); ?></span>
                        </dd>

                        <dt class="col-sm-4 text-muted">Active Items</dt>
                        <dd class="col-sm-8">
                            <?php
                                $activeItemCount = $category->items()->where('status', 'active')->count();
                            ?>
                            <span class="badge badge-success"><?php echo e($activeItemCount); ?></span>
                        </dd>

                    </dl>

                    <?php if($category->description): ?>
                        <h6 class="text-primary font-weight-bold mb-3 mt-4">Description</h6>
                        <p class="text-muted"><?php echo e($category->description); ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <?php if($category->items()->count() > 0): ?>
    <!-- Items in this Category -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold text-primary">Items in this Category</h6>
            <a href="<?php echo e(route('warehouse.items.index', ['category_id' => $category->id])); ?>" class="btn btn-sm btn-outline-primary">
                View All Items
            </a>
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Item Code</th>
                            <th>Item Name</th>
                            <th>Unit</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $category->items()->limit(10)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($item->item_code); ?></td>
                            <td><?php echo e($item->item_description); ?></td>
                            <td><?php echo e($item->unit_of_measure); ?></td>
                            <td>
                                <?php if($item->status === 'active'): ?>
                                    <span class="badge badge-success">Active</span>
                                <?php else: ?>
                                    <span class="badge badge-secondary"><?php echo e(ucfirst($item->status)); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="<?php echo e(route('warehouse.items.show', $item->id)); ?>" class="btn btn-sm btn-info">
                                    <i class="material-icons" style="font-size: 14px;">visibility</i>
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <?php if($category->items()->count() > 10): ?>
                <div class="text-center mt-3">
                    <p class="text-muted">Showing first 10 items. <a href="<?php echo e(route('warehouse.items.index', ['category_id' => $category->id])); ?>">View all <?php echo e($category->items()->count()); ?> items</a></p>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <style>
        .category-code-display {
            font-size: 12px;
            font-weight: bold;
            color: #007bff;
            background-color: #e3f2fd;
            padding: 4px 8px;
            border-radius: 4px;
            text-transform: uppercase;
            font-family: 'Courier New', monospace;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/item-categories/show.blade.php ENDPATH**/ ?>