<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Material Delivery Note - <?php echo e($materialIssued['issue_number']); ?></title>
    <style>
        @media print {
            body { margin: 0; }
            .no-print { display: none; }
            .page-break { page-break-after: always; }
        }

        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #000;
            margin: 20px;
            max-width: 800px;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
        }

        .company-name {
            font-size: 16px;
            font-weight: bold;
            margin-bottom: 2px;
            text-transform: uppercase;
        }

        .company-address {
            font-size: 10px;
            margin-bottom: 1px;
        }

        .document-title {
            font-size: 14px;
            font-weight: bold;
            margin: 30px 0 20px 0;
            text-transform: uppercase;
            text-align: center;
        }

        .info-section {
            margin-bottom: 20px;
        }

        .info-row {
            margin-bottom: 8px;
            font-size: 12px;
        }

        .info-row-flex {
            display: flex;
            justify-content: space-between;
            align-items: center;
            width: 100%;
        }

        .mr-number {
            text-align: right;
            width: 100%;
            margin-bottom: 10px;
        }

        .to-date-row {
            display: flex;
            justify-content: space-between;
            width: 100%;
        }

        .job-row {
            text-align: left;
            margin-top: 5px;
        }

        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            font-size: 11px;
        }

        .items-table th,
        .items-table td {
            border: 1px solid #000;
            padding: 5px 8px;
            text-align: left;
            height: 25px;
        }

        .items-table th {
            font-weight: bold;
        }

        .items-table td.text-center {
            text-align: center;
        }

        .items-table td.text-right {
            text-align: right;
        }

        .empty-rows td {
            border-left: 1px solid #000;
            border-right: 1px solid #000;
            height: 25px;
        }

        .signatures-section {
            margin-top: 40px;
            display: flex;
            justify-content: space-between;
            font-size: 12px;
            font-weight: bold;
        }

        .signature-box {
            text-align: center;
            width: 30%;
        }

        .print-btn {
            background-color: #007bff;
            color: white;
            border: none;
            padding: 10px 20px;
            cursor: pointer;
            border-radius: 4px;
            margin-bottom: 20px;
        }

        .print-btn:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <div class="no-print">
        <button onclick="window.print()" class="print-btn">🖨️ Print</button>
        <button onclick="window.close()" class="print-btn" style="background-color: #6c757d;">✕ Close</button>
    </div>

    <!-- Header -->
    <div class="header">
        <div class="company-name">ISAM KABBANI & PARTNERS FOR CONSTRUCTION & MAINT. CO. ( L.L.C )</div>
        <div class="company-address">Dubai: Dubai Investment Park, Jebel Ali Tel# 04 884 1522; Fax# 04 884 1523</div>
        <div class="company-address">E-mail : dubai@kcgemirates.ae; abudhabi@kcgemirates.ae   Website : www.ikkgroup.com</div>
    </div>

    <!-- Document Title -->
    <div class="document-title">MATERIAL DELIVERY NOTE</div>

    <!-- Info Section -->
    <div class="info-section">
        <div class="info-row mr-number">
            MR#: <?php echo e($materialIssued['issue_number']); ?>

        </div>
        <div class="info-row to-date-row">
            <span>TO: <?php echo e($materialIssued['issued_to']); ?></span>
            <span>DATE: <?php echo e($materialIssued['issue_date']); ?></span>
        </div>
        <div class="info-row job-row">
            Job # <?php echo e($materialIssued['project']); ?>

        </div>
    </div>

    <!-- Items Table -->
    <table class="items-table">
        <thead>
            <tr>
                <th style="width: 10%;">Sr. No.</th>
                <th style="width: 50%;">Description</th>
                <th style="width: 10%;">Unit</th>
                <th style="width: 10%;">Qty.</th>
                <th style="width: 20%;">Remarks</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $materialIssued['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td class="text-center"><?php echo e($index + 1); ?></td>
                <td><?php echo e($item['description']); ?></td>
                <td class="text-center"><?php echo e(strtoupper($item['unit'] ?: 'PCS')); ?></td>
                
                <td class="text-center"><?php echo e(number_format($item['quantity_released'] > 0 ? $item['quantity_released'] : $item['quantity_requested'], 0)); ?></td>
                <td></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <?php
                $remainingRows = 15 - count($materialIssued['items']);
            ?>

            <?php for($i = 0; $i < $remainingRows; $i++): ?>
            <tr class="empty-rows">
                <td>&nbsp;</td>
                <td>&nbsp;</td>
                <td>&nbsp;</td>
                <td>&nbsp;</td>
                <td>&nbsp;</td>
            </tr>
            <?php endfor; ?>
        </tbody>
    </table>

    <!-- Signatures Section -->
    <div class="signatures-section">
        <div class="signature-box">Store Keeper</div>
        <div class="signature-box">Site In Charge</div>
        <div class="signature-box">Received By (Sign & Date)</div>
    </div>

    <script>
        // Auto-print when page loads (with small delay)
        window.addEventListener('load', function() {
            setTimeout(() => {
                // Only auto-print if this window was opened programmatically
                if (window.opener) {
                    window.print();
                }
            }, 500);
        });

        // Close window after printing
        window.addEventListener('afterprint', function() {
            if (window.opener) {
                window.close();
            }
        });
    </script>
</body>
</html><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/inventory/material-issued/print.blade.php ENDPATH**/ ?>