<?php $__env->startSection('title', 'Stock on Project Report'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item">Reports</li>
    <li class="breadcrumb-item active">Stock on Project</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title-left">
        <h3 class="mb-1">Stock on Project Report</h3>
        <p class="text-muted mb-0" style="font-size: 13px;">View stock levels and inventory distribution across projects</p>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Filters Card -->
    <div class="card mb-3">
        <div class="card-header">
            <h6 class="card-title mb-0">
                <i class="material-icons mr-2">filter_list</i>
                Report Filters
            </h6>
        </div>
        <div class="card-body">
            <form method="GET" action="<?php echo e(route('warehouse.reports.stock-on-project')); ?>" id="filterForm">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="project_id">Project</label>
                            <select name="project_id" id="project_id" class="form-control searchable-dropdown">
                                <option value="">All Projects</option>
                                <?php $__currentLoopData = $allProjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($project->id); ?>" <?php echo e(request('project_id') == $project->id ? 'selected' : ''); ?>>
                                        <?php echo e($project->project_name); ?> <?php if($project->project_number): ?> (<?php echo e($project->project_number); ?>) <?php endif; ?>
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="project_status">Project Status</label>
                            <select name="project_status" id="project_status" class="form-control searchable-dropdown">
                                <option value="">All Statuses</option>
                                <?php $__currentLoopData = $projectStatuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($status); ?>" <?php echo e(request('project_status') == $status ? 'selected' : ''); ?>>
                                        <?php echo e(ucfirst(str_replace('_', ' ', $status))); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="date_from">From Date</label>
                            <input type="date" name="date_from" id="date_from" class="form-control"
                                   value="<?php echo e(request('date_from')); ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="date_to">To Date</label>
                            <input type="date" name="date_to" id="date_to" class="form-control"
                                   value="<?php echo e(request('date_to')); ?>">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <button type="submit" class="btn btn-primary">
                            <i class="material-icons mr-1" style="font-size: 16px;">search</i>
                            Generate Report
                        </button>
                        <a href="<?php echo e(route('warehouse.reports.stock-on-project')); ?>" class="btn btn-secondary ml-2">
                            <i class="material-icons mr-1" style="font-size: 16px;">clear</i>
                            Clear Filters
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Report Content -->
    <div class="card">
        <div class="card-header">
            <h6 class="card-title mb-0">
                <i class="material-icons mr-2">business_center</i>
                Stock on Project Report
                <?php if($projects->count() > 0): ?>
                    <span class="badge badge-primary ml-2"><?php echo e($projects->count()); ?> Projects</span>
                <?php endif; ?>
            </h6>
        </div>
        <div class="card-body">
            <?php if($projects->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-striped dataTable">
                        <thead>
                            <tr>
                                <th>Project</th>
                                <th>Project Number</th>
                                <th>Status</th>
                                <th class="text-right">Total Items</th>
                                <th class="text-right">Total Stock Qty</th>
                                <th class="text-right">Total Value (AED)</th>
                                <th class="text-center">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <i class="material-icons mr-2" style="color: <?php echo e($project->status === 'active' ? '#28a745' : ($project->status === 'completed' ? '#007bff' : '#6c757d')); ?>; font-size: 20px;">work</i>
                                            <div>
                                                <div class="font-weight-semibold"><?php echo e($project->project_name); ?></div>
                                                <?php if($project->project_number): ?>
                                                    <small class="text-muted"><?php echo e($project->project_number); ?></small>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge badge-light"><?php echo e($project->project_number ?: 'N/A'); ?></span>
                                    </td>
                                    <td>
                                        <?php
                                            $statusColors = [
                                                'active' => 'success',
                                                'completed' => 'primary',
                                                'on_hold' => 'warning',
                                                'cancelled' => 'danger'
                                            ];
                                            $statusColor = $statusColors[$project->status] ?? 'secondary';
                                        ?>
                                        <span class="badge badge-<?php echo e($statusColor); ?>">
                                            <?php echo e(ucfirst(str_replace('_', ' ', $project->status))); ?>

                                        </span>
                                    </td>
                                    <td class="text-right">
                                        <span class="font-weight-semibold"><?php echo e(number_format($project->unique_items)); ?></span>
                                    </td>
                                    <td class="text-right">
                                        <span class="font-weight-semibold"><?php echo e(number_format($project->total_stock)); ?></span>
                                    </td>
                                    <td class="text-right">
                                        <span class="font-weight-semibold text-success">
                                            <?php echo e(number_format($project->total_value, 2)); ?>

                                        </span>
                                    </td>
                                    <td class="text-center">
                                        <a href="<?php echo e(route('warehouse.reports.stock-on-project.details', $project->id)); ?>"
                                           class="btn btn-sm btn-primary" title="View Detailed Stock Report">
                                            <i class="material-icons" style="font-size: 16px;">visibility</i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <tfoot>
                            <tr class="table-info">
                                <th colspan="3"><strong>Total</strong></th>
                                <th class="text-right">
                                    <strong><?php echo e(number_format($projects->sum('unique_items'))); ?></strong>
                                </th>
                                <th class="text-right">
                                    <strong><?php echo e(number_format($projects->sum('total_stock'))); ?></strong>
                                </th>
                                <th class="text-right">
                                    <strong class="text-success"><?php echo e(number_format($projects->sum('total_value'), 2)); ?></strong>
                                </th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            <?php else: ?>
                <div class="text-center py-5">
                    <i class="material-icons text-muted mb-3" style="font-size: 48px;">business_center</i>
                    <h5 class="text-muted mb-2">No Projects Found</h5>
                    <p class="text-muted">
                        No projects match your current filter criteria.<br>
                        Try adjusting your filters or check if projects have been created.
                    </p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <?php if($projects->count() > 0): ?>
    <!-- Summary Statistics -->
    <div class="row mt-4">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="mr-3">
                            <i class="material-icons" style="font-size: 36px;">work</i>
                        </div>
                        <div>
                            <div class="h5 mb-0"><?php echo e($projects->count()); ?></div>
                            <div class="small">Total Projects</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="mr-3">
                            <i class="material-icons" style="font-size: 36px;">inventory_2</i>
                        </div>
                        <div>
                            <div class="h5 mb-0"><?php echo e(number_format($projects->sum('unique_items'))); ?></div>
                            <div class="small">Unique Items</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="mr-3">
                            <i class="material-icons" style="font-size: 36px;">inventory</i>
                        </div>
                        <div>
                            <div class="h5 mb-0"><?php echo e(number_format($projects->sum('total_stock'))); ?></div>
                            <div class="small">Total Stock Quantity</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="mr-3">
                            <i class="material-icons" style="font-size: 36px;">attach_money</i>
                        </div>
                        <div>
                            <div class="h5 mb-0"><?php echo e(number_format($projects->sum('total_value'), 0)); ?></div>
                            <div class="small">Total Value (AED)</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <style>
        /* Select2 customization */
        .select2-container--default .select2-selection--single {
            height: 38px;
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: 36px;
            color: #495057;
            padding-left: 12px;
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: 36px;
            right: 12px;
        }

        .select2-dropdown {
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
        }

        .select2-container {
            width: 100% !important;
        }

        .select2-dropdown .select2-search .select2-search__field {
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
        }

        /* Fix date picker visibility */
        input[type="date"]::-webkit-calendar-picker-indicator,
        input[type="date"]::-webkit-inner-spin-button {
            color: #000;
            opacity: 1;
        }

        input[type="date"] {
            color: #495057;
        }

        input[type="date"]::-webkit-datetime-edit {
            color: #495057;
        }

        input[type="date"]::-webkit-datetime-edit-text {
            color: #495057;
        }

        input[type="date"]::-webkit-datetime-edit-month-field {
            color: #495057;
        }

        input[type="date"]::-webkit-datetime-edit-day-field {
            color: #495057;
        }

        input[type="date"]::-webkit-datetime-edit-year-field {
            color: #495057;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            // Initialize Select2 for all searchable dropdowns
            $('.searchable-dropdown').select2({
                placeholder: function() {
                    return $(this).find('option:first').text();
                },
                allowClear: true,
                width: 'resolve'
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/reports/stock-on-project.blade.php ENDPATH**/ ?>