<?php $__env->startSection('title', 'Incoming Item Details - ' . $itemDetails->item_code); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('warehouse.reports.index')); ?>">Reports</a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('warehouse.reports.incoming')); ?>">Incoming Materials</a></li>
    <li class="breadcrumb-item active"><?php echo e($itemDetails->item_code); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1"><?php echo e($itemDetails->item_code); ?> - Delivery Details</h3>
            <p class="text-muted mb-0" style="font-size: 13px;"><?php echo e($itemDetails->item_description); ?></p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <a href="<?php echo e(route('warehouse.reports.incoming')); ?>" class="btn btn-sm btn-outline-secondary mr-2">
                <i class="material-icons mr-1" style="font-size: 16px;">arrow_back</i>
                Back to Report
            </a>
            <button type="button" onclick="printItemDetails()" class="btn btn-sm btn-info">
                <i class="material-icons mr-1" style="font-size: 16px;">print</i>
                Print Details
            </button>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Operation Summary -->
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">local_shipping</i>
                Operation Information
            </h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Operation #:</strong></td>
                            <td><span class="badge badge-primary"><?php echo e($operationDetails->operation_number); ?></span></td>
                        </tr>
                        <tr>
                            <td><strong>Operation Type:</strong></td>
                            <td>
                                <span class="badge badge-outline-info"><?php echo e(ucfirst(str_replace('_', ' ', $operationDetails->operation_type))); ?></span>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Operation Date:</strong></td>
                            <td><?php echo e($operationDetails->operation_date ? $operationDetails->operation_date->format('d M, Y') : '-'); ?></td>
                        </tr>
                        <tr>
                            <td><strong>Status:</strong></td>
                            <td>
                                <span class="badge badge-<?php echo e($operationDetails->status === 'completed' ? 'success' :
                                    ($operationDetails->status === 'approved' ? 'info' :
                                    ($operationDetails->status === 'pending' ? 'warning' : 'secondary'))); ?>">
                                    <?php echo e(ucfirst(str_replace('_', ' ', $operationDetails->status))); ?>

                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>LPO Number:</strong></td>
                            <td><span class="badge badge-outline-primary"><?php echo e($operationDetails->lpo_number ?: 'N/A'); ?></span></td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Supplier:</strong></td>
                            <td>
                                <div><?php echo e($operationDetails->supplier_name); ?></div>
                                <small class="text-muted">Code: <?php echo e($operationDetails->supplier_code); ?></small>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Division:</strong></td>
                            <td><span class="badge badge-light"><?php echo e($operationDetails->division); ?></span></td>
                        </tr>
                        <tr>
                            <td><strong>Delivery Note:</strong></td>
                            <td><?php echo e($operationDetails->delivery_note_number ?: '-'); ?></td>
                        </tr>
                        <tr>
                            <td><strong>Received By:</strong></td>
                            <td><?php echo e($operationDetails->received_by); ?></td>
                        </tr>
                        <tr>
                            <td><strong>Total Amount:</strong></td>
                            <td><strong>AED <?php echo e(number_format($operationDetails->total_amount, 2)); ?></strong></td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Item Details & Quantities -->
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">inventory_2</i>
                Item Details & Quantities
            </h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Item Code:</strong></td>
                            <td><code><?php echo e($itemDetails->item_code); ?></code></td>
                        </tr>
                        <tr>
                            <td><strong>Description:</strong></td>
                            <td><?php echo e($itemDetails->item_description); ?></td>
                        </tr>
                        <tr>
                            <td><strong>Category:</strong></td>
                            <td><span class="badge badge-outline-primary"><?php echo e($itemDetails->category_name); ?></span></td>
                        </tr>
                        <tr>
                            <td><strong>Unit of Measure:</strong></td>
                            <td><?php echo e($itemDetails->unit_of_measure); ?></td>
                        </tr>
                        <tr>
                            <td><strong>Manufacturer:</strong></td>
                            <td><?php echo e($itemDetails->manufacturer ?: '-'); ?></td>
                        </tr>
                        <tr>
                            <td><strong>Country of Origin:</strong></td>
                            <td><?php echo e($itemDetails->country_of_origin ?: '-'); ?></td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Quantity Ordered:</strong></td>
                            <td><span class="text-info"><?php echo e(number_format($itemDetails->quantity_ordered, 2)); ?> <?php echo e($itemDetails->unit_of_measure); ?></span></td>
                        </tr>
                        <tr>
                            <td><strong>Quantity Delivered:</strong></td>
                            <td><strong class="text-primary"><?php echo e(number_format($itemDetails->quantity_delivered, 2)); ?> <?php echo e($itemDetails->unit_of_measure); ?></strong></td>
                        </tr>
                        <tr>
                            <td><strong>Quantity Accepted:</strong></td>
                            <td><strong class="text-success"><?php echo e(number_format($itemDetails->quantity_accepted, 2)); ?> <?php echo e($itemDetails->unit_of_measure); ?></strong></td>
                        </tr>
                        <tr>
                            <td><strong>Quantity Rejected:</strong></td>
                            <td><strong class="text-danger"><?php echo e(number_format($itemDetails->quantity_rejected, 2)); ?> <?php echo e($itemDetails->unit_of_measure); ?></strong></td>
                        </tr>
                        <tr>
                            <td><strong>Unit Price:</strong></td>
                            <td>
                                <div><?php echo e($itemDetails->currency); ?> <?php echo e(number_format($itemDetails->unit_price, 2)); ?></div>
                                <small class="text-muted">AED <?php echo e(number_format($itemDetails->unit_price_aed, 2)); ?></small>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Total Price:</strong></td>
                            <td><strong>AED <?php echo e(number_format($itemDetails->total_price_aed, 2)); ?></strong></td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Quality & Batch Information -->
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">verified</i>
                Quality Control & Batch Information
            </h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Quality Status:</strong></td>
                            <td>
                                <span class="badge badge-<?php echo e($itemDetails->quality_status === 'passed' ? 'success' :
                                    ($itemDetails->quality_status === 'failed' ? 'danger' :
                                    ($itemDetails->quality_status === 'pending' ? 'warning' : 'info'))); ?>">
                                    <?php echo e(ucfirst($itemDetails->quality_status ?: 'Not inspected')); ?>

                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Acceptance Rate:</strong></td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="progress flex-grow-1 mr-2" style="height: 20px;">
                                        <div class="progress-bar bg-success" style="width: <?php echo e($itemDetails->acceptance_rate); ?>%">
                                            <?php echo e(round($itemDetails->acceptance_rate, 1)); ?>%
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Batch Number:</strong></td>
                            <td><code><?php echo e($itemDetails->batch_number ?: 'N/A'); ?></code></td>
                        </tr>
                        <tr>
                            <td><strong>Serial Number:</strong></td>
                            <td><code><?php echo e($itemDetails->serial_number ?: 'N/A'); ?></code></td>
                        </tr>
                        <tr>
                            <td><strong>Storage Location:</strong></td>
                            <td><?php echo e($itemDetails->storage_location ?: '-'); ?></td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Production Date:</strong></td>
                            <td><?php echo e($itemDetails->production_date ? $itemDetails->production_date->format('d M, Y') : '-'); ?></td>
                        </tr>
                        <tr>
                            <td><strong>Expiry Date:</strong></td>
                            <td>
                                <?php if($itemDetails->expiry_date): ?>
                                    <span class="<?php echo e($itemDetails->days_until_expiry !== null && $itemDetails->days_until_expiry < 0 ? 'text-danger' : ($itemDetails->days_until_expiry !== null && $itemDetails->days_until_expiry <= 30 ? 'text-warning' : 'text-success')); ?>">
                                        <?php echo e($itemDetails->expiry_date->format('d M, Y')); ?>

                                    </span>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Days to Expiry:</strong></td>
                            <td>
                                <?php if($itemDetails->days_until_expiry !== null): ?>
                                    <?php if($itemDetails->days_until_expiry < 0): ?>
                                        <span class="text-danger font-weight-bold">Expired (<?php echo e(abs($itemDetails->days_until_expiry)); ?> days ago)</span>
                                    <?php elseif($itemDetails->days_until_expiry <= 30): ?>
                                        <span class="text-warning font-weight-bold"><?php echo e($itemDetails->days_until_expiry); ?> days</span>
                                    <?php else: ?>
                                        <span class="text-success"><?php echo e($itemDetails->days_until_expiry); ?> days</span>
                                    <?php endif; ?>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Hazardous Material:</strong></td>
                            <td>
                                <?php if($itemDetails->hazardous_material): ?>
                                    <span class="badge badge-danger">Yes</span>
                                <?php else: ?>
                                    <span class="badge badge-success">No</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Warranty Period:</strong></td>
                            <td><?php echo e($itemDetails->warranty_period_months ? $itemDetails->warranty_period_months . ' months' : '-'); ?></td>
                        </tr>
                    </table>
                </div>
            </div>

            <?php if($itemDetails->quality_notes): ?>
                <div class="row mt-3">
                    <div class="col-12">
                        <strong>Quality Notes:</strong>
                        <div class="mt-1 p-2 bg-light rounded">
                            <?php echo e($itemDetails->quality_notes); ?>

                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if($itemDetails->rejection_reason): ?>
                <div class="row mt-3">
                    <div class="col-12">
                        <strong>Rejection Reason:</strong>
                        <div class="mt-1 p-2 bg-danger text-white rounded">
                            <?php echo e($itemDetails->rejection_reason); ?>

                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Inspection & Approval -->
    <div class="row">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="material-icons mr-2">fact_check</i>
                        Inspection Details
                    </h6>
                </div>
                <div class="card-body">
                    <div class="list-group list-group-flush">
                        <div class="list-group-item d-flex justify-content-between px-0">
                            <span>Inspector:</span>
                            <span><?php echo e($operationDetails->inspector); ?></span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between px-0">
                            <span>Inspection Date:</span>
                            <span><?php echo e($operationDetails->inspection_datetime ? $operationDetails->inspection_datetime->format('d M, Y H:i') : 'Not inspected'); ?></span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between px-0">
                            <span>Inspection Result:</span>
                            <span>
                                <?php if($operationDetails->inspection_result): ?>
                                    <span class="badge badge-<?php echo e($operationDetails->inspection_result === 'passed' ? 'success' :
                                        ($operationDetails->inspection_result === 'failed' ? 'danger' : 'warning')); ?>">
                                        <?php echo e(ucfirst($operationDetails->inspection_result)); ?>

                                    </span>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between px-0">
                            <span>Approved By:</span>
                            <span><?php echo e($operationDetails->approved_by); ?></span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between px-0">
                            <span>Approval Date:</span>
                            <span><?php echo e($operationDetails->approved_at ? $operationDetails->approved_at->format('d M, Y H:i') : 'Not approved'); ?></span>
                        </div>
                    </div>

                    <?php if($operationDetails->inspection_notes): ?>
                        <div class="mt-3">
                            <strong>Inspection Notes:</strong>
                            <div class="mt-1 p-2 bg-light rounded">
                                <?php echo e($operationDetails->inspection_notes); ?>

                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="material-icons mr-2">timeline</i>
                        Record Timeline
                    </h6>
                </div>
                <div class="card-body">
                    <div class="list-group list-group-flush">
                        <div class="list-group-item d-flex justify-content-between px-0">
                            <span>Created:</span>
                            <span><?php echo e($itemDetails->created_at ? $itemDetails->created_at->format('d M, Y H:i') : '-'); ?></span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between px-0">
                            <span>Last Updated:</span>
                            <span><?php echo e($itemDetails->updated_at ? $itemDetails->updated_at->format('d M, Y H:i') : '-'); ?></span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between px-0">
                            <span>Operation Created:</span>
                            <span><?php echo e($operationDetails->created_at ? $operationDetails->created_at->format('d M, Y H:i') : '-'); ?></span>
                        </div>
                    </div>

                    <div class="mt-3">
                        <small class="text-muted">
                            <strong>Item Record ID:</strong> <?php echo e($itemDetails->id); ?><br>
                            <strong>Operation ID:</strong> <?php echo e($operationDetails->id); ?>

                        </small>
                    </div>

                    <?php if($operationDetails->notes): ?>
                        <div class="mt-3">
                            <strong>Operation Notes:</strong>
                            <div class="mt-1 p-2 bg-light rounded">
                                <?php echo e($operationDetails->notes); ?>

                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <style>
        .table-borderless td {
            border: none;
            padding: 0.25rem 0.5rem;
        }

        .badge-outline-primary {
            color: #007bff;
            border: 1px solid #007bff;
            background-color: transparent;
        }

        .badge-outline-info {
            color: #17a2b8;
            border: 1px solid #17a2b8;
            background-color: transparent;
        }

        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
            font-size: 12px;
        }

        .table td {
            font-size: 13px;
            vertical-align: middle;
        }

        .list-group-item {
            border-left: none;
            border-right: none;
        }

        code {
            font-size: 12px;
            color: #6c757d;
            background-color: #f8f9fa;
            padding: 2px 6px;
            border-radius: 3px;
        }

        .progress {
            background-color: #e9ecef;
        }

        .progress-bar {
            font-size: 11px;
            line-height: 20px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        function printItemDetails() {
            window.print();
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/reports/incoming-details.blade.php ENDPATH**/ ?>