<?php $__env->startSection('title', 'New Site Return'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('warehouse.site-return.index')); ?>">Site Return</a></li>
    <li class="breadcrumb-item active">New Return</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">New Site Return</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">Create a new site return operation</p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <a href="<?php echo e(route('warehouse.site-return.index')); ?>" class="btn btn-sm btn-outline-secondary mr-2">
                <i class="material-icons mr-1" style="font-size: 16px;">arrow_back</i>
                Back to List
            </a>
            <button type="submit" form="returnForm" class="btn btn-sm btn-primary">
                <i class="material-icons mr-1" style="font-size: 16px;">save</i>
                Save Return
            </button>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <form id="returnForm" action="<?php echo e(route('warehouse.incoming-operations.store')); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="operation_type" value="site_return">
        <input type="hidden" name="currency" value="AED">
        <input type="hidden" name="exchange_rate" value="1.0000">

        <!-- Validation Errors -->
        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <h6><i class="material-icons align-middle mr-1">error</i> Please fix the following errors:</h6>
                <ul class="mb-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <!-- Basic Information Card -->
        <div class="card mb-3">
            <div class="card-header">
                <h6 class="card-title mb-0 d-flex align-items-center">
                    <i class="material-icons mr-2">info</i>
                    Basic Information
                </h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="operation_number">Return Number</label>
                            <input type="text" name="operation_number" id="operation_number"
                                   class="form-control <?php $__errorArgs = ['operation_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                   placeholder="Auto-generated if empty" value="<?php echo e(old('operation_number')); ?>">
                            <?php $__errorArgs = ['operation_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="operation_date">Return Date <span class="text-danger">*</span></label>
                            <input type="date" name="operation_date" id="operation_date"
                                   class="form-control <?php $__errorArgs = ['operation_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                   value="<?php echo e(old('operation_date', date('Y-m-d'))); ?>" required>
                            <?php $__errorArgs = ['operation_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div id="return-status-card" class="alert alert-secondary" style="display: none;">
                            <strong><i class="material-icons align-middle mr-1">assessment</i> Return Status</strong>
                            <div id="return-status-content" class="mt-2">
                                <span id="status-badge" class="badge badge-secondary">Select Material Request</span>
                                <div id="status-details" class="mt-2 text-muted small">
                                    Please select a material request to view return status
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="form-group">
                            <label for="project_id_select">Project <span class="text-danger">*</span></label>
                            <select name="project_id_select" id="project_id_select" class="form-control <?php $__errorArgs = ['project_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                <option value="">Select Project First</option>
                                <?php $__currentLoopData = $projects ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($project->id); ?>" <?php echo e(old('project_id') == $project->id ? 'selected' : ''); ?>>
                                        <?php echo e($project->project_name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['project_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <small class="form-text text-muted">Select the project to load its material requests</small>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="form-group">
                            <label for="reference_id">Reference (Material Request or Direct Delivery) <span class="text-danger">*</span></label>
                            <select name="reference_id" id="reference_id" class="form-control <?php $__errorArgs = ['reference_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" disabled>
                                <option value="">Select Project First</option>
                            </select>
                            <?php $__errorArgs = ['reference_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <small class="form-text text-muted">Material requests and direct deliveries will load after selecting a project (sorted by date, newest first)</small>
                        </div>

                        <!-- Hidden fields to maintain backend compatibility -->
                        <input type="hidden" name="material_request_id" id="material_request_id">
                        <input type="hidden" name="direct_delivery_id" id="direct_delivery_id">
                        <input type="hidden" name="material_transfer_id" id="material_transfer_id">
                        <input type="hidden" name="reference_type" id="reference_type">
                    </div>
                </div>

                <!-- Auto-populated fields from selected material request -->
                <div id="material_request_details" style="display: none;">
                    <div class="alert alert-info">
                        <strong><i class="material-icons align-middle mr-1">info</i> Material Request Details:</strong>
                        <div id="request_info" class="mt-2"></div>
                    </div>
                </div>

                <!-- Hidden fields for project and division (auto-filled from material request) -->
                <input type="hidden" name="project_id" id="project_id">
                <input type="hidden" name="division" id="division">
            </div>
        </div>


        <!-- Materials & Items Card -->
        <div class="card mb-3">
            <div class="card-header">
                <h6 class="card-title mb-0 d-flex align-items-center">
                    <i class="material-icons mr-2">inventory</i>
                    Return Materials & Items
                </h6>
                <small class="text-muted">Items will be loaded automatically when you select a material request above</small>
                <div class="alert alert-info mt-2 mb-0" style="padding: 8px 12px;">
                    <i class="material-icons align-middle mr-1" style="font-size: 16px;">info</i>
                    <strong>Note:</strong> Only items with return quantities > 0 will be processed. Items highlighted in green will be returned.
                </div>
            </div>
            <div class="card-body p-0">
                <div id="no-items-message" class="text-center py-5">
                    <i class="material-icons text-muted mb-2" style="font-size: 48px;">assignment</i>
                    <h5 class="text-muted">No Material Request Selected</h5>
                    <p class="text-muted">Please select a material request above to load the issued items for return.</p>
                </div>

                <div class="table-responsive" id="items-table-container" style="display: none;">
                    <table class="table table-sm mb-0" id="items-table">
                        <thead class="bg-light">
                            <tr>
                                <th style="width: 18%">Item Description</th>
                                <th style="width: 7%">Item Code</th>
                                <th style="width: 5%">Unit</th>
                                <th style="width: 7%">Qty Issued/Delivered</th>
                                <th style="width: 7%">Previously Returned</th>
                                <th style="width: 7%">Transferred to Projects</th>
                                <th style="width: 7%">Available to Return</th>
                                <th style="width: 7%">Qty to Return</th>
                                <th style="width: 7%">Condition</th>
                                <th style="width: 11%">Return Reason</th>
                                <th style="width: 12%">Notes</th>
                            </tr>
                        </thead>
                        <tbody id="items-tbody">
                            <!-- Item rows will be populated from material request -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Received By & Additional Information Card -->
        <div class="card mb-3">
            <div class="card-header">
                <h6 class="card-title mb-0 d-flex align-items-center">
                    <i class="material-icons mr-2">person</i>
                    Received By & Additional Information
                </h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="received_by">Received By</label>
                            <select name="received_by" id="received_by" class="form-control <?php $__errorArgs = ['received_by'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value="">Select User</option>
                                <?php $__currentLoopData = $users ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>" <?php echo e(old('received_by') == $user->id ? 'selected' : ''); ?>>
                                        <?php echo e($user->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['received_by'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="received_by_name">Received By Name</label>
                            <input type="text" name="received_by_name" id="received_by_name"
                                   class="form-control <?php $__errorArgs = ['received_by_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                   placeholder="Enter full name" value="<?php echo e(old('received_by_name', auth()->user()->name ?? '')); ?>">
                            <?php $__errorArgs = ['received_by_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label for="notes">Return Notes</label>
                    <textarea name="notes" id="notes" class="form-control <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                              rows="3" placeholder="Enter return notes, reasons, or additional comments"><?php echo e(old('notes')); ?></textarea>
                    <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-check">
                            <input type="checkbox" name="force_close_return" id="force_close_return"
                                   class="form-check-input" value="1" <?php echo e(old('force_close_return') ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="force_close_return">
                                <i class="material-icons text-warning mr-1" style="font-size: 18px;">warning</i>
                                Force Close Return
                            </label>
                            <small class="form-text text-muted">
                                Check this to forcefully close the return operation without normal approval workflow
                            </small>
                        </div>
                    </div>
                    <div class="col-md-6" id="force_close_reason_container" style="display: none;">
                        <div class="form-group">
                            <label for="force_close_reason">Reason for Force Close <span class="text-danger">*</span></label>
                            <textarea name="force_close_reason" id="force_close_reason" class="form-control <?php $__errorArgs = ['force_close_reason'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                      rows="3" placeholder="Please provide a reason for force closing this return..."><?php echo e(old('force_close_reason')); ?></textarea>
                            <?php $__errorArgs = ['force_close_reason'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Form Actions -->
        <div class="card">
            <div class="card-body text-center py-3">
                <button type="submit" class="btn btn-success mr-3">
                    <i class="material-icons mr-1" style="font-size: 16px;">assignment_return</i>
                    Return Items to Inventory
                </button>
                <a href="<?php echo e(route('warehouse.site-return.index')); ?>" class="btn btn-outline-secondary">
                    <i class="material-icons mr-1" style="font-size: 16px;">cancel</i>
                    Cancel
                </a>
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css">
    <style>
        .form-group label {
            font-weight: 600;
            color: #495057;
            font-size: 14px;
        }

        .card-title {
            font-size: 16px;
            font-weight: 600;
            color: #495057;
        }

        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
            background-color: #f8f9fa;
            font-size: 13px;
        }

        .table td {
            vertical-align: middle;
            font-size: 13px;
        }

        .btn-sm {
            padding: 6px 12px;
            font-size: 12px;
            line-height: 1.5;
        }

        .btn-sm .material-icons {
            font-size: 16px !important;
        }

        .form-control-sm {
            height: calc(1.5em + 0.5rem + 2px);
            padding: 0.25rem 0.5rem;
            font-size: 0.875rem;
        }

        .item-row {
            border-bottom: 1px solid #dee2e6;
        }

        .item-row:hover {
            background-color: #f8f9fa;
        }

        .select2-container .select2-selection--single {
            height: 38px;
            border: 1px solid #ced4da;
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: 36px;
        }

        .text-danger {
            color: #dc3545 !important;
        }

        .text-warning {
            color: #ffc107 !important;
        }

        .invalid-feedback {
            display: block;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        let itemRowCounter = 0;
        let availableItems = <?php echo json_encode($items ?? [], 15, 512) ?>;

        $(document).ready(function() {
            // Initialize Select2
            $('#project_id_select, #reference_id, #received_by').select2({
                placeholder: 'Please select...',
                allowClear: true
            });

            // Handle force close checkbox toggle
            $('#force_close_return').change(function() {
                if ($(this).is(':checked')) {
                    $('#force_close_reason_container').show();
                    $('#force_close_reason').prop('required', true);
                } else {
                    $('#force_close_reason_container').hide();
                    $('#force_close_reason').prop('required', false);
                    $('#force_close_reason').val(''); // Clear the value when unchecked
                }
            });

            // Handle project selection - load material requests and direct deliveries for the selected project
            $('#project_id_select').change(function() {
                const projectId = $(this).val();
                if (projectId) {
                    // Set the hidden project_id field as backup
                    $('#project_id').val(projectId);
                    loadCombinedReferencesForProject(projectId);
                } else {
                    // Clear the hidden project_id field
                    $('#project_id').val('');
                    clearProjectData();
                }
            });

            // Handle combined reference selection
            $('#reference_id').change(function() {
                const selectedValue = $(this).val();
                if (selectedValue) {
                    const [type, id] = selectedValue.split('_');

                    // Set the appropriate hidden fields
                    if (type === 'MR') {
                        $('#material_request_id').val(id);
                        $('#direct_delivery_id').val('');
                        $('#reference_type').val('material_request');
                        updateSelectionLabels('material_request');
                        loadMaterialRequestDetails(id);
                    } else if (type === 'DD') {
                        $('#direct_delivery_id').val(id);
                        $('#material_request_id').val('');
                        $('#reference_type').val('direct_delivery');
                        updateSelectionLabels('direct_delivery');
                        loadDirectDeliveryDetails(id);
                    } else if (type === 'MT') {
                        // For Material Transfers, we need to create a new handler
                        $('#material_request_id').val('');
                        $('#direct_delivery_id').val('');
                        $('#material_transfer_id').val(id);
                        $('#reference_type').val('material_transfer');
                        updateSelectionLabels('material_transfer');
                        loadMaterialTransferDetails(id);
                    }
                } else {
                    // Clear all hidden fields
                    $('#material_request_id').val('');
                    $('#direct_delivery_id').val('');
                    $('#material_transfer_id').val('');
                    $('#reference_type').val('');
                    clearMaterialRequestData();
                    updateSelectionLabels('none');
                }
            });

            // Handle form submission - clean up force close fields if not needed
            $('#returnForm').on('submit', function() {
                // If force close is not checked, remove the reason field to avoid validation errors
                if (!$('#force_close_return').is(':checked')) {
                    $('#force_close_reason').removeAttr('name');
                }
            });

            // Auto-update exchange rate when currency changes
            $('#currency').change(function() {
                updateExchangeRate();
            });

            // Update totals when exchange rate changes
            $('#exchange_rate, #vat_rate').on('input', function() {
                calculateTotals();
            });

            // Auto-fill received by name when user is selected
            $('#received_by').change(function() {
                const selectedOption = $(this).find('option:selected');
                if (selectedOption.val()) {
                    $('#received_by_name').val(selectedOption.text());
                }
            });
        });


        function updateExchangeRate() {
            const currency = $('#currency').val();
            const exchangeRates = {
                'AED': 1.0000,
                'USD': 3.6725,
                'EUR': 4.0000,
                'GBP': 4.5000,
                'SAR': 0.9793
            };

            if (exchangeRates[currency]) {
                $('#exchange_rate').val(exchangeRates[currency]);
                calculateTotals();
            }
        }

        function addItemRow() {
            itemRowCounter++;
            const rowHtml = `
                <tr class="item-row" data-row="${itemRowCounter}">
                    <td>
                        <select name="items[${itemRowCounter}][item_id]" class="form-control form-control-sm item-select" required>
                            <option value="">Select Item</option>
                            ${availableItems.map(item => `<option value="${item.id}" data-unit="${item.unit_of_measure}">${item.item_description} (${item.item_code})</option>`).join('')}
                        </select>
                    </td>
                    <td>
                        <input type="number" name="items[${itemRowCounter}][quantity_delivered]" class="form-control form-control-sm quantity-returned"
                               placeholder="0" step="0.01" min="0" required>
                    </td>
                    <td>
                        <input type="text" name="items[${itemRowCounter}][unit_of_measure]" class="form-control form-control-sm unit-field"
                               placeholder="Unit" readonly>
                    </td>
                    <td>
                        <select name="items[${itemRowCounter}][quality_status]" class="form-control form-control-sm">
                            <option value="good">Good</option>
                            <option value="fair">Fair</option>
                            <option value="damaged">Damaged</option>
                            <option value="unusable">Unusable</option>
                        </select>
                    </td>
                    <td>
                        <input type="number" name="items[${itemRowCounter}][unit_price]" class="form-control form-control-sm unit-price"
                               placeholder="0.00" step="0.01" min="0" required>
                    </td>
                    <td>
                        <input type="number" name="items[${itemRowCounter}][total_price]" class="form-control form-control-sm total-price"
                               placeholder="0.00" step="0.01" min="0" readonly>
                    </td>
                    <td>
                        <input type="text" name="items[${itemRowCounter}][batch_number]" class="form-control form-control-sm"
                               placeholder="Batch">
                    </td>
                    <td>
                        <select name="items[${itemRowCounter}][return_reason]" class="form-control form-control-sm">
                            <option value="excess">Excess</option>
                            <option value="damaged">Damaged</option>
                            <option value="wrong_spec">Wrong Spec</option>
                            <option value="completed">Project Completed</option>
                            <option value="other">Other</option>
                        </select>
                    </td>
                    <td>
                        <input type="text" name="items[${itemRowCounter}][quality_notes]" class="form-control form-control-sm"
                               placeholder="Notes">
                    </td>
                    <td>
                        <button type="button" onclick="removeItemRow(${itemRowCounter})" class="btn btn-sm btn-outline-danger">
                            <i class="material-icons" style="font-size: 14px;">delete</i>
                        </button>
                    </td>
                </tr>
            `;

            $('#items-tbody').append(rowHtml);

            // Bind events to new row
            bindRowEvents(itemRowCounter);
        }

        function bindRowEvents(rowCounter) {
            const row = $(`.item-row[data-row="${rowCounter}"]`);

            // Update unit when item is selected
            row.find('.item-select').change(function() {
                const selectedOption = $(this).find('option:selected');
                const unit = selectedOption.data('unit');
                row.find('.unit-field').val(unit || '');
            });

            // Calculate line total when quantity or price changes
            row.find('.quantity-returned, .unit-price').on('input', function() {
                const quantity = parseFloat(row.find('.quantity-returned').val()) || 0;
                const unitPrice = parseFloat(row.find('.unit-price').val()) || 0;
                const total = quantity * unitPrice;

                row.find('.total-price').val(total.toFixed(2));
                calculateTotals();
            });
        }

        function removeItemRow(rowCounter) {
            $(`.item-row[data-row="${rowCounter}"]`).remove();
            calculateTotals();
        }

        function calculateTotals() {
            let total = 0;

            $('.total-price').each(function() {
                const value = parseFloat($(this).val()) || 0;
                total += value;
            });

            const exchangeRate = parseFloat($('#exchange_rate').val()) || 1;
            const totalAed = total * exchangeRate;

            $('#total-amount').text(total.toFixed(2));
            $('#total_amount_input').val(total);
            $('#total-amount-aed').text(totalAed.toFixed(2));
            $('#total_amount_aed_input').val(totalAed);
        }

        function updateSelectionLabels(selectedType) {
            // Since we now use a combined dropdown, this function is simplified
            // We can update the main label to show what type is selected
            const referenceLabel = $('label[for="reference_id"]');
            const referenceHelp = referenceLabel.parent().find('.form-text');

            if (selectedType === 'material_request') {
                referenceHelp.removeClass('text-muted').addClass('text-success').text('✓ Material Request selected');
            } else if (selectedType === 'direct_delivery') {
                referenceHelp.removeClass('text-muted').addClass('text-success').text('✓ Direct Delivery selected');
            } else if (selectedType === 'material_transfer') {
                referenceHelp.removeClass('text-muted').addClass('text-success').text('✓ Material Transfer selected');
            } else {
                referenceHelp.removeClass('text-success').addClass('text-muted').text('Material requests and direct deliveries will load after selecting a project (sorted by date, newest first)');
            }
        }


        // Project Selection Functions
        function loadMaterialRequestsForProject(projectId) {
            console.log('Loading material requests for project ID:', projectId);

            // Clear existing material request data
            clearMaterialRequestData();

            // Show loading state
            $('#material_request_id').html('<option value="">Loading material requests...</option>')
                                    .prop('disabled', true);

            const ajaxUrl = "<?php echo e(route('warehouse.site-return.get-material-requests-by-project', ':id')); ?>".replace(':id', projectId);
            console.log('AJAX URL:', ajaxUrl);

            // Make AJAX request to get material requests for the project
            $.ajax({
                url: ajaxUrl,
                method: 'GET',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                    'Accept': 'application/json'
                },
                success: function(response) {
                    console.log('AJAX Success Response:', response);
                    if (response.success) {
                        populateMaterialRequestDropdown(response.data);
                    } else {
                        console.error('API returned error:', response.message);
                        $('#material_request_id').html('<option value="">Error loading requests</option>');
                        alert('Error loading material requests: ' + response.message);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('AJAX Error:', {
                        status: xhr.status,
                        statusText: xhr.statusText,
                        responseText: xhr.responseText,
                        error: error
                    });
                    $('#material_request_id').html('<option value="">Error loading requests</option>');
                    alert('Error loading material requests. Please try again.');
                }
            });
        }

        function populateMaterialRequestDropdown(requests) {
            console.log('Populating material requests dropdown:', requests);

            let html = '<option value="">Select Material Request to Return</option>';

            if (requests.length === 0) {
                html = '<option value="">No material requests found for this project</option>';
            } else {
                requests.forEach(function(request) {
                    html += `<option value="${request.id}">${request.text}</option>`;
                });
            }

            $('#material_request_id').html(html)
                                    .prop('disabled', requests.length === 0);

            // Re-initialize Select2
            $('#material_request_id').select2({
                placeholder: 'Please select...',
                allowClear: true
            });
        }

        function clearProjectData() {
            $('#reference_id').html('<option value="">Select Project First</option>')
                              .prop('disabled', true);
            $('#reference_id').select2({
                placeholder: 'Please select...',
                allowClear: true
            });

            // Clear hidden fields
            $('#material_request_id').val('');
            $('#direct_delivery_id').val('');
            $('#material_transfer_id').val('');
            $('#reference_type').val('');

            clearMaterialRequestData();
        }

        // Combined References Loading Function
        function loadCombinedReferencesForProject(projectId) {
            console.log('Loading combined references for project ID:', projectId);

            // Clear existing data
            clearMaterialRequestData();

            // Show loading state
            $('#reference_id').html('<option value="">Loading references...</option>')
                              .prop('disabled', true);

            const ajaxUrl = "<?php echo e(route('warehouse.site-return.get-combined-references-by-project', ':id')); ?>".replace(':id', projectId);
            console.log('AJAX URL:', ajaxUrl);

            // Make AJAX request to get combined references
            $.ajax({
                url: ajaxUrl,
                method: 'GET',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                    'Accept': 'application/json'
                },
                success: function(response) {
                    console.log('Combined references response:', response);

                    if (response.success && response.data && response.data.length > 0) {
                        let options = '<option value="">Select a reference...</option>';

                        response.data.forEach(function(reference) {
                            options += `<option value="${reference.id}">${reference.display_text}</option>`;
                        });

                        $('#reference_id').html(options)
                                          .prop('disabled', false)
                                          .trigger('change');
                    } else {
                        $('#reference_id').html('<option value="">No references found</option>')
                                          .prop('disabled', false);
                        console.log('No references found for this project');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('AJAX Error:', xhr.responseText);
                    $('#reference_id').html('<option value="">Error loading references</option>')
                                      .prop('disabled', false);
                    alert('Error loading references. Please try again.');
                }
            });
        }

        // Material Request Functions
        function loadMaterialRequestDetails(requestId) {
            console.log('Loading material request details for ID:', requestId);

            // Show loading state
            $('#material_request_details').show();
            $('#request_info').html('<i class="material-icons">refresh</i> Loading material request details...');

            const ajaxUrl = "<?php echo e(route('warehouse.site-return.get-material-request', ':id')); ?>".replace(':id', requestId);
            console.log('AJAX URL:', ajaxUrl);

            // Make AJAX request to get material request details
            $.ajax({
                url: ajaxUrl,
                method: 'GET',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                    'Accept': 'application/json'
                },
                success: function(response) {
                    console.log('AJAX Success Response:', response);
                    if (response.success) {
                        console.log('Material request data:', response.data);
                        populateMaterialRequestData(response.data);
                    } else {
                        console.error('API returned error:', response.message);
                        alert('Error loading material request: ' + response.message);
                        clearMaterialRequestData();
                    }
                },
                error: function(xhr, status, error) {
                    console.error('AJAX Error:', {
                        status: xhr.status,
                        statusText: xhr.statusText,
                        responseText: xhr.responseText,
                        error: error
                    });
                    alert('Error loading material request details. Please try again.');
                    clearMaterialRequestData();
                }
            });
        }

        function populateMaterialRequestData(data) {
            console.log('Populating material request data:', data);

            // Update request details display
            $('#request_info').html(`
                <div class="row">
                    <div class="col-md-4"><strong>Request #:</strong> ${data.reference_number}</div>
                    <div class="col-md-4"><strong>Project:</strong> ${data.project_name}</div>
                    <div class="col-md-4"><strong>Date:</strong> ${data.transaction_date}</div>
                </div>
                <div class="row mt-2">
                    <div class="col-md-4"><strong>Requested By:</strong> ${data.requested_by}</div>
                    <div class="col-md-4"><strong>Division:</strong> ${data.division_name || 'N/A'}</div>
                    <div class="col-md-4"><strong>Status:</strong> <span class="badge badge-success">${data.status}</span></div>
                </div>
            `);

            // Populate hidden project and division fields
            $('#project_id').val(data.project_id);
            $('#division').val(data.division_name || '');

            // Populate items table
            populateItemsTable(data.items);

            // Calculate and show return status
            calculateReturnStatus(data.items);

            // Show items table
            $('#no-items-message').hide();
            $('#items-table-container').show();
        }

        function populateItemsTable(items) {
            let html = '';
            items.forEach((item, index) => {
                const maxReturn = parseFloat(item.remaining_returnable) || 0; // Can't return more than what's left to return
                const totalIssued = parseFloat(item.quantity_released) || 0;
                const previouslyReturned = parseFloat(item.previously_returned) || 0;
                const transferredToProjects = parseFloat(item.transferred_to_projects) || 0;
                const isFullyReturned = maxReturn <= 0;
                const rowClass = isFullyReturned ? 'table-secondary' : '';

                html += `
                    <tr class="${rowClass}">
                        <td>
                            <strong>${item.item_description}</strong>
                            <input type="hidden" name="items[${index}][item_id]" value="${item.item_id}">
                            <input type="hidden" name="items[${index}][outgoing_item_id]" value="${item.id}">
                        </td>
                        <td><code>${item.item_code}</code></td>
                        <td><span class="badge badge-secondary">${item.unit}</span></td>
                        <td class="text-center"><strong class="text-info">${totalIssued.toFixed(2)}</strong></td>
                        <td class="text-center"><span class="text-warning">${previouslyReturned.toFixed(2)}</span></td>
                        <td class="text-center"><span class="text-primary">${transferredToProjects.toFixed(2)}</span></td>
                        <td class="text-center">
                            ${isFullyReturned ?
                                '<span class="badge badge-secondary">Fully Returned</span>' :
                                `<strong class="text-success">${maxReturn.toFixed(2)}</strong>`
                            }
                        </td>
                        <td>
                            ${isFullyReturned ?
                                '<span class="text-muted">N/A</span>' :
                                `<input type="number"
                                       name="items[${index}][quantity_returned]"
                                       class="form-control form-control-sm quantity-returned"
                                       placeholder="0.00"
                                       step="0.01"
                                       min="0"
                                       max="${maxReturn}"
                                       data-max="${maxReturn}">`
                            }
                        </td>
                        <td>
                            <select name="items[${index}][condition]" class="form-control form-control-sm">
                                <option value="good">Good</option>
                                <option value="fair">Fair</option>
                                <option value="damaged">Damaged</option>
                                <option value="unusable">Unusable</option>
                            </select>
                        </td>
                        <td>
                            <select name="items[${index}][return_reason]" class="form-control form-control-sm">
                                <option value="excess_materials">Excess Materials</option>
                                <option value="project_completion">Project Completion</option>
                                <option value="damaged_items">Damaged Items</option>
                                <option value="wrong_specification">Wrong Specification</option>
                                <option value="quality_issues">Quality Issues</option>
                                <option value="other">Other</option>
                            </select>
                        </td>
                        <td>
                            <input type="text" name="items[${index}][notes]" class="form-control form-control-sm" placeholder="Return notes">
                        </td>
                    </tr>
                `;
            });
            $('#items-tbody').html(html);

            // Bind validation to quantity inputs
            $('.quantity-returned').on('input', function() {
                const max = parseFloat($(this).data('max'));
                const value = parseFloat($(this).val());
                if (value > max) {
                    $(this).val(max);
                    alert(`Cannot return more than ${max} units for this item.`);
                }

                // Visual feedback for rows with/without return quantities
                const row = $(this).closest('tr');
                if (value > 0) {
                    row.removeClass('table-secondary').addClass('table-success');
                    row.find('.quantity-returned').removeClass('is-invalid').addClass('is-valid');
                } else {
                    row.removeClass('table-success table-secondary');
                    row.find('.quantity-returned').removeClass('is-valid is-invalid');
                }
            });
        }

        function calculateReturnStatus(items) {
            let totalIssued = 0;
            let totalReturned = 0;
            let hasPartiallyReturned = false;
            let hasFullyReturned = false;
            let hasNotReturned = false;
            let isForceClosed = false;

            items.forEach(item => {
                const issued = parseFloat(item.quantity_released) || 0;
                const returned = parseFloat(item.previously_returned) || 0;
                const remaining = parseFloat(item.remaining_returnable) || 0;

                totalIssued += issued;
                totalReturned += returned;

                if (returned === 0) {
                    hasNotReturned = true;
                } else if (remaining > 0) {
                    hasPartiallyReturned = true;
                } else {
                    hasFullyReturned = true;
                }
            });

            // Determine overall status
            let status, statusClass, statusDetails;

            if (totalReturned === 0) {
                status = "Not Returned";
                statusClass = "danger";
                statusDetails = "No items have been returned yet";
            } else if (hasPartiallyReturned || (hasNotReturned && totalReturned > 0)) {
                status = "Partially Returned";
                statusClass = "warning";
                statusDetails = `${totalReturned.toFixed(2)} of ${totalIssued.toFixed(2)} total returned`;
            } else if (totalReturned === totalIssued) {
                status = "Fully Returned";
                statusClass = "success";
                statusDetails = "All items have been returned";
            } else {
                status = "Closed Return";
                statusClass = "secondary";
                statusDetails = "Return process completed";
            }

            // Update status display
            $('#return-status-card').show();
            $('#return-status-card').removeClass('alert-secondary alert-danger alert-warning alert-success').addClass(`alert-${statusClass}`);
            $('#status-badge').removeClass('badge-secondary badge-danger badge-warning badge-success').addClass(`badge-${statusClass}`).text(status);
            $('#status-details').html(`
                <div>${statusDetails}</div>
                <small class="text-muted mt-1 d-block">
                    Total Issued: ${totalIssued.toFixed(2)} | Previously Returned: ${totalReturned.toFixed(2)}
                </small>
            `);
        }

        function clearMaterialRequestData() {
            $('#material_request_details').hide();
            $('#request_info').html('');
            $('#project_id').val('');
            $('#division').val('');
            $('#items-tbody').html('');
            $('#no-items-message').show();
            $('#items-table-container').hide();
            $('#return-status-card').hide();
        }

        // Direct Delivery Functions
        function loadDirectDeliveriesForProject(projectId) {
            console.log('Loading direct deliveries for project ID:', projectId);

            // Show loading state
            $('#direct_delivery_id').html('<option value="">Loading direct deliveries...</option>')
                                   .prop('disabled', true);

            const ajaxUrl = "<?php echo e(route('warehouse.site-return.get-direct-deliveries-by-project', ':id')); ?>".replace(':id', projectId);
            console.log('AJAX URL:', ajaxUrl);

            // Make AJAX request to get direct deliveries for the project
            $.ajax({
                url: ajaxUrl,
                method: 'GET',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                    'Accept': 'application/json'
                },
                success: function(response) {
                    console.log('AJAX Success Response:', response);
                    if (response.success) {
                        populateDirectDeliveryDropdown(response.data);
                    } else {
                        console.error('API returned error:', response.message);
                        $('#direct_delivery_id').html('<option value="">Error loading deliveries</option>');
                        alert('Error loading direct deliveries. Please try again.');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('AJAX Error:', {
                        status: status,
                        error: error,
                        response: xhr.responseText
                    });
                    $('#direct_delivery_id').html('<option value="">Error loading deliveries</option>');
                    alert('Error loading direct deliveries. Please try again.');
                }
            });
        }

        function populateDirectDeliveryDropdown(deliveries) {
            console.log('Populating direct deliveries dropdown:', deliveries);

            let html = '<option value="">Select Direct Delivery (Optional)</option>';

            if (deliveries.length === 0) {
                html = '<option value="">No direct deliveries available for this project</option>';
            } else {
                deliveries.forEach(function(delivery) {
                    html += `<option value="${delivery.id}">${delivery.text}</option>`;
                });
            }

            $('#direct_delivery_id').html(html)
                                   .prop('disabled', false);

            // Re-initialize Select2
            $('#direct_delivery_id').select2({
                placeholder: 'Please select...',
                allowClear: true
            });
        }

        function loadDirectDeliveryDetails(deliveryId) {
            console.log('Loading direct delivery details for ID:', deliveryId);

            // Show loading state
            $('#material_request_details').show();
            $('#request_info').html('<i class="material-icons">refresh</i> Loading direct delivery details...');

            const ajaxUrl = "<?php echo e(route('warehouse.site-return.get-direct-delivery', ':id')); ?>".replace(':id', deliveryId);
            console.log('AJAX URL:', ajaxUrl);

            $.ajax({
                url: ajaxUrl,
                method: 'GET',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                    'Accept': 'application/json'
                },
                success: function(response) {
                    console.log('AJAX Success Response:', response);
                    if (response.success) {
                        populateDirectDeliveryDetails(response.data);
                    } else {
                        console.error('API returned error:', response.message);
                        $('#request_info').html('<span class="text-danger">Error: ' + response.message + '</span>');
                        alert('Error loading direct delivery details: ' + response.message);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('AJAX Error:', {
                        status: status,
                        error: error,
                        response: xhr.responseText
                    });
                    $('#request_info').html('<span class="text-danger">Error loading direct delivery details</span>');
                    alert('Error loading direct delivery details. Please try again.');
                }
            });
        }

        function populateDirectDeliveryDetails(data) {
            console.log('Populating direct delivery details:', data);

            // Update project info
            $('#project_id').val(data.project_id);
            $('#division').val(''); // Direct deliveries don't have divisions

            // Update display
            $('#request_info').html(`
                <div class="row">
                    <div class="col-md-8">
                        <strong>Direct Delivery:</strong> ${data.reference_number}<br>
                        <strong>Project:</strong> ${data.project_name}<br>
                        <strong>Supplier:</strong> ${data.supplier_name}<br>
                        <strong>Delivery Date:</strong> ${data.delivery_date}<br>
                        <strong>Status:</strong> <span class="badge badge-success">${data.status}</span>
                    </div>
                </div>
            `);

            // Populate items for return
            populateDirectDeliveryItemsForReturn(data.items);

            // Calculate and update return status
            calculateReturnStatus(data.items);
        }

        function populateDirectDeliveryItemsForReturn(items) {
            console.log('Populating direct delivery items:', items);

            let html = '';
            items.forEach(function(item, index) {
                const previouslyReturned = parseFloat(item.previously_returned) || 0;
                const delivered = parseFloat(item.quantity_delivered) || 0;
                const transferredToProjects = parseFloat(item.transferred_to_projects) || 0;
                const maxReturn = parseFloat(item.remaining_returnable) || 0;
                const isFullyReturned = maxReturn <= 0;

                html += `
                    <tr class="item-row" data-row="${index}">
                        <input type="hidden" name="items[${index}][item_id]" value="${item.item_id}">
                        <input type="hidden" name="items[${index}][direct_delivery_item_id]" value="${item.id}">
                        <td>
                            <strong>${item.item_description}</strong>
                            ${item.item_code ? `<br><code>${item.item_code}</code>` : ''}
                            ${item.batch_number ? `<br><small class="text-info">Batch: ${item.batch_number}</small>` : ''}
                        </td>
                        <td><code>${item.item_code || 'N/A'}</code></td>
                        <td><span class="badge badge-secondary">${item.unit}</span></td>
                        <td class="text-center"><strong class="text-info">${delivered.toFixed(2)}</strong></td>
                        <td class="text-center"><span class="text-warning">${previouslyReturned.toFixed(2)}</span></td>
                        <td class="text-center"><span class="text-primary">${transferredToProjects.toFixed(2)}</span></td>
                        <td class="text-center">
                            ${isFullyReturned ?
                                '<span class="badge badge-secondary">Fully Returned</span>' :
                                `<strong class="text-success">${maxReturn.toFixed(2)}</strong>`
                            }
                        </td>
                        <td>
                            ${isFullyReturned ?
                                '<span class="text-muted">N/A</span>' :
                                `<input type="number"
                                       name="items[${index}][quantity_returned]"
                                       class="form-control form-control-sm quantity-returned"
                                       placeholder="0.00"
                                       step="0.01"
                                       min="0"
                                       max="${maxReturn}"
                                       data-max="${maxReturn}">`
                            }
                        </td>
                        <td>
                            <select name="items[${index}][condition]" class="form-control form-control-sm">
                                <option value="good">Good</option>
                                <option value="fair">Fair</option>
                                <option value="damaged">Damaged</option>
                                <option value="unusable">Unusable</option>
                            </select>
                        </td>
                        <td>
                            <select name="items[${index}][return_reason]" class="form-control form-control-sm">
                                <option value="excess_materials">Excess Materials</option>
                                <option value="project_completion">Project Completion</option>
                                <option value="damaged_items">Damaged Items</option>
                                <option value="wrong_specification">Wrong Specification</option>
                                <option value="quality_issues">Quality Issues</option>
                                <option value="other">Other</option>
                            </select>
                        </td>
                        <td>
                            <input type="text" name="items[${index}][notes]" class="form-control form-control-sm" placeholder="Return notes">
                        </td>
                    </tr>
                `;
            });
            $('#items-tbody').html(html);

            // Show items table and hide no-items message
            $('#no-items-message').hide();
            $('#items-table-container').show();

            // Bind validation to quantity inputs
            $('.quantity-returned').on('input', function() {
                const max = parseFloat($(this).data('max'));
                const value = parseFloat($(this).val());
                if (value > max) {
                    $(this).val(max);
                    alert(`Cannot return more than ${max} units for this item.`);
                }

                // Visual feedback for rows with/without return quantities
                const row = $(this).closest('tr');
                if (value > 0) {
                    row.removeClass('table-secondary').addClass('table-success');
                    row.find('.quantity-returned').removeClass('is-invalid').addClass('is-valid');
                } else {
                    row.removeClass('table-success table-secondary');
                    row.find('.quantity-returned').removeClass('is-valid is-invalid');
                }
            });
        }

        // Material Transfer Functions
        function loadMaterialTransferDetails(transferId) {
            console.log('Loading material transfer details for ID:', transferId);

            // Show loading state
            $('#material_request_details').show();
            $('#request_info').html('<i class="material-icons">refresh</i> Loading material transfer details...');

            const ajaxUrl = "<?php echo e(route('warehouse.site-return.get-material-transfer', ':id')); ?>".replace(':id', transferId);
            console.log('AJAX URL:', ajaxUrl);

            $.ajax({
                url: ajaxUrl,
                method: 'GET',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                    'Accept': 'application/json'
                },
                success: function(response) {
                    console.log('Material transfer response:', response);
                    if (response.success && response.data) {
                        displayMaterialTransferInfo(response.data);
                        populateMaterialTransferItemsForReturn(response.data.items);
                    } else {
                        $('#request_info').html('<div class="text-danger">Error: ' + (response.message || 'Failed to load material transfer details') + '</div>');
                        clearMaterialRequestData();
                    }
                },
                error: function(xhr, status, error) {
                    console.error('AJAX Error:', xhr.responseText);
                    $('#request_info').html('<div class="text-danger">Error loading material transfer details. Please try again.</div>');
                    clearMaterialRequestData();
                }
            });
        }

        function displayMaterialTransferInfo(data) {
            $('#request_info').html(`
                <div class="row">
                    <div class="col-md-6">
                        <strong>Transfer Number:</strong> ${data.transfer_request_number || 'N/A'}<br>
                        <strong>From Project:</strong> ${data.transferrer_project_name || 'N/A'}<br>
                        <strong>To Project:</strong> ${data.receiver_project_name || 'N/A'}<br>
                        <strong>Transfer Date:</strong> ${data.request_date || 'N/A'}
                    </div>
                    <div class="col-md-6">
                        <strong>Status:</strong> <span class="badge badge-success">${data.status || 'N/A'}</span><br>
                        <strong>Priority:</strong> <span class="badge badge-info">${data.priority || 'N/A'}</span><br>
                        <strong>Items:</strong> ${data.items ? data.items.length : 0} items transferred
                    </div>
                </div>
            `);

            // Set hidden project field to match the transfer's receiver project
            $('#project_id').val(data.receiver_project_id);
            $('#division').val(''); // Material transfers may not have division info
        }

        function populateMaterialTransferItemsForReturn(items) {
            console.log('Populating material transfer items:', items);

            let html = '';
            items.forEach(function(item, index) {
                const previouslyReturned = parseFloat(item.previously_returned) || 0;
                const transferred = parseFloat(item.quantity_approved) || 0;
                const transferredToProjects = parseFloat(item.transferred_to_projects) || 0;
                const maxReturn = parseFloat(item.remaining_returnable) || 0;
                const isFullyReturned = maxReturn <= 0;

                html += `
                    <tr class="item-row" data-row="${index}">
                        <input type="hidden" name="items[${index}][item_id]" value="${item.item_id}">
                        <input type="hidden" name="items[${index}][material_transfer_item_id]" value="${item.id}">
                        <td>
                            <strong>${item.item_description}</strong>
                            ${item.item_code ? `<br><code>${item.item_code}</code>` : ''}
                        </td>
                        <td><code>${item.item_code || 'N/A'}</code></td>
                        <td><span class="badge badge-secondary">${item.unit}</span></td>
                        <td class="text-center"><strong class="text-info">${transferred.toFixed(2)}</strong></td>
                        <td class="text-center"><span class="text-warning">${previouslyReturned.toFixed(2)}</span></td>
                        <td class="text-center"><span class="text-primary">${transferredToProjects.toFixed(2)}</span></td>
                        <td class="text-center">
                            ${isFullyReturned ?
                                '<span class="badge badge-secondary">Fully Returned</span>' :
                                `<strong class="text-success">${maxReturn.toFixed(2)}</strong>`
                            }
                        </td>
                        <td>
                            ${isFullyReturned ?
                                '<span class="text-muted">N/A</span>' :
                                `<input type="number"
                                       name="items[${index}][quantity_returned]"
                                       class="form-control form-control-sm quantity-returned"
                                       placeholder="0.00"
                                       step="0.01"
                                       min="0"
                                       max="${maxReturn}"
                                       data-max="${maxReturn}">`
                            }
                        </td>
                        <td>
                            <select name="items[${index}][condition]" class="form-control form-control-sm">
                                <option value="good">Good</option>
                                <option value="fair">Fair</option>
                                <option value="damaged">Damaged</option>
                                <option value="unusable">Unusable</option>
                            </select>
                        </td>
                        <td>
                            <select name="items[${index}][return_reason]" class="form-control form-control-sm">
                                <option value="excess_materials">Excess Materials</option>
                                <option value="project_completion">Project Completion</option>
                                <option value="damaged_items">Damaged Items</option>
                                <option value="wrong_specification">Wrong Specification</option>
                                <option value="quality_issues">Quality Issues</option>
                                <option value="other">Other</option>
                            </select>
                        </td>
                        <td>
                            <input type="text" name="items[${index}][notes]" class="form-control form-control-sm" placeholder="Return notes">
                        </td>
                    </tr>
                `;
            });
            $('#items-tbody').html(html);

            // Show items table and hide no-items message
            $('#no-items-message').hide();
            $('#items-table-container').show();

            // Bind validation to quantity inputs
            $('.quantity-returned').on('input', function() {
                const max = parseFloat($(this).data('max'));
                const value = parseFloat($(this).val());
                if (value > max) {
                    $(this).val(max);
                    alert(`Cannot return more than ${max} units for this item.`);
                }

                // Visual feedback for rows with/without return quantities
                const row = $(this).closest('tr');
                if (value > 0) {
                    row.removeClass('table-secondary').addClass('table-success');
                    row.find('.quantity-returned').removeClass('is-invalid').addClass('is-valid');
                } else {
                    row.removeClass('table-success table-secondary');
                    row.find('.quantity-returned').removeClass('is-valid is-invalid');
                }
            });

            // Calculate and update return status for transferred materials
            calculateReturnStatus(items);
        }

        // Form validation
        $('#returnForm').on('submit', function(e) {
            const materialRequestId = $('#material_request_id').val();
            const directDeliveryId = $('#direct_delivery_id').val();
            const materialTransferId = $('#material_transfer_id').val();
            const projectId = $('#project_id').val();

            // Debug logging
            console.log('Form submission debug:', {
                materialRequestId: materialRequestId,
                directDeliveryId: directDeliveryId,
                materialTransferId: materialTransferId,
                projectId: projectId,
                itemsCount: $('#items-tbody tr').length,
                hasQuantities: $('.quantity-returned').filter(function() { return parseFloat($(this).val()) > 0; }).length
            });

            // Validate project selection
            if (!projectId) {
                e.preventDefault();
                showValidationError('Please select a project first.');
                return false;
            }

            // Validate that exactly one reference is selected
            const selectedReferences = [materialRequestId, directDeliveryId, materialTransferId].filter(Boolean);

            if (selectedReferences.length === 0) {
                e.preventDefault();
                showValidationError('Please select a reference (Material Request, Direct Delivery, or Material Transfer).');
                return false;
            }

            if (selectedReferences.length > 1) {
                e.preventDefault();
                showValidationError('Please select only ONE reference type at a time.');
                return false;
            }

            const itemsCount = $('#items-tbody tr').length;
            if (itemsCount === 0) {
                e.preventDefault();
                showValidationError('No items available for return. Please select a valid reference to load items.');
                return false;
            }

            // Check if at least one item has a return quantity > 0
            let hasReturnQuantity = false;
            $('.quantity-returned').each(function() {
                if (parseFloat($(this).val()) > 0) {
                    hasReturnQuantity = true;
                    return false; // break loop
                }
            });

            if (!hasReturnQuantity) {
                e.preventDefault();
                showValidationError('Please specify return quantities for at least one item.');
                return false;
            }

            // Clear the non-selected fields to prevent backend validation issues
            // Only keep the name attribute for the selected reference type
            if (materialRequestId) {
                $('#direct_delivery_id').removeAttr('name');
                $('#material_transfer_id').removeAttr('name');
            } else if (directDeliveryId) {
                $('#material_request_id').removeAttr('name');
                $('#material_transfer_id').removeAttr('name');
            } else if (materialTransferId) {
                $('#material_request_id').removeAttr('name');
                $('#direct_delivery_id').removeAttr('name');
            } else {
                // If none are selected, this should have been caught by validation above
                // But as a safety measure, don't submit
                e.preventDefault();
                showValidationError('Critical error: No reference selected. Please refresh the page and try again.');
                return false;
            }

            // Remove items that don't have return quantities to prevent validation errors
            $('.quantity-returned').each(function() {
                const quantity = parseFloat($(this).val()) || 0;
                if (quantity <= 0) {
                    // Remove the entire row's form fields by removing their 'name' attributes
                    const row = $(this).closest('tr');
                    row.find('input[name], select[name], textarea[name]').each(function() {
                        $(this).removeAttr('name');
                    });
                }
            });
        });

        function showValidationError(message) {
            // Remove existing error alerts
            $('.alert-validation-error').remove();

            // Create and show new error alert
            const errorAlert = `
                <div class="alert alert-danger alert-validation-error">
                    <h6><i class="material-icons align-middle mr-1">error</i> Validation Error:</h6>
                    <p class="mb-0">${message}</p>
                </div>
            `;

            // Insert at the top of the form
            $('#returnForm').prepend(errorAlert);

            // Scroll to top to show the error
            $('html, body').animate({
                scrollTop: $('#returnForm').offset().top - 20
            }, 500);

            // Auto-hide after 10 seconds
            setTimeout(function() {
                $('.alert-validation-error').fadeOut(500, function() {
                    $(this).remove();
                });
            }, 10000);
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/site-return/create.blade.php ENDPATH**/ ?>