<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Site Returns - <?php echo e($consolidatedData['project']->project_name); ?></title>
    <style>
        @media print {
            body { margin: 0; }
            .no-print { display: none; }
        }

        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #000;
            margin: 20px;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
        }

        .company-name {
            font-size: 16px;
            font-weight: bold;
            margin-bottom: 2px;
            text-transform: uppercase;
        }

        .company-address {
            font-size: 10px;
            margin-bottom: 1px;
        }

        .document-title {
            font-size: 14px;
            font-weight: bold;
            margin: 20px 0;
            text-transform: uppercase;
            text-align: center;
        }

        .info-section {
            margin-bottom: 20px;
        }

        .info-row {
            margin-bottom: 8px;
            font-size: 12px;
        }

        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            font-size: 11px;
        }

        .items-table th,
        .items-table td {
            border: 1px solid #000;
            padding: 5px 8px;
            text-align: left;
        }

        .items-table th {
            font-weight: bold;
            background-color: #f0f0f0;
        }

        .items-table td.text-center {
            text-align: center;
        }

        .items-table td.text-right {
            text-align: right;
        }

        .footer {
            margin-top: 40px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }

        .print-btn {
            background-color: #007bff;
            color: white;
            border: none;
            padding: 10px 20px;
            cursor: pointer;
            border-radius: 4px;
            margin-bottom: 20px;
        }

        .print-btn:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <div class="no-print">
        <button onclick="window.print()" class="print-btn">🖨️ Print</button>
        <button onclick="window.close()" class="print-btn" style="background-color: #6c757d;">✕ Close</button>
    </div>

    <!-- Header -->
    <div class="header">
        <div class="company-name">ISAM KABBANI & PARTNERS FOR CONSTRUCTION & MAINT. CO. ( L.L.C )</div>
        <div class="company-address">Dubai: Dubai Investment Park, Jebel Ali Tel# 04 884 1522; Fax# 04 884 1523</div>
        <div class="company-address">E-mail : dubai@kcgemirates.ae; abudhabi@kcgemirates.ae   Website : www.ikkgroup.com</div>
    </div>

    <!-- Document Title -->
    <div class="document-title">SITE RETURN REPORT</div>

    <!-- Project Information -->
    <div class="info-section">
        <div class="info-row">
            <strong>Project:</strong> <?php echo e($consolidatedData['project']->project_name); ?>

        </div>
        <div class="info-row">
            <strong>Date:</strong> <?php echo e($consolidatedData['printDate']); ?>

        </div>
        <div class="info-row">
            <strong>Total Returns:</strong> <?php echo e($consolidatedData['totalReturns']); ?>

        </div>
    </div>

    <!-- Items Table -->
    <table class="items-table">
        <thead>
            <tr>
                <th style="width: 5%;">Sr.</th>
                <th style="width: 15%;">Return Date</th>
                <th style="width: 15%;">MR/Ref No.</th>
                <th style="width: 10%;">Item Code</th>
                <th style="width: 30%;">Description</th>
                <th style="width: 10%;">Quantity</th>
                <th style="width: 8%;">Unit</th>
                <th style="width: 7%;">Condition</th>
            </tr>
        </thead>
        <tbody>
            <?php $serialNo = 1; ?>
            <?php $__currentLoopData = $consolidatedData['returns']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $return): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $__currentLoopData = $return->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="text-center"><?php echo e($serialNo++); ?></td>
                    <td class="text-center"><?php echo e($return->operation_date->format('d/m/Y')); ?></td>
                    <td class="text-center"><?php echo e($return->materialRequest->mr_number ?? 'Direct'); ?></td>
                    <td class="text-center"><?php echo e($item->item->item_code ?? 'N/A'); ?></td>
                    <td><?php echo e($item->item->item_description ?? 'N/A'); ?></td>
                    <td class="text-center"><?php echo e(number_format($item->quantity_delivered, 0)); ?></td>
                    <td class="text-center"><?php echo e(strtoupper($item->item->unit_of_measure ?? 'PCS')); ?></td>
                    <td class="text-center"><?php echo e(ucfirst($item->return_condition ?? 'Good')); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tfoot>
            <tr style="font-weight: bold;">
                <td colspan="5" class="text-right">TOTAL:</td>
                <td class="text-center"><?php echo e(number_format($consolidatedData['totalItems'], 0)); ?></td>
                <td colspan="2"></td>
            </tr>
        </tfoot>
    </table>

    <!-- Footer -->
    <div class="footer">
        <p>Generated on <?php echo e($consolidatedData['printDate']); ?></p>
    </div>

    <script>
        // Auto-print when page loads
        window.addEventListener('load', function() {
            setTimeout(() => {
                if (window.opener) {
                    window.print();
                }
            }, 500);
        });

        // Close window after printing
        window.addEventListener('afterprint', function() {
            if (window.opener) {
                setTimeout(() => {
                    window.close();
                }, 500);
            }
        });
    </script>
</body>
</html><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/site-return/print-consolidated.blade.php ENDPATH**/ ?>