<?php $__env->startSection('title', 'Item Details - ' . $item->item_code); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('warehouse.reports.index')); ?>">Reports</a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('warehouse.reports.inventory')); ?>">Inventory Report</a></li>
    <li class="breadcrumb-item active"><?php echo e($item->item_code); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1"><?php echo e($item->item_code); ?> - Detailed Analysis</h3>
            <p class="text-muted mb-0" style="font-size: 13px;"><?php echo e($item->item_description); ?></p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <a href="<?php echo e(route('warehouse.reports.inventory')); ?>" class="btn btn-sm btn-outline-secondary mr-2">
                <i class="material-icons mr-1" style="font-size: 16px;">arrow_back</i>
                Back to Report
            </a>
            <button type="button" onclick="printItemDetails()" class="btn btn-sm btn-info">
                <i class="material-icons mr-1" style="font-size: 16px;">print</i>
                Print Details
            </button>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Item Summary -->
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">info</i>
                Item Information
            </h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Item Code:</strong></td>
                            <td><?php echo e($item->item_code); ?></td>
                        </tr>
                        <tr>
                            <td><strong>Description:</strong></td>
                            <td><?php echo e($item->item_description); ?></td>
                        </tr>
                        <tr>
                            <td><strong>Category:</strong></td>
                            <td><?php echo e($item->category->category_name ?? 'Unknown'); ?></td>
                        </tr>
                        <tr>
                            <td><strong>Unit of Measure:</strong></td>
                            <td><?php echo e($item->unit_of_measure); ?></td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Total Quantity:</strong></td>
                            <td><strong><?php echo e(number_format($inventoryDetails->sum('quantity'), 2)); ?> <?php echo e($item->unit_of_measure); ?></strong></td>
                        </tr>
                        <tr>
                            <td><strong>Total Value:</strong></td>
                            <td><strong>AED <?php echo e(number_format($inventoryDetails->sum('total_value'), 2)); ?></strong></td>
                        </tr>
                        <tr>
                            <td><strong>Purchase History:</strong></td>
                            <td><?php echo e($pricingHistory->count()); ?> purchase operations</td>
                        </tr>
                        <tr>
                            <td><strong>Storage Locations:</strong></td>
                            <td><?php echo e($inventoryDetails->groupBy('division')->count()); ?> divisions</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Pricing History -->
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">attach_money</i>
                Purchase Price History (<?php echo e($pricingHistory->count()); ?> records)
            </h6>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-sm mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th>Date</th>
                            <th>Operation</th>
                            <th>Supplier</th>
                            <th>Quantity</th>
                            <th>Unit Price (Original)</th>
                            <th>Unit Price (AED)</th>
                            <th>Total Value (AED)</th>
                            <th>Batch</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $pricingHistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purchase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($purchase->date->format('d M, Y')); ?></td>
                                <td>
                                    <span class="badge badge-outline-primary"><?php echo e($purchase->operation_number); ?></span>
                                </td>
                                <td><?php echo e($purchase->supplier); ?></td>
                                <td class="text-right"><?php echo e(number_format($purchase->quantity, 2)); ?></td>
                                <td class="text-right">
                                    <?php echo e($purchase->currency); ?> <?php echo e(number_format($purchase->original_unit_price, 2)); ?>

                                </td>
                                <td class="text-right">
                                    <strong>AED <?php echo e(number_format($purchase->unit_price, 2)); ?></strong>
                                </td>
                                <td class="text-right">
                                    <strong>AED <?php echo e(number_format($purchase->total_price, 2)); ?></strong>
                                </td>
                                <td><?php echo e($purchase->batch_number ?: '-'); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="text-center py-3">
                                    <span class="text-muted">No purchase history found</span>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Current Inventory Breakdown -->
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">inventory_2</i>
                Current Inventory Breakdown (<?php echo e($inventoryDetails->count()); ?> batches)
            </h6>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-sm mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th>Division</th>
                            <th>Location</th>
                            <th>Batch Number</th>
                            <th>Quantity</th>
                            <th>Unit Price</th>
                            <th>Total Value</th>
                            <th>Production Date</th>
                            <th>Expiry Date</th>
                            <th>Days to Expiry</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $inventoryDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inventory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="<?php echo e($inventory->days_until_expiry !== null && $inventory->days_until_expiry < 0 ? 'table-danger' : ($inventory->days_until_expiry !== null && $inventory->days_until_expiry <= 30 ? 'table-warning' : '')); ?>">
                                <td>
                                    <span class="badge badge-light"><?php echo e($inventory->division); ?></span>
                                </td>
                                <td><?php echo e($inventory->location ?: '-'); ?></td>
                                <td>
                                    <code><?php echo e($inventory->batch_number ?: '-'); ?></code>
                                </td>
                                <td class="text-right">
                                    <strong><?php echo e(number_format($inventory->quantity, 2)); ?></strong> <?php echo e($item->unit_of_measure); ?>

                                </td>
                                <td class="text-right">
                                    AED <?php echo e(number_format($inventory->unit_price, 2)); ?>

                                </td>
                                <td class="text-right">
                                    <strong>AED <?php echo e(number_format($inventory->total_value, 2)); ?></strong>
                                </td>
                                <td class="text-center">
                                    <?php echo e($inventory->production_date ? $inventory->production_date->format('d M, Y') : '-'); ?>

                                </td>
                                <td class="text-center">
                                    <?php if($inventory->expiry_date): ?>
                                        <?php echo e($inventory->expiry_date->format('d M, Y')); ?>

                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <?php if($inventory->days_until_expiry !== null): ?>
                                        <?php if($inventory->days_until_expiry < 0): ?>
                                            <span class="text-danger font-weight-bold">Expired (<?php echo e(abs($inventory->days_until_expiry)); ?> days ago)</span>
                                        <?php elseif($inventory->days_until_expiry <= 30): ?>
                                            <span class="text-warning font-weight-bold"><?php echo e($inventory->days_until_expiry); ?> days</span>
                                        <?php else: ?>
                                            <span class="text-success"><?php echo e($inventory->days_until_expiry); ?> days</span>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <span class="badge badge-<?php echo e($inventory->status === 'in_stock' ? 'success' :
                                        ($inventory->status === 'low_stock' ? 'warning' : 'danger')); ?>">
                                        <?php echo e(ucfirst(str_replace('_', ' ', $inventory->status))); ?>

                                    </span>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="10" class="text-center py-3">
                                    <span class="text-muted">No current inventory found</span>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Price Analysis Summary -->
    <div class="row">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="material-icons mr-2">analytics</i>
                        Price Analysis
                    </h6>
                </div>
                <div class="card-body">
                    <?php if($pricingHistory->count() > 0): ?>
                        <div class="list-group list-group-flush">
                            <div class="list-group-item d-flex justify-content-between px-0">
                                <span><strong>Lowest Purchase Price:</strong></span>
                                <span class="text-success font-weight-bold">AED <?php echo e(number_format($pricingHistory->min('unit_price'), 2)); ?></span>
                            </div>
                            <div class="list-group-item d-flex justify-content-between px-0">
                                <span><strong>Highest Purchase Price:</strong></span>
                                <span class="text-danger font-weight-bold">AED <?php echo e(number_format($pricingHistory->max('unit_price'), 2)); ?></span>
                            </div>
                            <div class="list-group-item d-flex justify-content-between px-0">
                                <span><strong>Average Purchase Price:</strong></span>
                                <span class="text-primary font-weight-bold">AED <?php echo e(number_format($pricingHistory->avg('unit_price'), 2)); ?></span>
                            </div>
                            <div class="list-group-item d-flex justify-content-between px-0">
                                <span><strong>Current Weighted Average:</strong></span>
                                <span class="text-info font-weight-bold">
                                    AED <?php echo e($inventoryDetails->sum('quantity') > 0 ? number_format($inventoryDetails->sum('total_value') / $inventoryDetails->sum('quantity'), 2) : '0.00'); ?>

                                </span>
                            </div>
                            <div class="list-group-item d-flex justify-content-between px-0">
                                <span><strong>Price Variance:</strong></span>
                                <span class="text-warning font-weight-bold">
                                    AED <?php echo e(number_format($pricingHistory->max('unit_price') - $pricingHistory->min('unit_price'), 2)); ?>

                                </span>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="text-center text-muted">
                            <p>No pricing data available</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="material-icons mr-2">donut_large</i>
                        Inventory Distribution
                    </h6>
                </div>
                <div class="card-body">
                    <?php if($inventoryDetails->count() > 0): ?>
                        <div class="list-group list-group-flush">
                            <?php $__currentLoopData = $inventoryDetails->groupBy('division'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $division => $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                                    <div>
                                        <div class="font-weight-medium"><?php echo e($division); ?></div>
                                        <small class="text-muted"><?php echo e($items->count()); ?> batches</small>
                                    </div>
                                    <div class="text-right">
                                        <div class="font-weight-bold"><?php echo e(number_format($items->sum('quantity'), 2)); ?> <?php echo e($item->unit_of_measure); ?></div>
                                        <small class="text-muted">AED <?php echo e(number_format($items->sum('total_value'), 2)); ?></small>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <div class="text-center text-muted">
                            <p>No inventory distribution data available</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <style>
        .table-borderless td {
            border: none;
            padding: 0.25rem 0.5rem;
        }

        .badge-outline-primary {
            color: #007bff;
            border: 1px solid #007bff;
            background-color: transparent;
        }

        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
            font-size: 12px;
        }

        .table td {
            font-size: 13px;
            vertical-align: middle;
        }

        .list-group-item {
            border-left: none;
            border-right: none;
        }

        code {
            font-size: 12px;
            color: #6c757d;
            background-color: #f8f9fa;
            padding: 2px 6px;
            border-radius: 3px;
        }

        .table-danger {
            background-color: rgba(220, 53, 69, 0.1);
        }

        .table-warning {
            background-color: rgba(255, 193, 7, 0.1);
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        function printItemDetails() {
            window.print();
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/reports/inventory-details.blade.php ENDPATH**/ ?>