<?php $__env->startSection('title', 'Incoming Operations'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item active">Incoming Operations</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title-left">
        <h3 class="mb-1">Incoming Operations</h3>
        <p class="text-muted mb-0" style="font-size: 13px;">Enhanced construction materials receiving system</p>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Layout Debug Info -->
    <div class="alert alert-info mb-4">
        <strong>Debug Info:</strong>
        Layout loaded successfully. If you can see this message and the navigation sidebar, the layout is working correctly.
        <br><small>Current route: <?php echo e(request()->route()->getName()); ?></small>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total Operations','value' => $operations->count() ?? 0,'icon' => 'input','color' => 'primary','subtitle' => 'All incoming operations']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total Operations','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($operations->count() ?? 0),'icon' => 'input','color' => 'primary','subtitle' => 'All incoming operations']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Direct Processing','value' => $operations->whereIn('operation_type', ['supplier_delivery', 'site_return'])->count() ?? 0,'icon' => 'flash_on','color' => 'warning','subtitle' => 'Auto-processed operations']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Direct Processing','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($operations->whereIn('operation_type', ['supplier_delivery', 'site_return'])->count() ?? 0),'icon' => 'flash_on','color' => 'warning','subtitle' => 'Auto-processed operations']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Pending Review','value' => $operations->whereIn('status', ['pending_inspection', 'approved'])->count() ?? 0,'icon' => 'check_circle','color' => 'success','subtitle' => 'Needs manual approval']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Pending Review','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($operations->whereIn('status', ['pending_inspection', 'approved'])->count() ?? 0),'icon' => 'check_circle','color' => 'success','subtitle' => 'Needs manual approval']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Completed','value' => $operations->where('status', 'completed')->count() ?? 0,'icon' => 'done_all','color' => 'info','subtitle' => 'Inventory updated']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Completed','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($operations->where('status', 'completed')->count() ?? 0),'icon' => 'done_all','color' => 'info','subtitle' => 'Inventory updated']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
    </div>

    <!-- Simple Operations List -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">list</i>
                Operations List
            </h5>
        </div>
        <div class="card-body">
            <?php if($operations->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Operation #</th>
                                <th>Type</th>
                                <th>Date</th>
                                <th>Supplier/Source</th>
                                <th>Status</th>
                                <th>Total (AED)</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $operations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $operation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($operation->operation_number); ?></td>
                                    <td>
                                        <span class="badge badge-primary">
                                            <?php echo e(ucfirst(str_replace('_', ' ', $operation->operation_type))); ?>

                                        </span>
                                    </td>
                                    <td><?php echo e($operation->operation_date); ?></td>
                                    <td><?php echo e($operation->supplier->name ?? '-'); ?></td>
                                    <td>
                                        <span class="badge badge-<?php echo e($operation->status === 'completed' ? 'success' : ($operation->status === 'pending_inspection' ? 'warning' : 'secondary')); ?>">
                                            <?php echo e(ucfirst(str_replace('_', ' ', $operation->status))); ?>

                                        </span>
                                    </td>
                                    <td><?php echo e(number_format($operation->total_amount_aed ?? 0, 2)); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('warehouse.incoming-operations.show', $operation->id)); ?>" class="btn btn-sm btn-outline-primary">
                                            <i class="material-icons" style="font-size: 16px;">visibility</i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <?php if($operations->hasPages()): ?>
                    <div class="d-flex justify-content-center mt-4">
                        <?php echo e($operations->links()); ?>

                    </div>
                <?php endif; ?>
            <?php else: ?>
                <div class="text-center py-4">
                    <i class="material-icons text-muted mb-3" style="font-size: 48px;">inbox</i>
                    <h5 class="text-muted">No Operations Found</h5>
                    <p class="text-muted mb-4">There are no incoming operations to display.</p>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.incoming.create')): ?>
                        <a href="<?php echo e(route('warehouse.incoming-operations.create', ['type' => 'supplier_delivery'])); ?>" class="btn btn-primary">
                            <i class="material-icons mr-1">add</i>
                            Create First Operation
                        </a>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- JavaScript Debug -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            console.log('✅ Incoming Operations page loaded successfully');
            console.log('✅ Layout structure:', {
                header: document.querySelector('#header') ? 'Found' : 'Missing',
                sidebar: document.querySelector('.mdk-drawer') ? 'Found' : 'Missing',
                content: document.querySelector('.page') ? 'Found' : 'Missing',
                preloader: document.querySelector('.preloader') ? 'Found' : 'Missing'
            });

            // Hide preloader if it's still showing
            const preloader = document.querySelector('.preloader');
            if (preloader) {
                setTimeout(() => {
                    preloader.style.display = 'none';
                }, 1000);
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <style>
        .icon {
            width: 3rem;
            height: 3rem;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .icon-shape {
            padding: 12px;
            text-align: center;
            display: inline-flex;
            align-items: center;
            justify-content: center;
        }

        .bg-primary {
            background-color: #5e72e4 !important;
        }

        .bg-warning {
            background-color: #fb6340 !important;
        }

        .bg-success {
            background-color: #2dce89 !important;
        }

        .bg-info {
            background-color: #11cdef !important;
        }

        .rounded-circle {
            border-radius: 50% !important;
        

        .shadow {
            box-shadow: 0 0.15rem 1.75rem 0 rgba(33, 40, 50, 0.15) !important;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/incoming-operations/index.blade.php ENDPATH**/ ?>