<?php $__env->startSection('title', 'New Supplier Delivery'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('warehouse.supplier-delivery.index')); ?>">Supplier Delivery</a></li>
    <li class="breadcrumb-item active">New Delivery</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">New Supplier Delivery</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">Create a new supplier delivery operation</p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <a href="<?php echo e(route('warehouse.supplier-delivery.index')); ?>" class="btn btn-sm btn-outline-secondary mr-2">
                <i class="material-icons mr-1" style="font-size: 16px;">arrow_back</i>
                Back to List
            </a>
            <button type="submit" form="deliveryForm" class="btn btn-sm btn-primary">
                <i class="material-icons mr-1" style="font-size: 16px;">save</i>
                Save Delivery
            </button>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <form id="deliveryForm" action="<?php echo e(route('warehouse.incoming-operations.store')); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="operation_type" value="supplier_delivery">

        <!-- Basic Information Card -->
        <div class="card mb-3">
            <div class="card-header">
                <h6 class="card-title mb-0 d-flex align-items-center">
                    <i class="material-icons mr-2">info</i>
                    Basic Information
                </h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="delivery_note_number">Delivery Note Number <span class="text-danger">*</span></label>
                            <input type="text" name="delivery_note_number" id="delivery_note_number"
                                   class="form-control <?php $__errorArgs = ['delivery_note_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                   placeholder="Enter delivery note number" value="<?php echo e(old('delivery_note_number')); ?>" required>
                            <?php $__errorArgs = ['delivery_note_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="operation_date">Delivery Date <span class="text-danger">*</span></label>
                            <input type="date" name="operation_date" id="operation_date"
                                   class="form-control <?php $__errorArgs = ['operation_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                   value="<?php echo e(old('operation_date', date('Y-m-d'))); ?>" required>
                            <?php $__errorArgs = ['operation_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="lpo_number">LPO Number</label>
                            <input type="text" name="lpo_number" id="lpo_number"
                                   class="form-control <?php $__errorArgs = ['lpo_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                   placeholder="Enter LPO Number" value="<?php echo e(old('lpo_number')); ?>">
                            <?php $__errorArgs = ['lpo_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <?php
                            $supplierCreateOptions = [['value' => '', 'text' => 'Select Supplier']];
                            foreach($suppliers ?? [] as $supplier) {
                                $supplierCreateOptions[] = [
                                    'value' => $supplier->id,
                                    'text' => $supplier->name . ' (' . $supplier->supplier_code . ')'
                                ];
                            }
                        ?>
                        <?php if (isset($component)) { $__componentOriginal6c49fce73979297b67c6317948ab8eae = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6c49fce73979297b67c6317948ab8eae = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.select2-dropdown','data' => ['name' => 'supplier_id','id' => 'supplier_id','label' => 'Supplier Name','placeholder' => 'Select Supplier','options' => $supplierCreateOptions,'selected' => old('supplier_id'),'required' => 'true','errorField' => 'supplier_id']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.select2-dropdown'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'supplier_id','id' => 'supplier_id','label' => 'Supplier Name','placeholder' => 'Select Supplier','options' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($supplierCreateOptions),'selected' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(old('supplier_id')),'required' => 'true','errorField' => 'supplier_id']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $attributes = $__attributesOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__attributesOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $component = $__componentOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__componentOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="division">Division <span class="text-danger">*</span></label>
                            <input type="text" name="division" id="division"
                                   class="form-control <?php $__errorArgs = ['division'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                   placeholder="Enter division" value="<?php echo e(old('division')); ?>" required>
                            <?php $__errorArgs = ['division'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>

            </div>
        </div>


        <!-- Materials & Items Card -->
        <div class="card mb-3">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h6 class="card-title mb-0 d-flex align-items-center">
                    <i class="material-icons mr-2">inventory</i>
                    Materials & Items
                </h6>
                <button type="button" onclick="addItemRow()" class="btn btn-sm btn-primary">
                    <i class="material-icons mr-1" style="font-size: 14px;">add</i>
                    Add Item
                </button>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-sm mb-0" id="items-table">
                        <thead class="bg-light">
                            <tr>
                                <th style="width: 25%">Item</th>
                                <th style="width: 10%">Quantity</th>
                                <th style="width: 8%">Unit</th>
                                <th style="width: 12%">Unit Price</th>
                                <th style="width: 12%">Total Price</th>
                                <th style="width: 12%">Batch Number</th>
                                <th style="width: 10%">Production Date</th>
                                <th style="width: 10%">Expiry Date</th>
                                <th style="width: 8%">Actions</th>
                            </tr>
                        </thead>
                        <tbody id="items-tbody">
                            <!-- Item rows will be added here -->
                        </tbody>
                        <tfoot class="bg-light">
                            <tr>
                                <td colspan="4" class="text-right font-weight-bold">Total Amount (AED):</td>
                                <td class="font-weight-bold text-success">
                                    <span id="total-amount">0.00</span>
                                    <input type="hidden" name="total_amount" id="total_amount_input" value="0">
                                </td>
                                <td colspan="4"></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>

        <!-- Received By & Additional Information Card -->
        <div class="card mb-3">
            <div class="card-header">
                <h6 class="card-title mb-0 d-flex align-items-center">
                    <i class="material-icons mr-2">person</i>
                    Received By & Additional Information
                </h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <?php
                            $userCreateOptions = [['value' => '', 'text' => 'Select User']];
                            foreach($users ?? [] as $user) {
                                $userCreateOptions[] = [
                                    'value' => $user->id,
                                    'text' => $user->name
                                ];
                            }
                        ?>
                        <?php if (isset($component)) { $__componentOriginal6c49fce73979297b67c6317948ab8eae = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6c49fce73979297b67c6317948ab8eae = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.select2-dropdown','data' => ['name' => 'received_by','id' => 'received_by','label' => 'Received By','placeholder' => 'Select User','options' => $userCreateOptions,'selected' => old('received_by'),'errorField' => 'received_by']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.select2-dropdown'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'received_by','id' => 'received_by','label' => 'Received By','placeholder' => 'Select User','options' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($userCreateOptions),'selected' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(old('received_by')),'errorField' => 'received_by']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $attributes = $__attributesOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__attributesOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $component = $__componentOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__componentOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="received_by_name">Received By Name</label>
                            <input type="text" name="received_by_name" id="received_by_name"
                                   class="form-control <?php $__errorArgs = ['received_by_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                   placeholder="Enter full name" value="<?php echo e(old('received_by_name', auth()->user()->name ?? '')); ?>">
                            <?php $__errorArgs = ['received_by_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label for="notes">Notes</label>
                    <textarea name="notes" id="notes" class="form-control <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                              rows="3" placeholder="Enter any additional notes or comments"><?php echo e(old('notes')); ?></textarea>
                    <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-check">
                            <input type="checkbox" name="regulatory_compliant" id="regulatory_compliant"
                                   class="form-check-input" value="1" <?php echo e(old('regulatory_compliant') ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="regulatory_compliant">
                                Regulatory Compliant
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Form Actions -->
        <div class="card">
            <div class="card-body text-center py-3">
                <button type="submit" class="btn btn-primary mr-3">
                    <i class="material-icons mr-1" style="font-size: 16px;">save</i>
                    Save as Draft
                </button>
                <button type="button" onclick="saveAndComplete()" class="btn btn-success mr-3">
                    <i class="material-icons mr-1" style="font-size: 16px;">check_circle</i>
                    Save & Mark as Delivered
                </button>
                <a href="<?php echo e(route('warehouse.supplier-delivery.index')); ?>" class="btn btn-outline-secondary">
                    <i class="material-icons mr-1" style="font-size: 16px;">cancel</i>
                    Cancel
                </a>
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css">
    <style>
        .form-group label {
            font-weight: 600;
            color: #495057;
            font-size: 14px;
        }

        .card-title {
            font-size: 16px;
            font-weight: 600;
            color: #495057;
        }

        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
            background-color: #f8f9fa;
            font-size: 13px;
        }

        .table td {
            vertical-align: middle;
            font-size: 13px;
        }

        .btn-sm {
            padding: 6px 12px;
            font-size: 12px;
            line-height: 1.5;
        }

        .btn-sm .material-icons {
            font-size: 16px !important;
        }

        .form-control-sm {
            height: calc(1.5em + 0.5rem + 2px);
            padding: 0.25rem 0.5rem;
            font-size: 0.875rem;
        }

        .item-row {
            border-bottom: 1px solid #dee2e6;
        }

        .item-row:hover {
            background-color: #f8f9fa;
        }

        .select2-container .select2-selection--single {
            height: 38px;
            border: 1px solid #ced4da;
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: 36px;
        }

        .text-danger {
            color: #dc3545 !important;
        }

        .text-success {
            color: #28a745 !important;
        }

        .invalid-feedback {
            display: block;
        }

        /* Force Select2 dropdown to appear below */
        .select2-container--open .select2-dropdown {
            top: 100% !important;
            bottom: auto !important;
            margin-top: 1px !important;
        }

        /* Force dropdown direction to be below */
        .select2-container--open .select2-dropdown--below {
            top: 100% !important;
            border-top: none !important;
            border-top-left-radius: 0 !important;
            border-top-right-radius: 0 !important;
        }

        /* Hide dropdown above option */
        .select2-container--open .select2-dropdown--above {
            display: none !important;
        }

        /* Custom width for item selection dropdowns in table */
        #items-table .select2-container {
            width: 90% !important;
            max-width: 300px !important;
            min-width: 200px !important;
        }

        /* Custom width for other dropdowns */
        .form-group .select2-container {
            width: 70% !important;
            max-width: 350px !important;
            min-width: 250px !important;
        }

        /* Ensure dropdown doesn't get cut off */
        .table-responsive {
            overflow: visible !important;
        }

        #items-table {
            overflow: visible !important;
        }

        /* Specific positioning for item dropdowns in table */
        #items-tbody .select2-container {
            position: relative !important;
        }

        #items-tbody .select2-dropdown {
            position: absolute !important;
            top: 100% !important;
            z-index: 9999 !important;
            width: 100% !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        let itemRowCounter = 0;
        let availableItems = <?php echo json_encode($items ?? [], 15, 512) ?>;

        $(document).ready(function() {
            // Initialize Select2
            $('#supplier_id, #received_by').select2({
                placeholder: 'Please select...',
                allowClear: true,
                width: '70%',
                language: {
                    noResults: function() {
                        return 'No results found';
                    },
                    searching: function() {
                        return 'Searching...';
                    }
                }
            });

            // Items are already loaded from PHP

            // Auto-fill received by name when user is selected
            $('#received_by').change(function() {
                const selectedOption = $(this).find('option:selected');
                if (selectedOption.val()) {
                    $('#received_by_name').val(selectedOption.text());
                }
            });

            // Add initial item row
            addItemRow();
        });



        function addItemRow() {
            itemRowCounter++;
            const rowHtml = `
                <tr class="item-row" data-row="${itemRowCounter}">
                    <td>
                        <select name="items[${itemRowCounter}][item_id]" id="item_select_${itemRowCounter}" class="form-control form-control-sm item-select select2-dropdown" required>
                            <option value="">Select Item</option>
                            ${availableItems.map(item => `<option value="${item.id}" data-unit="${item.unit_of_measure}">${item.item_description} (${item.item_code})</option>`).join('')}
                        </select>
                    </td>
                    <td>
                        <input type="number" name="items[${itemRowCounter}][quantity_delivered]" class="form-control form-control-sm quantity"
                               placeholder="0" step="0.01" min="0" required>
                    </td>
                    <td>
                        <input type="text" name="items[${itemRowCounter}][unit]" class="form-control form-control-sm unit-field"
                               placeholder="Unit" readonly>
                    </td>
                    <td>
                        <input type="number" name="items[${itemRowCounter}][unit_price]" class="form-control form-control-sm unit-price"
                               placeholder="0.00" step="0.01" min="0" required>
                    </td>
                    <td>
                        <input type="number" name="items[${itemRowCounter}][total_price]" class="form-control form-control-sm total-price"
                               placeholder="0.00" step="0.01" min="0" readonly>
                    </td>
                    <td>
                        <input type="text" name="items[${itemRowCounter}][batch_number]" class="form-control form-control-sm"
                               placeholder="Batch">
                    </td>
                    <td>
                        <input type="date" name="items[${itemRowCounter}][production_date]" class="form-control form-control-sm">
                    </td>
                    <td>
                        <input type="date" name="items[${itemRowCounter}][expiry_date]" class="form-control form-control-sm">
                    </td>
                    <td>
                        <button type="button" onclick="removeItemRow(${itemRowCounter})" class="btn btn-sm btn-outline-danger">
                            <i class="material-icons" style="font-size: 14px;">delete</i>
                        </button>
                    </td>
                </tr>
            `;

            $('#items-tbody').append(rowHtml);

            // Bind events to new row
            bindRowEvents(itemRowCounter);

            // Initialize Select2 for the new item dropdown
            initializeSelect2ForRow(itemRowCounter);
        }

        // Initialize Select2 for a specific row
        function initializeSelect2ForRow(rowIndex) {
            const selectId = `#item_select_${rowIndex}`;

            // Initialize Select2
            $(selectId).select2({
                placeholder: 'Select Item',
                allowClear: true,
                theme: 'default',
                width: '90%',
                dropdownAutoWidth: false,
                language: {
                    noResults: function() {
                        return 'No results found';
                    },
                    searching: function() {
                        return 'Searching...';
                    }
                },
                dropdownCssClass: 'select2-dropdown-below',
                adaptDropdownCssClass: function(cssClass) {
                    return 'select2-dropdown-below';
                }
            });

            // Force dropdown to open below
            $(selectId).on('select2:open', function() {
                const dropdown = $('.select2-dropdown');
                dropdown.removeClass('select2-dropdown--above').addClass('select2-dropdown--below');
                dropdown.css({
                    'top': '100%',
                    'bottom': 'auto'
                });
            });

            // Prevent Select2 events from interfering with Bootstrap dropdowns
            $(selectId).on('select2:open select2:close', function(e) {
                e.stopPropagation();
            });

            // Handle dropdown clicks to prevent Bootstrap dropdown interference
            $(selectId).next('.select2-container').on('click', function(e) {
                e.stopPropagation();
            });
        }

        function bindRowEvents(rowCounter) {
            const row = $(`.item-row[data-row="${rowCounter}"]`);

            // Update unit when item is selected
            row.find('.item-select').change(function() {
                const selectedOption = $(this).find('option:selected');
                const unit = selectedOption.data('unit');
                row.find('.unit-field').val(unit || '');
            });

            // Calculate line total when quantity or price changes
            row.find('.quantity, .unit-price').on('input', function() {
                const quantity = parseFloat(row.find('.quantity').val()) || 0;
                const unitPrice = parseFloat(row.find('.unit-price').val()) || 0;
                const total = quantity * unitPrice;

                row.find('.total-price').val(total.toFixed(2));
                calculateTotals();
            });
        }

        function removeItemRow(rowCounter) {
            // Destroy Select2 instance before removing the row
            const selectElement = $(`#item_select_${rowCounter}`);
            if (selectElement.length && selectElement.hasClass('select2-hidden-accessible')) {
                selectElement.select2('destroy');
            }

            $(`.item-row[data-row="${rowCounter}"]`).remove();
            calculateTotals();
        }

        function calculateTotals() {
            let total = 0;

            $('.total-price').each(function() {
                const value = parseFloat($(this).val()) || 0;
                total += value;
            });

            $('#total-amount').text(total.toFixed(2));
            $('#total_amount_input').val(total);
        }

        function saveAndComplete() {
            $('#status').val('delivered');
            $('#deliveryForm').submit();
        }

        // Form validation
        $('#deliveryForm').on('submit', function(e) {
            const itemsCount = $('#items-tbody tr').length;
            if (itemsCount === 0) {
                e.preventDefault();
                alert('Please add at least one item to the delivery.');
                return false;
            }
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/supplier-delivery/create.blade.php ENDPATH**/ ?>