<?php $__env->startSection('title', 'Edit Item'); ?>
<?php $__env->startSection('page-title', 'Edit Item'); ?>
<?php $__env->startSection('page-subtitle', 'Update item information'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('warehouse.items.index')); ?>">Items</a></li>
    <li class="breadcrumb-item active">Edit</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card shadow mb-4">
                <div class="card-header py-3 d-flex justify-content-between align-items-center">
                    <h6 class="m-0 font-weight-bold text-primary">Edit Item Information</h6>
                    <span class="text-muted"><?php echo e($item->item_code); ?></span>
                </div>

                <div class="card-body">
                    <form action="<?php echo e(route('warehouse.items.update', $item->id)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        <!-- Basic Information -->
                        <div class="mb-4">
                            <h6 class="text-primary font-weight-bold mb-3">Basic Information</h6>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="item_code" class="form-label">Item Code</label>
                                    <input type="text" name="item_code" id="item_code"
                                           class="form-control <?php $__errorArgs = ['item_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           value="<?php echo e(old('item_code', $item->item_code)); ?>">
                                    <?php $__errorArgs = ['item_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php if (isset($component)) { $__componentOriginal6c49fce73979297b67c6317948ab8eae = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6c49fce73979297b67c6317948ab8eae = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.select2-dropdown','data' => ['name' => 'category_id','id' => 'category_id','label' => 'Category','placeholder' => 'Select Category','options' => collect($categories)->map(fn($cat) => ['value' => $cat->id, 'text' => $cat->category_name])->prepend(['value' => '', 'text' => 'Select Category'])->toArray(),'selected' => old('category_id', $item->category_id),'required' => 'true']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.select2-dropdown'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'category_id','id' => 'category_id','label' => 'Category','placeholder' => 'Select Category','options' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(collect($categories)->map(fn($cat) => ['value' => $cat->id, 'text' => $cat->category_name])->prepend(['value' => '', 'text' => 'Select Category'])->toArray()),'selected' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(old('category_id', $item->category_id)),'required' => 'true']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $attributes = $__attributesOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__attributesOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $component = $__componentOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__componentOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="item_description" class="form-label">Item Description <span class="text-danger">*</span></label>
                                    <input type="text" name="item_description" id="item_description"
                                           class="form-control <?php $__errorArgs = ['item_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           value="<?php echo e(old('item_description', $item->item_description)); ?>" required>
                                    <?php $__errorArgs = ['item_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <?php if (isset($component)) { $__componentOriginal6c49fce73979297b67c6317948ab8eae = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6c49fce73979297b67c6317948ab8eae = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.select2-dropdown','data' => ['name' => 'unit_id','id' => 'unit_id','label' => 'Unit of Measure','placeholder' => 'Select Unit','options' => $units,'selected' => old('unit_id', $item->unit_id),'required' => 'true']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.select2-dropdown'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'unit_id','id' => 'unit_id','label' => 'Unit of Measure','placeholder' => 'Select Unit','options' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($units),'selected' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(old('unit_id', $item->unit_id)),'required' => 'true']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $attributes = $__attributesOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__attributesOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $component = $__componentOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__componentOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
                            </div>
                            <div class="col-md-6">
                                <?php if (isset($component)) { $__componentOriginal6c49fce73979297b67c6317948ab8eae = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6c49fce73979297b67c6317948ab8eae = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.select2-dropdown','data' => ['name' => 'status','id' => 'status','label' => 'Status','placeholder' => 'Select Status','options' => [
                                        ['value' => 'active', 'text' => 'Active'],
                                        ['value' => 'inactive', 'text' => 'Inactive'],
                                        ['value' => 'discontinued', 'text' => 'Discontinued']
                                    ],'selected' => old('status', $item->status),'required' => 'true']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.select2-dropdown'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'status','id' => 'status','label' => 'Status','placeholder' => 'Select Status','options' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute([
                                        ['value' => 'active', 'text' => 'Active'],
                                        ['value' => 'inactive', 'text' => 'Inactive'],
                                        ['value' => 'discontinued', 'text' => 'Discontinued']
                                    ]),'selected' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(old('status', $item->status)),'required' => 'true']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $attributes = $__attributesOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__attributesOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $component = $__componentOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__componentOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
                            </div>
                        </div>

                        <!-- Stock Level Information -->
                        <div class="mb-4 mt-4">
                            <h6 class="text-primary font-weight-bold mb-3">Stock Level Information</h6>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="min_stock_level" class="form-label">Min Stock Level</label>
                                    <input type="number" name="min_stock_level" id="min_stock_level"
                                           class="form-control <?php $__errorArgs = ['min_stock_level'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           value="<?php echo e(old('min_stock_level', $item->min_stock_level)); ?>"
                                           min="0" step="0.01">
                                    <?php $__errorArgs = ['min_stock_level'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="max_stock_level" class="form-label">Max Stock Level</label>
                                    <input type="number" name="max_stock_level" id="max_stock_level"
                                           class="form-control <?php $__errorArgs = ['max_stock_level'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           value="<?php echo e(old('max_stock_level', $item->max_stock_level)); ?>"
                                           min="0" step="0.01">
                                    <?php $__errorArgs = ['max_stock_level'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="reorder_point" class="form-label">Reorder Point</label>
                                    <input type="number" name="reorder_point" id="reorder_point"
                                           class="form-control <?php $__errorArgs = ['reorder_point'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           value="<?php echo e(old('reorder_point', $item->reorder_point)); ?>"
                                           min="0" step="0.01">
                                    <?php $__errorArgs = ['reorder_point'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <!-- Additional Information -->
                        <div class="mb-4 mt-4">
                            <h6 class="text-primary font-weight-bold mb-3">Additional Information</h6>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="notes" class="form-label">Notes</label>
                                    <textarea name="notes" id="notes" rows="3"
                                              class="form-control <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                              placeholder="Optional notes about this item"><?php echo e(old('notes', $item->notes)); ?></textarea>
                                    <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-between mt-4 pt-3 border-top">
                            <a href="<?php echo e(route('warehouse.items.index')); ?>" class="btn btn-secondary">
                                <i class="material-icons mr-1" style="font-size: 16px;">cancel</i>
                                Cancel
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="material-icons mr-1" style="font-size: 16px;">save</i>
                                Update Item
                            </button>
                        </div>
                    </form>
                </div>
            </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/items/edit.blade.php ENDPATH**/ ?>